/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.repo;

import aQute.bnd.service.RepositoryPlugin;
import aQute.bnd.service.repository.SearchableRepository;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.pde.bnd.ui.model.repo.ContinueSearchElement;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryBundleVersion;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryResourceElement;
import org.eclipse.pde.bnd.ui.model.repo.RepositoryTreeContentProvider;

public class SearchableRepositoryTreeContentProvider
extends RepositoryTreeContentProvider {
    @Override
    Object[] getRepositoryBundles(RepositoryPlugin repo) {
        String filter;
        Object[] bundles;
        Object[] result = bundles = super.getRepositoryBundles(repo);
        if (repo instanceof SearchableRepository && (filter = this.getFilter()) != null && filter.length() > 0) {
            ContinueSearchElement newElem = new ContinueSearchElement(filter, (SearchableRepository)repo);
            if (bundles != null) {
                result = new Object[bundles.length + 1];
                System.arraycopy(bundles, 0, result, 0, bundles.length);
                result[bundles.length] = newElem;
            } else {
                result = new Object[]{newElem};
            }
        }
        return result;
    }

    public List<RepositoryBundleVersion> allRepoBundleVersions(RepositoryPlugin rp) {
        Object[] result = this.getChildren(rp);
        ArrayList<RepositoryBundleVersion> allChildren = new ArrayList<RepositoryBundleVersion>();
        LinkedList<Object> queue = new LinkedList<Object>();
        if (result != null) {
            queue.addAll(Arrays.asList(result));
        }
        while (!queue.isEmpty()) {
            Object currentChild = queue.poll();
            if (currentChild instanceof RepositoryBundleVersion) {
                RepositoryBundleVersion rpv = (RepositoryBundleVersion)currentChild;
                allChildren.add(rpv);
            } else if (currentChild instanceof RepositoryResourceElement) {
                RepositoryResourceElement rre = (RepositoryResourceElement)currentChild;
                allChildren.add(rre.getRepositoryBundleVersion());
            }
            Object[] childrenOfChild = this.getChildren(currentChild);
            if (childrenOfChild == null) continue;
            queue.addAll(Arrays.asList(childrenOfChild));
        }
        return allChildren;
    }
}

