/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;

public class ProcessTaskManager
implements AutoCloseable {
    private final Compiler compiler;
    private final int startingIndex;
    private volatile boolean processing;
    private final Future<?> processingTask;
    private CompilationUnitDeclaration unitWithError;
    private final BlockingQueue<Object> units;
    private static final int PROCESSED_QUEUE_SIZE = 100;
    private static final Object STOP_SIGNAL = new Object();
    private static final ExecutorService executor = Executors.newCachedThreadPool(r -> {
        Thread t = new Thread(r, "Compiler Processing Task");
        t.setDaemon(true);
        return t;
    });
    private Config sharedConfig;
    private Object lastSignal;

    private void setConfig(Config config) {
        this.sharedConfig = config;
    }

    public ProcessTaskManager(Compiler compiler, int startingIndex) {
        this.compiler = compiler;
        this.startingIndex = startingIndex;
        this.setConfig(Config.getConfig());
        this.units = new ArrayBlockingQueue<Object>(100);
        this.processing = true;
        this.processingTask = executor.submit(this::processing);
    }

    private void addNextUnit(Object newElement) {
        try {
            this.units.put(newElement);
        }
        catch (InterruptedException interrupt) {
            throw new RuntimeException(interrupt);
        }
    }

    public Collection<CompilationUnitDeclaration> removeNextUnits() throws Error, AbortCompilation {
        ArrayList<CompilationUnitDeclaration> elements = new ArrayList<CompilationUnitDeclaration>();
        Object next = this.lastSignal;
        this.lastSignal = null;
        try {
            if (next == null) {
                next = this.units.take();
            }
            while (next instanceof CompilationUnitDeclaration) {
                CompilationUnitDeclaration cu = (CompilationUnitDeclaration)next;
                elements.add(cu);
                next = this.units.poll();
            }
            if (!elements.isEmpty()) {
                if (next != null) {
                    this.lastSignal = next;
                }
                return elements;
            }
        }
        catch (InterruptedException interrupt) {
            throw new AbortCompilation(true, new RuntimeException(interrupt));
        }
        if (next instanceof Error) {
            Error error = (Error)next;
            throw error;
        }
        if (next instanceof RuntimeException) {
            RuntimeException runtimeException = (RuntimeException)next;
            throw runtimeException;
        }
        if (next == STOP_SIGNAL) {
            return Collections.emptyList();
        }
        throw new IllegalStateException("Received unexpected element to process: " + String.valueOf(next));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processing() {
        Config.addConfig(this.sharedConfig);
        try {
            int unitIndex = this.startingIndex;
            boolean noAnnotations = this.compiler.annotationProcessorManager == null;
            while (this.processing) {
                int index = unitIndex++;
                boolean cleanup = noAnnotations || this.compiler.shouldCleanup(index);
                CompilationUnitDeclaration unitToProcess = this.compiler.getUnitToProcess(index);
                try {
                    if (unitToProcess == null) {
                        break;
                    }
                    if (unitToProcess.compilationResult.hasBeenAccepted) continue;
                    try {
                        this.compiler.reportProgress(Messages.bind(Messages.compilation_processing, new String(unitToProcess.getFileName())));
                        if (this.compiler.options.verbose) {
                            this.compiler.out.println(Messages.bind(Messages.compilation_process, new String[]{String.valueOf(index + 1), String.valueOf(this.compiler.totalUnits), new String(unitToProcess.getFileName())}));
                        }
                        try {
                            this.compiler.process(unitToProcess, index);
                        }
                        catch (AbortCompilation abortCompilation) {
                            throw abortCompilation;
                        }
                        catch (Error | RuntimeException uncheckedThrowable) {
                            throw new RuntimeException("Internal Error compiling " + new String(unitToProcess.getFileName()), uncheckedThrowable);
                        }
                    }
                    finally {
                        if (cleanup) {
                            unitToProcess.cleanUp();
                        }
                    }
                    this.addNextUnit(unitToProcess);
                }
                catch (Error | RuntimeException uncheckedThrowable) {
                    this.units.clear();
                    ProcessTaskManager processTaskManager = this;
                    synchronized (processTaskManager) {
                        this.unitWithError = unitToProcess;
                    }
                    this.addNextUnit(uncheckedThrowable);
                    this.addNextUnit(STOP_SIGNAL);
                    return;
                }
            }
        }
        finally {
            this.addNextUnit(STOP_SIGNAL);
        }
    }

    synchronized CompilationUnitDeclaration getUnitWithError() {
        return this.unitWithError;
    }

    @Override
    public void close() {
        this.processing = false;
        this.units.clear();
        this.processingTask.cancel(true);
    }
}

