/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow.widgets;

import org.eclipse.nebula.widgets.opal.commons.StringUtil;
import org.eclipse.nebula.widgets.opal.preferencewindow.PreferenceWindow;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWText;

public class PWFloatText
extends PWText {
    public PWFloatText(String label, String propertyKey) {
        super(label, propertyKey);
    }

    @Override
    public void addVerifyListeners() {
        this.text.addListener(25, e -> {
            if (e.character != '\u0000' && !Character.isDigit(e.character) && e.keyCode != 8 && e.keyCode != 127 && e.character != '.' && e.character != ',') {
                e.doit = false;
                return;
            }
            e.doit = this.verifyEntry(e.text, e.keyCode);
        });
    }

    private boolean verifyEntry(String entry, int keyCode) {
        String work = keyCode == 127 ? StringUtil.removeCharAt((String)this.text.getText(), (int)this.text.getCaretPosition()) : (keyCode == 8 && this.text.getCaretPosition() == 0 ? StringUtil.removeCharAt((String)this.text.getText(), (int)(this.text.getCaretPosition() - 1)) : (keyCode == 0 ? entry : StringUtil.insertString((String)this.text.getText(), (String)entry, (int)this.text.getCaretPosition())));
        try {
            Double.parseDouble(work.replace(',', '.'));
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), Float.valueOf(0.0f));
        } else if (!(value instanceof Float)) {
            throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a Float because it is associated to a float text widget");
        }
    }

    @Override
    public Object convertValue() {
        return Float.valueOf(Float.parseFloat(this.text.getText()));
    }

    @Override
    public int getStyle() {
        return 0;
    }
}

