/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.duallist.snippets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.duallist.DLItem;
import org.eclipse.nebula.widgets.opal.duallist.DualList;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class DualListSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("Dual List Snippet");
        shell.setSize(600, 600);
        shell.setLayout((Layout)new GridLayout(1, false));
        DualList dl = new DualList((Composite)shell, 0);
        dl.setItems(DualListSnippet.createItems(shell));
        dl.addSelectionChangeListener(e -> {
            System.out.println("Selection Change Listener called");
            for (DLItem item : e.getItems()) {
                StringBuilder sb = new StringBuilder();
                if (item.getLastAction() == DLItem.LAST_ACTION.SELECTION) {
                    sb.append("[SELECTION] ");
                } else {
                    sb.append("[DE-SELECTION] ");
                }
                sb.append(item.getText());
                System.out.println(sb.toString());
            }
        });
        dl.setLayoutData((Object)new GridData(4, 4, true, true));
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static List<DLItem> createItems(Shell shell) {
        ArrayList<DLItem> list = new ArrayList<DLItem>();
        String defaultFontName = null;
        int defaultHeight = -1;
        FontData[] fontDataArray = shell.getFont().getFontData();
        int n = fontDataArray.length;
        int n2 = 0;
        while (n2 < n) {
            FontData fontData = fontDataArray[n2];
            if (defaultFontName == null) {
                defaultFontName = fontData.getName();
            }
            if (defaultHeight == -1) {
                defaultHeight = fontData.getHeight();
            }
            ++n2;
        }
        Font font = new Font((Device)shell.getDisplay(), defaultFontName, defaultHeight, 1);
        list.add(new DLItem("Austria", DualListSnippet.createImage(shell, "austria")));
        list.add(new DLItem("Belgium", DualListSnippet.createImage(shell, "belgium")));
        list.add(new DLItem("Bulgaria", DualListSnippet.createImage(shell, "bulgaria")));
        list.add(new DLItem("Cyprus", DualListSnippet.createImage(shell, "cyprus")));
        list.add(new DLItem("Czech Republic", DualListSnippet.createImage(shell, "czech")));
        list.add(new DLItem("Denmark", DualListSnippet.createImage(shell, "denmark")));
        list.add(new DLItem("Estonia", DualListSnippet.createImage(shell, "estonia")));
        list.add(new DLItem("Finland", DualListSnippet.createImage(shell, "finland")));
        list.add(new DLItem("France", DualListSnippet.createImage(shell, "france"), font));
        list.add(new DLItem("Germany", DualListSnippet.createImage(shell, "germany")));
        list.add(new DLItem("Greece", DualListSnippet.createImage(shell, "greece")));
        list.add(new DLItem("Hungary", DualListSnippet.createImage(shell, "hungary")));
        list.add(new DLItem("Ireland", DualListSnippet.createImage(shell, "ireland")));
        list.add(new DLItem("Italy", DualListSnippet.createImage(shell, "italy")));
        list.add(new DLItem("Latvia", DualListSnippet.createImage(shell, "latvia")));
        list.add(new DLItem("Lithuania", DualListSnippet.createImage(shell, "lithuania")));
        list.add(new DLItem("Luxembourg", DualListSnippet.createImage(shell, "luxembourg")));
        list.add(new DLItem("Malta", DualListSnippet.createImage(shell, "malta")));
        list.add(new DLItem("Netherlands", DualListSnippet.createImage(shell, "netherlands")));
        list.add(new DLItem("Poland", DualListSnippet.createImage(shell, "poland"), shell.getDisplay().getSystemColor(1), shell.getDisplay().getSystemColor(3)));
        list.add(new DLItem("Portugal", DualListSnippet.createImage(shell, "portugal")));
        list.add(new DLItem("Romania", DualListSnippet.createImage(shell, "romania")));
        list.add(new DLItem("Slovakia", DualListSnippet.createImage(shell, "slovakia")));
        list.add(new DLItem("Slovenia", DualListSnippet.createImage(shell, "slovenia")));
        list.add(new DLItem("Spain", DualListSnippet.createImage(shell, "spain")));
        list.add(new DLItem("Sweden", DualListSnippet.createImage(shell, "sweden")));
        list.add(new DLItem("United Kingdom", DualListSnippet.createImage(shell, "unitedkingdom")));
        shell.addDisposeListener(e -> font.dispose());
        return list;
    }

    private static Image createImage(Shell shell, String fileName) {
        Image image = new Image((Device)shell.getDisplay(), DualListSnippet.class.getResourceAsStream("flags/" + fileName + ".png"));
        shell.addDisposeListener(e -> image.dispose());
        return image;
    }
}

