/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.preferencewindow.FlatButton;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWTab;
import org.eclipse.nebula.widgets.opal.preferencewindow.PreferenceWindow;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

class PWTabContainer
extends Composite {
    private final List<PWTab> tabs = new ArrayList<PWTab>();
    private Composite container;
    private final List<FlatButton> buttons;
    private Composite buttonContainer;
    private final Color grey;

    PWTabContainer(Composite parent, int style, List<PWTab> tabs) {
        super(parent, style);
        this.tabs.addAll(tabs);
        this.buttons = new ArrayList<FlatButton>();
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        this.grey = new Color((Device)this.getDisplay(), 204, 204, 204);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource[])new Resource[]{this.grey});
    }

    void build() {
        this.createButtonsContainer();
        this.createButtons();
        this.createContentContainer();
        this.select(PreferenceWindow.getInstance().getSelectedTab());
    }

    private void createButtonsContainer() {
        this.createContainer();
        this.createButtonsContainerBackground();
    }

    private void createContainer() {
        this.buttonContainer = new Composite((Composite)this, 0);
        GridData buttonContainerGridData = new GridData(4, 4, true, false, 2, 1);
        this.buttonContainer.setLayoutData((Object)buttonContainerGridData);
        this.buttonContainer.setBackground(this.getDisplay().getSystemColor(1));
        GridLayout gridLayout = new GridLayout(this.tabs.size(), false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 2;
        this.buttonContainer.setLayout((Layout)gridLayout);
    }

    private void createButtonsContainerBackground() {
        this.buttonContainer.addListener(11, event -> {
            Rectangle rect = this.buttonContainer.getClientArea();
            Image image = new Image((Device)this.getDisplay(), Math.max(1, rect.width), Math.max(1, rect.height));
            GC gc = new GC((Drawable)image);
            gc.setForeground(this.grey);
            gc.drawLine(0, rect.height - 1, rect.width, rect.height - 1);
            gc.dispose();
            if (this.buttonContainer.getBackgroundImage() != null && !this.buttonContainer.getBackgroundImage().isDisposed()) {
                this.buttonContainer.getBackgroundImage().dispose();
            }
            this.buttonContainer.setBackgroundImage(image);
        });
    }

    private void createButtons() {
        int i = 0;
        while (i < this.tabs.size()) {
            PWTab tab = this.tabs.get(i);
            FlatButton button = new FlatButton(this.buttonContainer, 0);
            button.setText(tab.getText());
            button.setImage(tab.getImage());
            GridData gd = i == this.tabs.size() - 1 ? new GridData(1, 1, true, false) : new GridData(1, 1, false, false);
            if (i == 0) {
                gd.horizontalIndent = 5;
            }
            gd.widthHint = 75;
            button.setLayoutData(gd);
            int index = i++;
            button.addListener(13, e -> this.select(index));
            this.buttons.add(button);
        }
    }

    void select(int index) {
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.tabs.get(index).build(this.container);
        this.container.layout();
        int i = 0;
        while (i < this.buttons.size()) {
            this.buttons.get(i).setSelection(i == index);
            ++i;
        }
    }

    private void createContentContainer() {
        this.container = new Composite((Composite)this, 0);
        GridData tempContainer = new GridData(4, 4, true, true, 2, 1);
        tempContainer.widthHint = 700;
        tempContainer.heightHint = 550;
        this.container.setLayoutData((Object)tempContainer);
    }
}

