/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.effects.stw.ImageCapture;
import org.eclipse.nebula.effects.stw.ImageTransitionable;
import org.eclipse.nebula.effects.stw.Transition;
import org.eclipse.nebula.effects.stw.TransitionListener;
import org.eclipse.nebula.effects.stw.Transitionable;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;

public class TransitionManager {
    private int _lastItem = -1;
    Color backgroundColor;
    Image backgroundImage;
    private Transitionable _transitionable;
    private Transition _transition;
    private List<TransitionListener> _listeners;
    private int _transitionsBeingProcessed = 0;
    private Map<Integer, Image> _images = new HashMap<Integer, Image>();

    public TransitionManager(final Transitionable transitionable) {
        this._transitionable = transitionable;
        this._listeners = new ArrayList<TransitionListener>();
        this.backgroundColor = Display.getCurrent().getSystemColor(22);
        this._lastItem = transitionable.getSelection();
        transitionable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    int currentItem = TransitionManager.this._transitionable.getSelection();
                    TransitionManager.this.startTransition(TransitionManager.this._lastItem, currentItem, transitionable.getDirection(currentItem, TransitionManager.this._lastItem));
                    TransitionManager.this._lastItem = currentItem;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public TransitionManager(final CTabFolder tabFolder) {
        this(new Transitionable(){

            @Override
            public void addSelectionListener(SelectionListener listener) {
                tabFolder.addSelectionListener(listener);
            }

            @Override
            public Control getControl(int index) {
                return tabFolder.getItem(index).getControl();
            }

            @Override
            public Composite getComposite() {
                return tabFolder;
            }

            @Override
            public int getSelection() {
                return tabFolder.getSelectionIndex();
            }

            @Override
            public void setSelection(int index) {
                tabFolder.setSelection(index);
            }

            @Override
            public double getDirection(int toIndex, int fromIndex) {
                return toIndex > fromIndex ? 0.0 : 180.0;
            }
        });
    }

    public TransitionManager(final TabFolder tabFolder) {
        this(new Transitionable(){

            @Override
            public void addSelectionListener(SelectionListener listener) {
                tabFolder.addSelectionListener(listener);
            }

            @Override
            public Control getControl(int index) {
                return tabFolder.getItem(index).getControl();
            }

            @Override
            public Composite getComposite() {
                return tabFolder;
            }

            @Override
            public int getSelection() {
                return tabFolder.getSelectionIndex();
            }

            @Override
            public void setSelection(int index) {
                tabFolder.setSelection(index);
            }

            @Override
            public double getDirection(int toIndex, int fromIndex) {
                return toIndex > fromIndex ? 0.0 : 180.0;
            }
        });
    }

    public void startTransition(int fromIndex, int toIndex, double direction) {
        ++this._transitionsBeingProcessed;
        try {
            this._transitionable.setSelection(fromIndex);
            Control from = this._transitionable.getControl(fromIndex);
            Rectangle fromSize = from.getBounds();
            Image imgFrom = new Image((Device)from.getDisplay(), fromSize.width, fromSize.height);
            GC gcfrom = new GC((Drawable)from);
            from.update();
            gcfrom.copyArea(imgFrom, 0, 0);
            if (this._transitionsBeingProcessed == 1) {
                this.updateControlImage(imgFrom, fromIndex);
            }
            gcfrom.dispose();
            Control to = this._transitionable.getControl(toIndex);
            Image imgTo = null;
            Rectangle toSize = to.getBounds();
            Image ctrlImgTo = this.getControlImage(toIndex);
            boolean wasControlImageUsed = false;
            if (ctrlImgTo != null && fromIndex != toIndex) {
                Rectangle imgSize = ctrlImgTo.getBounds();
                if (this._transitionable instanceof ImageTransitionable || imgSize.width == toSize.width && imgSize.height == toSize.height) {
                    imgTo = new Image((Device)to.getDisplay(), toSize.width, toSize.height);
                    GC gcto = new GC((Drawable)imgTo);
                    gcto.drawImage(ctrlImgTo, 0, 0, imgSize.width, imgSize.height, 0, 0, toSize.width, toSize.height);
                    gcto.dispose();
                    wasControlImageUsed = true;
                }
            }
            if (!wasControlImageUsed) {
                this._transitionable.setSelection(toIndex);
                imgTo = ImageCapture.getImage(to, toSize.width, toSize.height, true);
                this._transitionable.setSelection(fromIndex);
            }
            Canvas canvas = new Canvas(this._transitionable.getComposite(), 0x20000000);
            canvas.moveAbove(null);
            canvas.setBounds(to.getBounds());
            this._transition.start(imgFrom, imgTo, canvas, direction);
            this._transitionable.setSelection(toIndex);
            canvas.dispose();
            imgTo.dispose();
            for (TransitionListener tl : this._listeners) {
                tl.transitionFinished(this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        --this._transitionsBeingProcessed;
    }

    private void updateControlImage(Image img, int ctrlIndex) {
        Image previousImg = this._images.put(ctrlIndex, img);
        if (previousImg != null && !previousImg.equals((Object)img)) {
            previousImg.dispose();
        }
    }

    private Image getControlImage(int ctrlIndex) {
        return this._images.get(ctrlIndex);
    }

    public void setControlImages(Image[] images) {
        this.clearControlImages();
        int i = 0;
        while (i < images.length) {
            this._images.put(i, new Image(images[i].getDevice(), images[i].getImageData()));
            ++i;
        }
    }

    public void clearControlImages() {
        for (Image image : this._images.values()) {
            image.dispose();
        }
        this._images.clear();
    }

    public void finalize() {
        this.clearControlImages();
    }

    public void setTransition(Transition transition) {
        this._transition = transition;
    }

    public Transition getTransition() {
        return this._transition;
    }

    public void setBackground(Color color) {
        this.backgroundColor = color;
    }

    public Color getBackground() {
        return this.backgroundColor;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImage = image;
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public Transitionable getTransitionable() {
        return this._transitionable;
    }

    public void addTransitionListener(TransitionListener transitionListener) {
        this._listeners.add(transitionListener);
    }

    public void removeTransitionListener(TransitionListener transitionListener) {
        this._listeners.remove(transitionListener);
    }
}

