/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.outline;

import com.google.inject.Inject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.ide.outline.XtendFeatureNode;
import org.eclipse.xtext.ui.PluginImageHelper;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.actions.AbstractFilterOutlineContribution;
import org.eclipse.xtext.ui.editor.outline.impl.OutlineFilterAndSorter;

public class ShowSyntheticMembersContribution
extends AbstractFilterOutlineContribution {
    public static final String PREFERENCE_KEY = "ui.outline.filterSynthetic";
    @Inject
    private PluginImageHelper imageHelper;
    private OutlineFilterAndSorter.IFilter filter;

    public OutlineFilterAndSorter.IFilter getFilter() {
        if (this.filter == null) {
            this.filter = new OutlineFilterAndSorter.IFilter(){

                public boolean apply(IOutlineNode node) {
                    return ShowSyntheticMembersContribution.this.apply(node);
                }

                public boolean isEnabled() {
                    return !ShowSyntheticMembersContribution.this.isPropertySet();
                }
            };
        }
        return this.filter;
    }

    protected boolean apply(IOutlineNode node) {
        if (node instanceof XtendFeatureNode) {
            XtendFeatureNode eObjectNode = (XtendFeatureNode)node;
            return !eObjectNode.isSynthetic();
        }
        return true;
    }

    public String getPreferenceKey() {
        return PREFERENCE_KEY;
    }

    protected void configureAction(Action action) {
        action.setText("Show Synthetic Members");
        action.setDescription("Show Synthetic Members");
        action.setToolTipText("Show Synthetic Members");
        action.setImageDescriptor(this.getImageDescriptor("generated_code_view.png"));
    }

    protected ImageDescriptor getImageDescriptor(String imagePath) {
        return ImageDescriptor.createFromImage((Image)this.imageHelper.getImage(imagePath));
    }
}

