/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XbasePackage;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.scoping.batch.ITypeImporter;
import org.eclipse.xtext.xbase.scoping.batch.SimpleIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.IApplicableCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationResult;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputer;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeExpectation;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.ConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultReentrantTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ExpectedExceptionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionAwareStackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.FollowUpError;
import org.eclipse.xtext.xbase.typesystem.internal.ForwardingResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.NoTypeResult;
import org.eclipse.xtext.xbase.typesystem.internal.NullConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.NullFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.ResolutionBasedComputationResult;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedConstructor;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedFeature;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypeLiteral;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ReturnExpectationTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ScopeProviderAccess;
import org.eclipse.xtext.xbase.typesystem.internal.StackedResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeAssigner;
import org.eclipse.xtext.xbase.typesystem.internal.TypeCheckpointComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithNonVoidExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeComputationStateWithRootExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.internal.TypeInsteadOfConstructorLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.TypeLiteralLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.internal.UnresolvableConstructorCall;
import org.eclipse.xtext.xbase.typesystem.internal.UnresolvableFeatureCall;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.UnboundTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;

public abstract class AbstractTypeComputationState
implements ITypeComputationState {
    protected final ResolvedTypes resolvedTypes;
    private IFeatureScopeSession featureScopeSession;
    private final DefaultReentrantTypeResolver reentrantTypeResolver;
    private List<AbstractTypeExpectation> expectations;
    private List<AbstractTypeExpectation> returnExpectations;

    protected AbstractTypeComputationState(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession) {
        this.resolvedTypes = resolvedTypes;
        this.featureScopeSession = featureScopeSession;
        this.reentrantTypeResolver = resolvedTypes.getResolver();
    }

    public ResolvedTypes getResolvedTypes() {
        return this.resolvedTypes;
    }

    public IFeatureScopeSession getFeatureScopeSession() {
        return this.featureScopeSession;
    }

    protected TypeReferences getTypeReferences() {
        return this.reentrantTypeResolver.getServices().getTypeReferences();
    }

    protected ITypeComputer getTypeComputer() {
        return this.reentrantTypeResolver.getTypeComputer();
    }

    protected DefaultReentrantTypeResolver getResolver() {
        return this.reentrantTypeResolver;
    }

    protected abstract LightweightTypeReference acceptType(ResolvedTypes var1, AbstractTypeExpectation var2, LightweightTypeReference var3, boolean var4, int var5);

    protected abstract LightweightTypeReference acceptType(XExpression var1, ResolvedTypes var2, AbstractTypeExpectation var3, LightweightTypeReference var4, boolean var5, int var6);

    @Override
    public final ITypeComputationResult computeTypes(XExpression expression) {
        if (this.resolvedTypes.getMonitor().isCanceled()) {
            throw new OperationCanceledException();
        }
        if (expression != null) {
            if (expression.eContainer() == null && expression.eResource() == null) {
                throw new IllegalStateException("Dangling expression: " + expression);
            }
            assert (this.getResolvedTypes().doGetTypeData(expression) == null) : "Expression was already resolved: " + expression;
            ExpressionAwareStackedResolvedTypes stackedResolvedTypes = this.doComputeTypes(expression);
            stackedResolvedTypes.performMergeIntoParent();
            return new ResolutionBasedComputationResult(expression, this.resolvedTypes);
        }
        return new NoTypeResult(null, this.getReferenceOwner());
    }

    protected ExpressionAwareStackedResolvedTypes doComputeTypes(XExpression expression) {
        ExpressionAwareStackedResolvedTypes stackedResolvedTypes = this.pushTypes(expression);
        ExpressionTypeComputationState state = this.createExpressionComputationState(expression, stackedResolvedTypes);
        stackedResolvedTypes.addExpressionScope(expression, state.getFeatureScopeSession(), IExpressionScope.Anchor.BEFORE);
        this.getResolver().getTypeComputer().computeTypes(expression, state);
        stackedResolvedTypes.prepareMergeIntoParent();
        if (stackedResolvedTypes.doGetTypeData(expression) == null) {
            state.acceptActualType(stackedResolvedTypes.getReferenceOwner().newAnyTypeReference());
        }
        stackedResolvedTypes.addExpressionScope(expression, this.getFeatureScopeSession(), IExpressionScope.Anchor.AFTER);
        return stackedResolvedTypes;
    }

    protected ExpressionAwareStackedResolvedTypes pushTypes(XExpression expression) {
        return this.getResolvedTypes().pushTypes(expression);
    }

    protected ExpressionTypeComputationState createExpressionComputationState(XExpression expression, StackedResolvedTypes typeResolution) {
        return new ExpressionTypeComputationState(typeResolution, this.featureScopeSession, this, expression);
    }

    @Override
    public TypeComputationStateWithExpectation withExpectation(LightweightTypeReference expectation) {
        return new TypeComputationStateWithExpectation(this.resolvedTypes, this.featureScopeSession, this, expectation);
    }

    @Override
    public void refineExpectedType(XExpression expression, LightweightTypeReference expectation) {
        TypeExpectation typeExpectation = new TypeExpectation(expectation, this, false);
        this.getResolvedTypes().refineExpectedType(expression, typeExpectation);
    }

    @Override
    public TypeComputationStateWithRootExpectation withRootExpectation(LightweightTypeReference expectation) {
        return new TypeComputationStateWithRootExpectation(this.resolvedTypes, this.featureScopeSession, this, expectation);
    }

    @Override
    public TypeComputationStateWithRootExpectation withoutRootExpectation() {
        return new TypeComputationStateWithRootExpectation(this.resolvedTypes, this.featureScopeSession, this, null);
    }

    @Override
    public AbstractTypeComputationState withNonVoidExpectation() {
        return this.withNonVoidExpectation(this.resolvedTypes);
    }

    protected AbstractTypeComputationState withNonVoidExpectation(ResolvedTypes resolvedTypes) {
        return new TypeComputationStateWithNonVoidExpectation(resolvedTypes, this.featureScopeSession, this);
    }

    @Override
    public AbstractTypeComputationState withReturnExpectation() {
        return new ReturnExpectationTypeComputationState(this.resolvedTypes, this.featureScopeSession, this);
    }

    @Override
    public AbstractTypeComputationState withoutExpectation() {
        return new TypeComputationStateWithExpectation(this.resolvedTypes, this.featureScopeSession, this, null);
    }

    @Override
    public TypeCheckpointComputationState withTypeCheckpoint(EObject context) {
        return new TypeCheckpointComputationState(this.resolvedTypes, this.featureScopeSession, this);
    }

    @Override
    public AbstractTypeComputationState withExpectedExceptions(List<LightweightTypeReference> declaredExceptionTypes) {
        return new ExpectedExceptionTypeComputationState(this.resolvedTypes, this.featureScopeSession, this, declaredExceptionTypes);
    }

    @Override
    public AbstractTypeComputationState assignType(JvmIdentifiableElement element, LightweightTypeReference type) {
        return this.assignType(element, type, true);
    }

    @Override
    public AbstractTypeComputationState assignType(JvmIdentifiableElement element, LightweightTypeReference type, boolean addToChildScope) {
        TypeAssigner assigner = this.assignTypes();
        assigner.assignType(element, type, addToChildScope);
        return assigner.getForkedState();
    }

    @Override
    public void addLocalToCurrentScope(JvmIdentifiableElement element) {
        String simpleName = element.getSimpleName();
        if (Strings.isNullOrEmpty((String)simpleName)) {
            return;
        }
        QualifiedName elementName = QualifiedName.create((String)simpleName);
        this.addLocalToCurrentScope(elementName, element, !this.getResolver().isShadowingAllowed(elementName));
    }

    @Override
    public void addExtensionToCurrentScope(JvmIdentifiableElement extensionProvider) {
        LightweightTypeReference knownType = this.getResolvedTypes().getActualType(extensionProvider);
        if (knownType != null && !knownType.isAny() && !knownType.isUnknown()) {
            XFeatureCall prototype = this.getResolver().getXbaseFactory().createXFeatureCall();
            prototype.setFeature(extensionProvider);
            this.featureScopeSession = this.featureScopeSession.addToExtensionScope(Collections.singletonMap(prototype, knownType));
        }
    }

    @Override
    public void addTypeToStaticImportScope(JvmDeclaredType type) {
        this.featureScopeSession = this.featureScopeSession.addTypesToStaticScope(Collections.singletonList(type), Collections.emptyList());
    }

    @Override
    public void addTypeToStaticExtensionImportScope(JvmDeclaredType type) {
        this.featureScopeSession = this.featureScopeSession.addTypesToStaticScope(Collections.singletonList(type), Collections.emptyList());
    }

    @Override
    public void addImports(ITypeImporter.Client importer) {
        this.featureScopeSession = this.featureScopeSession.addImports(importer);
    }

    @Override
    public void addExtensionsToCurrentScope(List<? extends JvmIdentifiableElement> extensionProviders) {
        if (extensionProviders.isEmpty()) {
            return;
        }
        if (extensionProviders.size() == 1) {
            this.addExtensionToCurrentScope(extensionProviders.get(0));
            return;
        }
        LinkedHashMap<XExpression, LightweightTypeReference> prototypeToType = Maps2.newLinkedHashMapWithExpectedSize(extensionProviders.size());
        for (JvmIdentifiableElement jvmIdentifiableElement : extensionProviders) {
            LightweightTypeReference knownType = this.getResolvedTypes().getActualType(jvmIdentifiableElement);
            if (knownType == null || knownType.isAny() || knownType.isUnknown()) continue;
            XFeatureCall prototype = this.getResolver().getXbaseFactory().createXFeatureCall();
            prototype.setFeature(jvmIdentifiableElement);
            prototypeToType.put(prototype, knownType);
        }
        if (!prototypeToType.isEmpty()) {
            this.featureScopeSession = this.featureScopeSession.addToExtensionScope(prototypeToType);
        }
    }

    protected void addLocalToCurrentScope(QualifiedName elementName, JvmIdentifiableElement element, boolean raiseIssueIfShadowing) {
        IEObjectDescription existingElement;
        if (this.getResolver().isDisallowedName(elementName)) {
            this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_disallowed", "'" + elementName + "' is not a valid name", this.getResolver().getSourceElement((EObject)element), element.eClass().getEStructuralFeature("name"), -1, null));
            return;
        }
        if (this.getResolver().isDiscouragedName(elementName) && !this.isIgnored("org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged")) {
            this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(this.getSeverity("org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged"), "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_discouraged", "'" + elementName + "' is a discouraged name", this.getResolver().getSourceElement((EObject)element), element.eClass().getEStructuralFeature("name"), -1, null));
        }
        if (raiseIssueIfShadowing && (existingElement = this.featureScopeSession.getLocalElement(elementName)) != null) {
            this.resolvedTypes.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "org.eclipse.xtext.xbase.validation.IssueCodes.variable_name_shadowing", "Duplicate local variable " + elementName, this.getResolver().getSourceElement((EObject)element), element.eClass().getEStructuralFeature("name"), -1, null));
        }
        this.featureScopeSession = this.featureScopeSession.addLocalElement(elementName, element, this.getReferenceOwner());
    }

    @Override
    public void assignType(QualifiedName name, JvmType rawType, LightweightTypeReference actualType) {
        this.resolvedTypes.reassignTypeWithoutMerge((JvmIdentifiableElement)rawType, actualType);
        this.featureScopeSession = this.featureScopeSession.addLocalElement(name, (JvmIdentifiableElement)rawType, this.getReferenceOwner());
    }

    @Override
    public TypeAssigner assignTypes() {
        TypeCheckpointComputationState state = this.withTypeCheckpoint(null);
        return this.createTypeAssigner(state);
    }

    @Override
    public void addDiagnostic(AbstractDiagnostic diagnostic) {
        this.resolvedTypes.addDiagnostic(diagnostic);
    }

    protected TypeAssigner createTypeAssigner(AbstractTypeComputationState state) {
        return new TypeAssigner(state);
    }

    @Override
    public final List<? extends ITypeExpectation> getExpectations() {
        if (this.expectations == null) {
            this.expectations = this.getExpectations(this);
        }
        return this.expectations;
    }

    protected final List<? extends ITypeExpectation> getReturnExpectations() {
        if (this.returnExpectations == null) {
            this.returnExpectations = this.getReturnExpectations(this, false);
        }
        return this.returnExpectations;
    }

    protected abstract List<AbstractTypeExpectation> getExpectations(AbstractTypeComputationState var1);

    protected abstract List<AbstractTypeExpectation> getReturnExpectations(AbstractTypeComputationState var1, boolean var2);

    @Override
    public void acceptCandidate(XExpression expression, IApplicableCandidate candidate) {
        this.getResolvedTypes().acceptCandidate(expression, candidate);
    }

    @Override
    public void acceptActualType(LightweightTypeReference type) {
        for (ITypeExpectation iTypeExpectation : this.getExpectations()) {
            iTypeExpectation.acceptActualType(type, 0x400000);
        }
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, ConformanceHint ... hints) {
        this.acceptActualType(type, ConformanceHint.toFlags(hints));
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, EnumSet<ConformanceHint> hints) {
        this.acceptActualType(type, ConformanceHint.toFlags(hints));
    }

    @Override
    public void acceptActualType(LightweightTypeReference type, int flags) {
        if ((flags & 0x100000) == 0) {
            flags |= 0x400000;
        }
        List<? extends ITypeExpectation> expectations = (flags & 0x8000000) != 0 ? this.getReturnExpectations() : this.getExpectations();
        for (ITypeExpectation iTypeExpectation : expectations) {
            iTypeExpectation.acceptActualType(type, flags);
        }
    }

    @Override
    public void reassignType(JvmIdentifiableElement refinable, LightweightTypeReference type) {
        if (type == null) {
            throw new IllegalArgumentException("Reassigned type may not be null");
        }
        this.resolvedTypes.reassignType(refinable, type);
    }

    @Override
    public void discardReassignedTypes(JvmIdentifiableElement refinable) {
        this.resolvedTypes.reassignType(refinable, null);
    }

    public List<IFeatureLinkingCandidate> getLinkingCandidates(XAbstractFeatureCall featureCall) {
        IFeatureLinkingCandidate result = this.reentrantTypeResolver.getScopeProviderAccess().getKnownFeature(featureCall, this, this.resolvedTypes);
        if (result != null) {
            return Collections.singletonList(result);
        }
        EObject proxyOrResolved = (EObject)featureCall.eGet((EStructuralFeature)XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, false);
        StackedResolvedTypes demandComputedTypes = this.resolvedTypes.pushTypes();
        final AbstractTypeComputationState forked = this.withNonVoidExpectation(demandComputedTypes);
        ForwardingResolvedTypes demandResolvedTypes = new ForwardingResolvedTypes(){

            @Override
            protected IResolvedTypes delegate() {
                return forked.getResolvedTypes();
            }

            @Override
            public LightweightTypeReference getActualType(XExpression expression) {
                LightweightTypeReference type = super.getActualType(expression);
                if (type == null) {
                    ITypeComputationResult result = forked.computeTypes(expression);
                    return result.getActualExpressionType();
                }
                return type;
            }
        };
        Iterable<IEObjectDescription> descriptions = this.reentrantTypeResolver.getScopeProviderAccess().getCandidateDescriptions(featureCall, XbasePackage.Literals.XABSTRACT_FEATURE_CALL__FEATURE, proxyOrResolved, this.featureScopeSession, demandResolvedTypes);
        ArrayList resultList = Lists.newArrayList();
        for (IEObjectDescription description : descriptions) {
            resultList.add(this.createCandidate(featureCall, demandComputedTypes, this.toIdentifiableDescription(description)));
        }
        if (resultList.isEmpty()) {
            resultList.add(new NullFeatureLinkingCandidate(featureCall, this));
        }
        return resultList;
    }

    protected IFeatureLinkingCandidate createResolvedLink(XAbstractFeatureCall featureCall, JvmIdentifiableElement resolvedTo) {
        XExpression implicitFirstArgument;
        XExpression implicitReceiver;
        ExpressionAwareStackedResolvedTypes resolvedTypes = this.resolvedTypes.pushTypes(featureCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(featureCall, resolvedTypes);
        FeatureLinkHelper helper = new FeatureLinkHelper();
        XExpression syntacticReceiver = helper.getSyntacticReceiver(featureCall);
        if (syntacticReceiver != null) {
            AbstractTypeComputationState child = state.withNonVoidExpectation();
            child.computeTypes(syntacticReceiver);
        }
        if ((implicitReceiver = featureCall.getImplicitReceiver()) != null) {
            AbstractTypeComputationState child = state.withNonVoidExpectation();
            child.computeTypes(implicitReceiver);
        }
        if ((implicitFirstArgument = featureCall.getImplicitFirstArgument()) != null) {
            AbstractTypeComputationState child = state.withNonVoidExpectation();
            child.computeTypes(implicitFirstArgument);
        }
        if (featureCall.isTypeLiteral() || featureCall.isPackageFragment()) {
            return new ResolvedTypeLiteral(featureCall, resolvedTo, this.getSingleExpectation(state), state);
        }
        return new ResolvedFeature(featureCall, resolvedTo, helper, this.getSingleExpectation(state), state);
    }

    protected IFeatureLinkingCandidate createCandidate(XAbstractFeatureCall featureCall, StackedResolvedTypes demandComputedTypes, IIdentifiableElementDescription description) {
        if (description.getSyntacticReceiverType() != null) {
            return this.createCandidateWithReceiverType(featureCall, demandComputedTypes, description);
        }
        ExpressionAwareStackedResolvedTypes resolvedTypes = this.resolvedTypes.pushTypes(featureCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(featureCall, resolvedTypes);
        if (description instanceof ScopeProviderAccess.ErrorDescription) {
            ScopeProviderAccess.ErrorDescription errorDescription = (ScopeProviderAccess.ErrorDescription)description;
            boolean followUpError = errorDescription.isFollowUpError();
            if (followUpError) {
                return new FollowUpError(featureCall, state);
            }
            return new UnresolvableFeatureCall(featureCall, errorDescription.getNode(), description.getName().toString(), state);
        }
        if (description.isTypeLiteral()) {
            return new TypeLiteralLinkingCandidate(featureCall, description, this.getSingleExpectation(state), state);
        }
        return new FeatureLinkingCandidate(featureCall, description, this.getSingleExpectation(state), state);
    }

    protected ITypeExpectation getSingleExpectation(ITypeComputationState state) {
        List<? extends ITypeExpectation> result = state.getExpectations();
        if (result.size() != 1) {
            throw new IllegalStateException();
        }
        return result.get(0);
    }

    protected IFeatureLinkingCandidate createCandidateWithReceiverType(XAbstractFeatureCall featureCall, final StackedResolvedTypes demandComputedTypes, IIdentifiableElementDescription description) {
        ExpressionAwareStackedResolvedTypes resolvedTypes = demandComputedTypes.pushTypes(featureCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(featureCall, resolvedTypes);
        if (description instanceof ScopeProviderAccess.ErrorDescription) {
            ScopeProviderAccess.ErrorDescription errorDescription = (ScopeProviderAccess.ErrorDescription)description;
            boolean followUpError = errorDescription.isFollowUpError();
            if (followUpError) {
                return new FollowUpError(featureCall, state){

                    @Override
                    public void applyToComputationState() {
                        super.applyToComputationState();
                        demandComputedTypes.mergeIntoParent();
                    }
                };
            }
            return new UnresolvableFeatureCall(featureCall, errorDescription.getNode(), description.getName().toString(), state){

                @Override
                public void applyToComputationState() {
                    super.applyToComputationState();
                    demandComputedTypes.mergeIntoParent();
                }
            };
        }
        if (description.isTypeLiteral()) {
            return new TypeLiteralLinkingCandidate(featureCall, description, this.getSingleExpectation(state), state){

                @Override
                public void applyToComputationState() {
                    super.applyToComputationState();
                    demandComputedTypes.mergeIntoParent();
                }
            };
        }
        return new FeatureLinkingCandidate(featureCall, description, this.getSingleExpectation(state), state){

            @Override
            public void applyToComputationState() {
                super.applyToComputationState();
                XExpression receiver = this.getReceiver();
                if (receiver != null) {
                    LightweightTypeReference receiverType = this.getReceiverType();
                    if (receiverType == null) {
                        throw new IllegalStateException("Cannot determine receiver's type");
                    }
                    LightweightTypeReference expectedReceiverType = new FeatureLinkHelper().getExpectedReceiverType(this.getFeature(), receiverType);
                    TypeExpectation refinedExpectation = new TypeExpectation(expectedReceiverType, this.getState(), false);
                    demandComputedTypes.refineExpectedType(receiver, refinedExpectation);
                }
                demandComputedTypes.mergeIntoParent();
            }
        };
    }

    public List<IConstructorLinkingCandidate> getLinkingCandidates(XConstructorCall constructorCall) {
        IConstructorLinkingCandidate result = this.reentrantTypeResolver.getScopeProviderAccess().getKnownConstructor(constructorCall, this, this.resolvedTypes);
        if (result != null) {
            return Collections.singletonList(result);
        }
        EObject proxyOrResolved = (EObject)constructorCall.eGet((EStructuralFeature)XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, false);
        Iterable<IEObjectDescription> descriptions = this.reentrantTypeResolver.getScopeProviderAccess().getCandidateDescriptions(constructorCall, XbasePackage.Literals.XCONSTRUCTOR_CALL__CONSTRUCTOR, proxyOrResolved, this.featureScopeSession, this.resolvedTypes);
        ArrayList resultList = Lists.newArrayList();
        for (IEObjectDescription description : descriptions) {
            resultList.add(this.createCandidate(constructorCall, this.toIdentifiableDescription(description)));
        }
        if (resultList.isEmpty()) {
            resultList.add(new NullConstructorLinkingCandidate(constructorCall, this));
        }
        return resultList;
    }

    protected IIdentifiableElementDescription toIdentifiableDescription(IEObjectDescription description) {
        if (description instanceof IIdentifiableElementDescription) {
            return (IIdentifiableElementDescription)description;
        }
        if (!(description.getEObjectOrProxy() instanceof JvmIdentifiableElement)) {
            throw new IllegalStateException("Given description does not describe an identifable element");
        }
        return new SimpleIdentifiableElementDescription(description);
    }

    protected IConstructorLinkingCandidate createResolvedLink(XConstructorCall constructorCall, JvmConstructor resolvedTo) {
        ExpressionAwareStackedResolvedTypes stackedResolvedTypes = this.resolvedTypes.pushTypes(constructorCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(constructorCall, stackedResolvedTypes);
        return new ResolvedConstructor(constructorCall, resolvedTo, this.getSingleExpectation(state), state);
    }

    protected IConstructorLinkingCandidate createCandidate(XConstructorCall constructorCall, IIdentifiableElementDescription description) {
        ExpressionAwareStackedResolvedTypes stackedResolvedTypes = this.resolvedTypes.pushTypes(constructorCall);
        ExpressionTypeComputationState state = this.createExpressionComputationState(constructorCall, stackedResolvedTypes);
        if (description instanceof ScopeProviderAccess.ErrorDescription) {
            return new UnresolvableConstructorCall(constructorCall, ((ScopeProviderAccess.ErrorDescription)description).getNode(), description.getName().toString(), state);
        }
        if (description.getElementOrProxy() instanceof JvmType) {
            return new TypeInsteadOfConstructorLinkingCandidate(constructorCall, description, state);
        }
        return new ConstructorLinkingCandidate(constructorCall, description, this.getSingleExpectation(state), state);
    }

    public String toString() {
        return String.format("%s: %s", this.getClass().getSimpleName(), this.resolvedTypes);
    }

    @Override
    public ITypeReferenceOwner getReferenceOwner() {
        return this.resolvedTypes.getReferenceOwner();
    }

    @Override
    public UnboundTypeReference createUnboundTypeReference(XExpression expression, JvmTypeParameter typeParameter) {
        return this.getResolvedTypes().createUnboundTypeReference(expression, typeParameter);
    }

    @Override
    public List<LightweightTypeReference> getExpectedExceptions() {
        return this.resolvedTypes.getExpectedExceptions();
    }

    protected IssueSeverities getSeverities() {
        return this.resolvedTypes.getSeverities();
    }

    @Override
    public Severity getSeverity(String issueCode) {
        return this.getSeverities().getSeverity(issueCode);
    }

    @Override
    public boolean isIgnored(String issueCode) {
        return this.getSeverities().isIgnored(issueCode);
    }

    @Override
    public void withinScope(EObject context) {
        this.resolvedTypes.addExpressionScope(context, this.featureScopeSession, IExpressionScope.Anchor.WITHIN);
    }

    @Override
    public void afterScope(EObject context) {
        this.resolvedTypes.addExpressionScope(context, this.featureScopeSession, IExpressionScope.Anchor.AFTER);
    }

    @Override
    public void rewriteScope(EObject context) {
        this.resolvedTypes.replacePreviousExpressionScope(context, this.featureScopeSession, IExpressionScope.Anchor.AFTER);
    }
}

