/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xbase.compiler.InMemoryJavaCompiler;
import org.eclipse.xtext.xbase.compiler.JavaSource;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Deprecated(forRemoval=true)
@Singleton
public class OnTheFlyJavaCompiler2 {
    private InMemoryJavaCompiler inMemoryCompiler;

    @Inject
    public OnTheFlyJavaCompiler2(ClassLoader scope) {
        this(scope, JavaVersion.JAVA8);
    }

    public OnTheFlyJavaCompiler2(ClassLoader scope, JavaVersion version) {
        this.inMemoryCompiler = new InMemoryJavaCompiler(scope, version);
    }

    public Class<?> compileToClass(String classname, String code) {
        InMemoryJavaCompiler.Result result = this.inMemoryCompiler.compile(new JavaSource(this.toJavaFile(classname), code));
        try {
            if (IterableExtensions.exists(result.getCompilationProblems(), IProblem::isError)) {
                StringConcatenation richString = new StringConcatenation();
                richString.append("Java code compiled with errors:");
                richString.newLine();
                richString.append(Joiner.on((String)"\n").join(IterableExtensions.filter(result.getCompilationProblems(), IProblem::isError)));
                richString.newLineIfNotEmpty();
                richString.newLine();
                richString.append("Code was:");
                richString.newLine();
                richString.append(code);
                richString.newLineIfNotEmpty();
                throw new IllegalArgumentException(richString.toString());
            }
            return result.getClassLoader().loadClass(classname);
        }
        catch (Throwable t) {
            if (t instanceof ClassNotFoundException) {
                ClassNotFoundException e = (ClassNotFoundException)t;
                StringConcatenation richString = new StringConcatenation();
                richString.append("Couldn't load '");
                richString.append(classname);
                richString.append("' ");
                richString.newLineIfNotEmpty();
                richString.append("source :");
                richString.newLine();
                richString.append("\t");
                richString.append(code, "\t");
                richString.newLineIfNotEmpty();
                richString.newLine();
                richString.append("PROBLEMS : ");
                richString.newLine();
                richString.append("\t");
                richString.append(Joiner.on((String)"\n").join(result.getCompilationProblems()), "\t");
                richString.newLineIfNotEmpty();
                throw new IllegalStateException(richString.toString(), e);
            }
            throw Exceptions.sneakyThrow((Throwable)t);
        }
    }

    private String toJavaFile(String string) {
        return string.replace(".", "/") + ".java";
    }

    public Map<String, Class<?>> compileToClasses(Map<String, String> sources) {
        InMemoryJavaCompiler.Result result = this.inMemoryCompiler.compile((JavaSource[])Conversions.unwrapArray((Object)Iterables.transform(sources.entrySet(), it -> new JavaSource(this.toJavaFile((String)it.getKey()), (String)it.getValue())), JavaSource.class));
        try {
            if (IterableExtensions.exists(result.getCompilationProblems(), IProblem::isError)) {
                StringConcatenation richString = new StringConcatenation();
                richString.append("Java code compiled with errors:");
                richString.newLine();
                richString.append(Joiner.on((String)"\n").join(IterableExtensions.filter(result.getCompilationProblems(), IProblem::isError)));
                richString.newLineIfNotEmpty();
                richString.newLine();
                richString.append("Code was:");
                richString.newLine();
                richString.append("=========");
                richString.newLine();
                richString.append(Joiner.on((String)"\n=========\n").join(sources.values()));
                richString.newLineIfNotEmpty();
                richString.append("=========");
                richString.newLine();
                throw new IllegalArgumentException(richString.toString());
            }
            ClassLoader classLoader = result.getClassLoader();
            return IterableExtensions.toMap((Iterable)Iterables.transform(sources.keySet(), it -> {
                try {
                    return classLoader.loadClass((String)it);
                }
                catch (ClassNotFoundException e) {
                    throw Exceptions.sneakyThrow((Throwable)e);
                }
            }), Class::getName);
        }
        catch (Throwable t) {
            if (t instanceof ClassNotFoundException) {
                ClassNotFoundException e = (ClassNotFoundException)t;
                StringConcatenation richString = new StringConcatenation();
                richString.append(e.getMessage());
                richString.append(" ");
                richString.newLineIfNotEmpty();
                richString.append("source :");
                richString.newLine();
                richString.append("\t");
                richString.append(sources, "\t");
                richString.newLineIfNotEmpty();
                richString.newLine();
                richString.append("PROBLEMS : ");
                richString.newLine();
                richString.append("\t");
                String _join_2 = Joiner.on((String)"\n").join(result.getCompilationProblems());
                richString.append(_join_2, "\t");
                richString.newLineIfNotEmpty();
                throw new IllegalStateException(richString.toString(), e);
            }
            throw Exceptions.sneakyThrow((Throwable)t);
        }
    }

    public <RT> Functions.Function0<RT> createFunction(String expression, Class<RT> returnType) {
        try {
            StringConcatenation richString = new StringConcatenation();
            richString.append("public class __Generated implements org.eclipse.xtext.xbase.lib.Functions.Function0<");
            richString.append(returnType.getName());
            richString.append("> {");
            richString.newLineIfNotEmpty();
            richString.append("\t");
            richString.append("public ");
            richString.append(returnType.getName(), "\t");
            richString.append(" apply() {");
            richString.newLineIfNotEmpty();
            richString.append("\t\t");
            richString.append(expression, "\t\t");
            richString.newLineIfNotEmpty();
            richString.append("\t");
            richString.append("}");
            richString.newLine();
            richString.append("}");
            richString.newLine();
            Class<?> clazz = this.compileToClass("__Generated", richString.toString());
            return (Functions.Function0)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw Exceptions.sneakyThrow((Throwable)e);
        }
    }
}

