/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.standalone.incremental;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.function.BiConsumer;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class BinaryFileHashing {
    static final Logger LOG = Logger.getLogger(BinaryFileHashing.class);
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128((int)0);

    public static void processDirectory(String directory, Map<IPath, HashCode> result, String fileExtension) {
        Files.fileTraverser().breadthFirst((Object)new File(directory)).forEach(file -> {
            block2: {
                block3: {
                    if (!file.isFile()) break block2;
                    if (fileExtension == null) break block3;
                    if (!file.getName().endsWith(fileExtension)) break block2;
                }
                BinaryFileHashing.processFile(file, result::put);
            }
        });
    }

    public static void processFile(File file, BiConsumer<IPath, HashCode> result) {
        result.accept((IPath)new Path(file.getAbsolutePath()), BinaryFileHashing.processFile(file));
    }

    public static HashCode processFile(File file) {
        try {
            HashCode hash = Files.asByteSource((File)file).hash(HASH_FUNCTION);
            LOG.trace((Object)("Hashed file " + file.getName() + " to " + hash));
            return hash;
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to hash file " + file.getAbsolutePath()));
            return BinaryFileHashing.unknownHashCode();
        }
    }

    public static HashFunction hashFunction() {
        return HASH_FUNCTION;
    }

    public static HashCode unknownHashCode() {
        return HashCode.fromInt((int)0);
    }
}

