/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.contentassist;

import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtend.core.services.XtendGrammarAccess;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend.ide.contentassist.AbstractXtendProposalProvider;
import org.eclipse.xtend.ide.contentassist.ImplementMemberFromSuperAssist;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.common.types.xtext.ui.ITypesProposalProvider;
import org.eclipse.xtext.common.types.xtext.ui.JdtVariableCompletions;
import org.eclipse.xtext.common.types.xtext.ui.TypeMatchFilters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.editor.contentassist.ConfigurableCompletionProposal;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalFactory;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IExpressionScope;

public class XtendProposalProvider
extends AbstractXtendProposalProvider {
    @Inject
    private JdtVariableCompletions completions;
    @Inject
    private XtendGrammarAccess grammarAccess;
    @Inject
    private ImplementMemberFromSuperAssist overrideAssist;
    @Inject
    private OperatorMapping operatorMapping;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    private final String WAIT = "java.lang.Object.wait";

    @Override
    public void completeMember_Name(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (this.announceProcessing(Lists.newArrayList((Object[])new Object[]{"completeMember_Name", model, assignment.getFeature()}))) {
            EObject previousModel = context.getPreviousModel();
            if (previousModel instanceof XExpression && !(previousModel instanceof XBlockExpression)) {
                return;
            }
            if (model instanceof XtendField) {
                List siblings = EcoreUtil2.getSiblingsOfType((EObject)model, XtendField.class);
                HashSet alreadyTaken = Sets.newHashSet();
                for (XtendField sibling : siblings) {
                    alreadyTaken.add(sibling.getName());
                }
                alreadyTaken.addAll(this.getAllKeywords());
                this.completions.getVariableProposals(model, XtendPackage.Literals.XTEND_FIELD__TYPE, JdtVariableCompletions.VariableType.INSTANCE_FIELD, (Set)alreadyTaken, new JdtVariableCompletions.CompletionDataAcceptor(){

                    public void accept(String replaceText, StyledString label, Image img) {
                        acceptor.accept(XtendProposalProvider.this.createCompletionProposal(replaceText, label, img, context));
                    }
                });
            } else if (model instanceof XtendFunction) {
                for (QualifiedName operator : this.operatorMapping.getOperators()) {
                    StyledString displayString = new StyledString(operator.getFirstSegment());
                    displayString.append(" " + this.operatorMapping.getMethodName(operator), StyledString.DECORATIONS_STYLER);
                    acceptor.accept(this.createCompletionProposal(operator.getFirstSegment(), displayString, this.getImage(model), context));
                }
                super.completeMember_Name(model, assignment, context, acceptor);
            } else {
                super.completeMember_Name(model, assignment, context, acceptor);
            }
        }
    }

    @Override
    public void completeTypeReferenceNoTypeArgs_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.getXbaseCrossReferenceProposalCreator().isShowTypeProposals() || this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals()) {
            this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, this.createVisibilityFilter(context), acceptor);
        }
    }

    protected ITypesProposalProvider.Filter createVisibilityFilter(ContentAssistContext context, int searchFor) {
        return new VisibilityFilter(context, searchFor);
    }

    @Override
    public void completeMember_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        XtendField field;
        if (this.announceProcessing(Lists.newArrayList((Object[])new Object[]{"completeMember_Type", model, assignment.getFeature()})) && model instanceof XtendField && !(field = (XtendField)model).getModifiers().isEmpty()) {
            INode node;
            List nameNodes;
            if (field.getName() != null && (nameNodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__NAME)).size() == 1 && (node = (INode)nameNodes.get(0)).getOffset() < context.getOffset()) {
                return;
            }
            this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), this.createVisibilityFilter(context), acceptor);
        }
    }

    @Override
    public void completeMember_Exceptions(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.getXbaseCrossReferenceProposalCreator().isShowSmartProposals()) {
            String text;
            char lastChar;
            INode lastCompleteNode = context.getLastCompleteNode();
            if (lastCompleteNode instanceof ILeafNode && !((ILeafNode)lastCompleteNode).isHidden() && lastCompleteNode.getLength() > 0 && lastCompleteNode.getTotalEndOffset() == context.getOffset() && Character.isJavaIdentifierPart(lastChar = (text = lastCompleteNode.getText()).charAt(text.length() - 1))) {
                return;
            }
            this.getTypesProposalProvider().createSubTypeProposals(this.typeReferences.findDeclaredType(Throwable.class, (Notifier)model), (ICompletionProposalFactory)this, context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, this.createVisibilityFilter(context, 5), (IValueConverter)this.getQualifiedNameValueConverter(), acceptor);
        } else {
            super.completeJvmParameterizedTypeReference_Type(model, assignment, context, acceptor);
        }
    }

    public void completeJvmParameterizedTypeReference_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendField) {
            XtendField field = (XtendField)model;
            if (!field.getModifiers().isEmpty()) {
                return;
            }
        } else {
            if (model instanceof XtendExecutable) {
                return;
            }
            if (this.isExtendsClause(context)) {
                return;
            }
        }
        super.completeJvmParameterizedTypeReference_Type(model, assignment, context, acceptor);
    }

    private boolean isExtendsClause(ContentAssistContext context) {
        return context.getLastCompleteNode() != null && context.getLastCompleteNode().getGrammarElement() instanceof Keyword && ((Keyword)context.getLastCompleteNode().getGrammarElement() == this.grammarAccess.getTypeAccess().getExtendsKeyword_2_0_5_0() || (Keyword)context.getLastCompleteNode().getGrammarElement() == this.grammarAccess.getTypeAccess().getExtendsKeyword_2_1_5_0());
    }

    @Override
    public void completeParameterizedTypeReferenceWithTypeArgs_Type(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeMember_ReturnType(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject previousGrammarElement;
        AbstractRule rule;
        if (context.getPrefix().length() == 0 && (rule = GrammarUtil.containingRule((EObject)(previousGrammarElement = context.getLastCompleteNode().getGrammarElement()))) != this.grammarAccess.getValidIDRule()) {
            this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), this.createVisibilityFilter(context), acceptor);
        }
    }

    protected Set<String> getAllKeywords() {
        return GrammarUtil.getAllKeywords((Grammar)this.grammarAccess.getGrammar());
    }

    @Override
    public void completeParameter_Name(EObject model, Assignment assignment, final ContentAssistContext context, final ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendParameter) {
            List siblings = EcoreUtil2.getSiblingsOfType((EObject)model, XtendParameter.class);
            HashSet alreadyTaken = Sets.newHashSet();
            for (XtendParameter sibling : siblings) {
                alreadyTaken.add(sibling.getName());
            }
            alreadyTaken.addAll(this.getAllKeywords());
            this.completions.getVariableProposals(model, XtendPackage.Literals.XTEND_PARAMETER__PARAMETER_TYPE, JdtVariableCompletions.VariableType.PARAMETER, (Set)alreadyTaken, new JdtVariableCompletions.CompletionDataAcceptor(){

                public void accept(String replaceText, StyledString label, Image img) {
                    acceptor.accept(XtendProposalProvider.this.createCompletionProposal(replaceText, label, img, context));
                }
            });
        } else {
            super.completeParameter_Name(model, assignment, context, acceptor);
        }
    }

    protected Predicate<IEObjectDescription> getFeatureDescriptionPredicate(ContentAssistContext contentAssistContext) {
        if (contentAssistContext.getPrefix().startsWith("_")) {
            return super.getFeatureDescriptionPredicate(contentAssistContext);
        }
        final Predicate delegate = super.getFeatureDescriptionPredicate(contentAssistContext);
        return new Predicate<IEObjectDescription>(){

            public boolean apply(IEObjectDescription input) {
                IIdentifiableElementDescription casted;
                boolean result;
                boolean bl = result = !input.getName().getFirstSegment().startsWith("_") && delegate.apply((Object)input);
                if (result && input instanceof IIdentifiableElementDescription && XtendProposalProvider.this.isDiscouragedExtension(casted = (IIdentifiableElementDescription)input)) {
                    return false;
                }
                return result;
            }
        };
    }

    protected boolean isDiscouragedExtension(IIdentifiableElementDescription description) {
        if (description.isExtension()) {
            JvmIdentifiableElement candidate = description.getElementOrProxy();
            if ("equals".equals(candidate.getSimpleName())) {
                return description.getNumberOfParameters() == 0;
            }
            if ("wait".equals(candidate.getSimpleName())) {
                return "java.lang.Object.wait".equals(candidate.getQualifiedName());
            }
        } else {
            JvmIdentifiableElement candidate = description.getElementOrProxy();
            if ("equals".equals(candidate.getSimpleName())) {
                return description.getNumberOfParameters() == 0;
            }
        }
        return false;
    }

    @Override
    public void completeType_Extends(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        final boolean isInterface = assignment == this.grammarAccess.getTypeAccess().getExtendsAssignment_2_1_5_1() || assignment == this.grammarAccess.getTypeAccess().getExtendsAssignment_2_1_5_2_1();
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), new ITypesProposalProvider.Filter(){

            public int getSearchFor() {
                return isInterface ? 6 : 5;
            }

            public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                if (TypeMatchFilters.isInternalClass((char[])simpleTypeName, (char[][])enclosingTypeNames)) {
                    return false;
                }
                if (!TypeMatchFilters.isAcceptableByPreference().accept(modifiers, packageName, simpleTypeName, enclosingTypeNames, path)) {
                    return false;
                }
                return !Flags.isFinal((int)modifiers);
            }
        }, acceptor);
    }

    @Override
    public void completeType_Implements(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), this.createVisibilityFilter(context, 6), acceptor);
    }

    @Override
    public void completeType_Members(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        INode node;
        EObject eObject;
        if (this.isValidTypeForOverriding(model) && !((eObject = NodeModelUtils.findActualSemanticObjectFor((INode)(node = context.getCurrentNode()))) instanceof AnonymousClass)) {
            EObject prevModel = context.getPreviousModel();
            if (prevModel instanceof XExpression) {
                XtendMember containingMember = (XtendMember)EcoreUtil2.getContainerOfType((EObject)prevModel, XtendMember.class);
                XBlockExpression blockExpression = (XBlockExpression)EcoreUtil2.getContainerOfType((EObject)prevModel, XBlockExpression.class);
                if (blockExpression != null && blockExpression != prevModel && EcoreUtil.isAncestor((EObject)containingMember, (EObject)blockExpression)) {
                    return;
                }
            }
            this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)model, context, acceptor, this.getConflictHelper());
        }
        super.completeType_Members(model, assignment, context, acceptor);
    }

    @Override
    public void completeAnnotationField_Members(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeMember_Members(model, assignment, context, acceptor);
    }

    @Override
    public void completeMember_Members(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        EObject eObject;
        INode node;
        if (this.isValidTypeForOverriding(model)) {
            node = context.getCurrentNode();
            eObject = NodeModelUtils.findActualSemanticObjectFor((INode)node);
            if (!(eObject instanceof AnonymousClass)) {
                this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)model, context, acceptor, this.getConflictHelper());
                return;
            }
        } else if (model instanceof XtendField) {
            XtendField field = (XtendField)model;
            if (this.isValidTypeForOverriding(field.eContainer())) {
                this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)field.eContainer(), context, acceptor, this.getConflictHelper());
                return;
            }
        } else {
            XtendMember member;
            ICompositeNode memberNode;
            if (model instanceof XtendExecutable && context.getPrefix().length() == 0 && this.isValidTypeForOverriding(model.eContainer())) {
                this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)model.eContainer(), context, acceptor, this.getConflictHelper());
                return;
            }
            if (model instanceof XExpression && (memberNode = NodeModelUtils.findActualNodeFor((EObject)(member = (XtendMember)EcoreUtil2.getContainerOfType((EObject)model, XtendMember.class)))).getTotalEndOffset() <= context.getOffset() && this.isValidTypeForOverriding(member.eContainer())) {
                this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)member.eContainer(), context, acceptor, this.getConflictHelper());
                return;
            }
        }
        if (this.isValidTypeForOverriding(eObject = NodeModelUtils.findActualSemanticObjectFor((INode)(node = context.getCurrentNode())))) {
            this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)eObject, context, acceptor, this.getConflictHelper());
        }
    }

    private boolean isValidTypeForOverriding(EObject model) {
        return model instanceof XtendClass || model instanceof XtendInterface && this.generatorConfigProvider.get(model).getJavaSourceVersion().isAtLeast(JavaVersion.JAVA8);
    }

    @Override
    public void completeXConstructorCall_Members(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        INode node;
        EObject eObject;
        if (model instanceof AnonymousClass) {
            this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)((AnonymousClass)model), context, acceptor, this.getConflictHelper());
            return;
        }
        if (model instanceof XtendField) {
            XtendField field = (XtendField)model;
            if (field.eContainer() instanceof AnonymousClass) {
                this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)((AnonymousClass)field.eContainer()), context, acceptor, this.getConflictHelper());
                return;
            }
        } else {
            XtendMember member;
            ICompositeNode memberNode;
            if (model instanceof XtendExecutable && context.getPrefix().length() == 0 && model.eContainer() instanceof AnonymousClass) {
                this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)((AnonymousClass)model.eContainer()), context, acceptor, this.getConflictHelper());
                return;
            }
            if (model instanceof XExpression && (memberNode = NodeModelUtils.findActualNodeFor((EObject)(member = (XtendMember)EcoreUtil2.getContainerOfType((EObject)model, XtendMember.class)))).getTotalEndOffset() <= context.getOffset() && member.eContainer() instanceof AnonymousClass) {
                this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)((AnonymousClass)member.eContainer()), context, acceptor, this.getConflictHelper());
                return;
            }
        }
        if ((eObject = NodeModelUtils.findActualSemanticObjectFor((INode)(node = context.getCurrentNode()))) instanceof AnonymousClass) {
            this.overrideAssist.createOverrideProposals((XtendTypeDeclaration)eObject, context, acceptor, this.getConflictHelper());
        }
    }

    protected void addGuillemotsProposal(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        acceptor.accept((ICompletionProposal)new ConfigurableCompletionProposal("\u00ab\u00bb", context.getOffset(), context.getSelectedText().length(), 1));
    }

    public void completeInRichString(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        INode node = context.getCurrentNode();
        ITextRegion textRegion = node.getTextRegion();
        int offset = textRegion.getOffset();
        int length = textRegion.getLength();
        String currentNodeText = node.getText();
        if (currentNodeText.startsWith("\u00bb") && offset + 1 <= context.getOffset() || currentNodeText.startsWith("'''") && offset + 3 <= context.getOffset()) {
            if (context.getOffset() > offset && context.getOffset() < offset + length) {
                this.addGuillemotsProposal(context, acceptor);
            }
        } else if (currentNodeText.startsWith("\u00ab\u00ab")) {
            try {
                IDocument document = context.getViewer().getDocument();
                int nodeLine = document.getLineOfOffset(offset);
                int completionLine = document.getLineOfOffset(context.getOffset());
                if (completionLine > nodeLine) {
                    this.addGuillemotsProposal(context, acceptor);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void completeXFeatureCall_Feature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendField) {
            if (((XtendField)model).getInitialValue() == null) {
                if (!"=".equals(context.getLastCompleteNode().getText())) {
                    return;
                }
                if (model.eContainer() instanceof AnonymousClass) {
                    this.createLocalVariableAndImplicitProposals(model.eContainer(), context, acceptor);
                    return;
                }
            } else {
                INode node;
                List initializerNodes = NodeModelUtils.findNodesForFeature((EObject)model, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__INITIAL_VALUE);
                if (initializerNodes.size() == 1 && (node = (INode)initializerNodes.get(0)).getEndOffset() <= context.getOffset()) {
                    return;
                }
            }
            this.createLocalVariableAndImplicitProposals(context.getPreviousModel(), context, acceptor);
            return;
        } else if (model instanceof AnonymousClass) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)model);
            if (node.getOffset() < context.getOffset()) return;
            super.completeXFeatureCall_Feature(model, assignment, context, acceptor);
            return;
        } else {
            super.completeXFeatureCall_Feature(model, assignment, context, acceptor);
        }
    }

    @Override
    public void complete_RICH_TEXT(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RICH_TEXT_START(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RICH_TEXT_END(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_RICH_TEXT_INBETWEEN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_COMMENT_RICH_TEXT_END(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    @Override
    public void complete_COMMENT_RICH_TEXT_INBETWEEN(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeInRichString(model, ruleCall, context, acceptor);
    }

    public void completeXVariableDeclaration_Right(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.BEFORE, context, acceptor);
    }

    @Override
    public void completeXbaseConstructorCall_Constructor(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.completeJavaTypes(context, TypesPackage.Literals.JVM_PARAMETERIZED_TYPE_REFERENCE__TYPE, true, (IValueConverter)this.getQualifiedNameValueConverter(), this.createVisibilityFilter(context), acceptor);
    }

    public void completeXSwitchExpression_Default(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        this.createLocalVariableAndImplicitProposals(model, IExpressionScope.Anchor.WITHIN, context, acceptor);
    }

    protected void completeWithinBlock(EObject model, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof AnonymousClass) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)model);
            if (node.getOffset() >= context.getOffset()) {
                super.completeWithinBlock(model, context, acceptor);
            } else {
                return;
            }
        }
        if (model instanceof XtendMember && model.eContainer() instanceof AnonymousClass) {
            return;
        }
        super.completeWithinBlock(model, context, acceptor);
    }

    protected void completeBinaryOperationFeature(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XtendExecutable) {
            return;
        }
        super.completeBinaryOperationFeature(model, assignment, context, acceptor);
    }

    protected String getConcreteSyntaxRuleName(RuleCall ruleCall) {
        if (this.grammarAccess.getFeatureCallIDRule() == ruleCall.getRule()) {
            return this.grammarAccess.getIdOrSuperRule().getName();
        }
        return super.getConcreteSyntaxRuleName(ruleCall);
    }

    private static class VisibilityFilter
    extends TypeMatchFilters.AbstractFilter {
        private ContentAssistContext context;

        public VisibilityFilter(ContentAssistContext context, int searchFor) {
            super(searchFor);
            this.context = context;
        }

        public boolean accept(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            if (TypeMatchFilters.isNotInternal((int)this.getSearchFor()).accept(modifiers, packageName, simpleTypeName, enclosingTypeNames, path) && TypeMatchFilters.isAcceptableByPreference().accept(modifiers, packageName, simpleTypeName, enclosingTypeNames, path)) {
                XtendFile file = (XtendFile)this.context.getRootModel();
                char[] contextPackageName = Strings.emptyIfNull((String)file.getPackage()).toCharArray();
                if ("org.eclipse.xtend.lib".equals(String.valueOf(packageName)) && ("Property".equals(String.valueOf(simpleTypeName)) || "Data".equals(String.valueOf(simpleTypeName)))) {
                    return false;
                }
                if (Flags.isPublic((int)modifiers)) {
                    return true;
                }
                if (Flags.isPrivate((int)modifiers)) {
                    return false;
                }
                if (Arrays.equals(contextPackageName, packageName)) {
                    return true;
                }
            }
            return false;
        }
    }
}

