/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.validation;

import com.google.common.collect.HashMultimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.jvmmodel.DispatchHelper;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.typesystem.override.IResolvedOperation;
import org.eclipse.xtext.xbase.validation.JvmGenericTypeValidator;

public class XtendJvmGenericTypeValidator
extends JvmGenericTypeValidator {
    @Inject
    private DispatchHelper dispatchHelper;

    protected void checkMemberNamesAreUnique(JvmGenericType genericType) {
        super.checkMemberNamesAreUnique(genericType);
        EObject primarySourceElement = this.getPrimarySourceElement(genericType);
        if (primarySourceElement instanceof XtendTypeDeclaration) {
            XtendTypeDeclaration xtendType = (XtendTypeDeclaration)primarySourceElement;
            HashMultimap type2extension = HashMultimap.create();
            for (XtendMember member : xtendType.getMembers()) {
                JvmType type;
                JvmTypeReference typeReference;
                XtendField field;
                if (!(member instanceof XtendField) || !Strings.isEmpty((String)(field = (XtendField)member).getName()) || !field.isExtension() || (typeReference = field.getType()) == null || (type = typeReference.getType()) == null) continue;
                type2extension.put((Object)type, (Object)field);
            }
            for (JvmType type : type2extension.keySet()) {
                Collection fields = type2extension.get((Object)type);
                if (fields.size() <= 1) continue;
                for (XtendField field : fields) {
                    this.error("Duplicate extension with same type", field, (EStructuralFeature)XtendPackage.Literals.XTEND_FIELD__TYPE, "org.eclipse.xtext.xbase.validation.IssueCodes.duplicate_field", new String[0]);
                }
            }
        }
    }

    protected void checkFunctionOverrides(IResolvedOperation operation, Set<EObject> flaggedOperations) {
        List allInherited;
        super.checkFunctionOverrides(operation, flaggedOperations);
        EObject sourceElement = this.findPrimarySourceElement(operation);
        if (sourceElement != null && (allInherited = operation.getOverriddenAndImplementedMethods()).isEmpty() && sourceElement instanceof XtendFunction && flaggedOperations.add(sourceElement)) {
            XtendFunction function = (XtendFunction)sourceElement;
            if (function.isOverride()) {
                this.error("The method " + operation.getSimpleSignature() + " of type " + this.getDeclaratorName((JvmFeature)operation.getDeclaration()) + " must override a superclass method.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_MEMBER__MODIFIERS, function.getModifiers().indexOf((Object)"override"), "org.eclipse.xtend.core.validation.IssueCodes.obsolete_override", new String[0]);
            } else {
                for (XAnnotation anno : function.getAnnotations()) {
                    if (anno == null || anno.getAnnotationType() == null || !Override.class.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
                    this.error("Superfluous @Override annotation", (EObject)anno, null, "org.eclipse.xtend.core.validation.IssueCodes.obsolete_annotation_override", new String[0]);
                }
            }
        }
    }

    protected void checkFunctionOverrides(EObject sourceElement, IResolvedOperation resolved, List<IResolvedOperation> allInherited) {
        super.checkFunctionOverrides(sourceElement, resolved, allInherited);
        boolean overrideProblems = false;
        for (IResolvedOperation inherited : allInherited) {
            if (!inherited.getOverrideCheckResult().hasProblems()) continue;
            overrideProblems = true;
            break;
        }
        if (sourceElement instanceof XtendFunction) {
            XtendFunction function = (XtendFunction)sourceElement;
            if (!(overrideProblems || function.isOverride() || function.isStatic())) {
                this.error("The method " + resolved.getSimpleSignature() + " of type " + this.getDeclaratorName(resolved) + " must use override keyword since it actually overrides a supertype method.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, "org.eclipse.xtend.core.validation.IssueCodes.missing_override", new String[0]);
            }
            if (!overrideProblems && function.isOverride() && function.isStatic()) {
                for (IResolvedOperation inherited : allInherited) {
                    this.error("The method " + resolved.getSimpleSignature() + " of type " + this.getDeclaratorName(resolved) + " shadows the method " + resolved.getSimpleSignature() + " of type " + this.getDeclaratorName(inherited) + ", but does not override it.", function, (EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME, function.getModifiers().indexOf((Object)"override"), "org.eclipse.xtend.core.validation.IssueCodes.obsolete_override", new String[0]);
                }
            }
            if (function.isOverride()) {
                for (XAnnotation anno : function.getAnnotations()) {
                    if (anno == null || anno.getAnnotationType() == null || !Override.class.getName().equals(anno.getAnnotationType().getIdentifier())) continue;
                    this.warning("Superfluous @Override annotation", (EObject)anno, null, "org.eclipse.xtend.core.validation.IssueCodes.obsolete_annotation_override", new String[0]);
                }
            }
        }
    }

    protected EStructuralFeature returnTypeFeature(EObject member, IResolvedOperation resolved) {
        EStructuralFeature returnTypeFeature = super.returnTypeFeature(member, resolved);
        if (returnTypeFeature == null && member instanceof XtendField) {
            return XtendPackage.Literals.XTEND_FIELD__TYPE;
        }
        return returnTypeFeature;
    }

    protected boolean shouldBeValidated(JvmIdentifiableElement element) {
        JvmOperation op;
        if (element instanceof JvmOperation && this.dispatchHelper.isDispatcherFunction(op = (JvmOperation)element)) {
            return false;
        }
        return super.shouldBeValidated(element);
    }
}

