/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codetemplates.ui.preferences;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.UnmodifiableIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.codetemplates.ui.internal.CodetemplatesActivator;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.IEditTemplateDialog;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TemplateDialogMessages;
import org.eclipse.xtext.ui.codetemplates.ui.preferences.TemplatesLanguageConfiguration;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.validation.IValidationIssueProcessor;
import org.eclipse.xtext.validation.Issue;

public class EditTemplateDialog
extends StatusDialog
implements IEditTemplateDialog {
    private Template fTemplate;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fContextCombo;
    private SourceViewer fPatternEditor;
    private EmbeddedEditorModelAccess partialModelEditor;
    private Button fInsertVariableButton;
    private Button fAutoInsertCheckbox;
    private boolean fIsNameModifiable;
    private String[][] fContextTypes;
    private org.eclipse.text.templates.ContextTypeRegistry fContextTypeRegistry;
    private final String languageName;
    private final TemplatesLanguageConfiguration configuration;
    private final IEditedResourceProvider resourceProvider;

    public EditTemplateDialog(Shell parent, Template template, boolean edit, boolean isNameModifiable, ContextTypeRegistry registry, TemplatesLanguageConfiguration configuration, IEditedResourceProvider resourceProvider, String languageName) {
        super(parent);
        this.configuration = configuration;
        this.resourceProvider = resourceProvider;
        this.languageName = languageName;
        String title = edit ? TemplateDialogMessages.EditTemplateDialog_title_edit : TemplateDialogMessages.EditTemplateDialog_title_new;
        this.setTitle(title);
        this.fTemplate = template;
        this.fIsNameModifiable = isNameModifiable;
        ArrayList contexts = Lists.newArrayList();
        UnmodifiableIterator it = Iterators.filter((Iterator)registry.contextTypes(), TemplateContextType.class);
        while (it.hasNext()) {
            TemplateContextType type = (TemplateContextType)it.next();
            contexts.add(new String[]{type.getId(), type.getName()});
        }
        this.fContextTypes = (String[][])contexts.toArray((T[])new String[contexts.size()][]);
        this.fContextTypeRegistry = registry;
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        this.getButton(0).setEnabled(this.getStatus().isOK());
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditTemplateDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditTemplateDialog.createLabel(parent, TemplateDialogMessages.EditTemplateDialog_name);
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            this.fNameText = EditTemplateDialog.createText(composite);
            EditTemplateDialog.createLabel(composite, TemplateDialogMessages.EditTemplateDialog_context);
            this.fContextCombo = new Combo(composite, 8);
            this.fContextCombo.setVisibleItemCount(30);
            int i = 0;
            while (i < this.fContextTypes.length) {
                this.fContextCombo.add(this.fContextTypes[i][1]);
                ++i;
            }
            this.fContextCombo.addModifyListener(listener);
            this.fAutoInsertCheckbox = EditTemplateDialog.createCheckbox(composite, TemplateDialogMessages.EditTemplateDialog_autoinsert);
            this.fAutoInsertCheckbox.setSelection(this.fTemplate.isAutoInsertable());
        }
        EditTemplateDialog.createLabel(parent, TemplateDialogMessages.EditTemplateDialog_description);
        int descFlags = this.fIsNameModifiable ? 2048 : 2056;
        this.fDescriptionText = new Text(parent, descFlags);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        this.fDescriptionText.addModifyListener(listener);
        Label patternLabel = EditTemplateDialog.createLabel(parent, TemplateDialogMessages.EditTemplateDialog_pattern);
        patternLabel.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(parent);
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditTemplateDialog.getButtonGridData());
        this.fInsertVariableButton.setText(TemplateDialogMessages.EditTemplateDialog_insert_variable);
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                EditTemplateDialog.this.fPatternEditor.getTextWidget().setFocus();
                EditTemplateDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fDescriptionText.setText(this.fTemplate.getDescription());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fTemplate.getName());
            this.fNameText.addModifyListener(listener);
            this.fContextCombo.select(this.getIndex(this.fTemplate.getContextTypeId()));
        } else {
            this.fPatternEditor.getControl().setFocus();
        }
        EditTemplateDialog.applyDialogFont((Control)parent);
        return composite;
    }

    protected void doTextWidgetChanged(Widget w) {
        if (w == this.fNameText || w == this.fContextCombo) {
            this.partialModelEditor.updatePrefix(this.getPrefix());
        }
    }

    protected String getContextName() {
        String result;
        if (this.fContextCombo != null && !this.fContextCombo.isDisposed()) {
            result = this.fContextCombo.getText();
        } else {
            String contextId = this.fTemplate.getContextTypeId();
            result = this.fContextTypeRegistry.getContextType(contextId).getName();
        }
        if (result.startsWith("Keyword ")) {
            result = result.substring("Keyword ".length());
        }
        return result;
    }

    protected String getContextId() {
        if (this.fContextCombo != null && !this.fContextCombo.isDisposed()) {
            String name = this.fContextCombo.getText();
            int i = 0;
            while (i < this.fContextTypes.length) {
                if (name.equals(this.fContextTypes[i][1])) {
                    return this.fContextTypes[i][0];
                }
                ++i;
            }
        }
        return this.fTemplate.getContextTypeId();
    }

    protected Status createErrorStatus(String message, TemplateException e) {
        return new Status(4, CodetemplatesActivator.getInstance().getBundle().getSymbolicName(), message, (Throwable)e);
    }

    private static GridData getButtonGridData() {
        GridData data = new GridData(768);
        return data;
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Button createCheckbox(Composite parent, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private SourceViewer createEditor(Composite parent) {
        SourceViewer viewer = this.createViewer(parent);
        int numberOfLines = viewer.getDocument().getNumberOfLines();
        if (numberOfLines < 7) {
            numberOfLines = 7;
        } else if (numberOfLines > 14) {
            numberOfLines = 14;
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(numberOfLines);
        control.setLayoutData((Object)data);
        return viewer;
    }

    protected SourceViewer createViewer(Composite parent) {
        EmbeddedEditorFactory.Builder editorBuilder = this.configuration.getEmbeddedEditorFactory().newEditor(this.resourceProvider);
        editorBuilder.processIssuesBy(new IValidationIssueProcessor(){

            public void processIssues(List<Issue> issues, IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                StringBuilder messages = new StringBuilder();
                for (Issue issue : issues) {
                    if (issue.getSeverity() != Severity.ERROR) continue;
                    if (messages.length() != 0) {
                        messages.append('\n');
                    }
                    messages.append(issue.getMessage());
                }
                if (messages.length() != 0) {
                    result = EditTemplateDialog.this.createErrorStatus(messages.toString(), null);
                }
                final IStatus toBeUpdated = result;
                EditTemplateDialog.this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EditTemplateDialog.this.updateStatus(toBeUpdated);
                    }
                });
            }
        });
        EmbeddedEditor handle = editorBuilder.withParent(parent);
        this.partialModelEditor = handle.createPartialEditor(this.getPrefix(), this.fTemplate.getPattern(), "", true);
        return handle.getViewer();
    }

    protected String getPrefix() {
        String contextName = this.getContextName();
        String name = this.fTemplate.getName();
        if (this.fNameText != null && !this.fNameText.isDisposed()) {
            name = this.fNameText.getText();
        }
        String prefix = "templates for " + this.languageName + " '" + name + "'" + " for " + contextName + " >>";
        return prefix;
    }

    private int getIndex(String contextid) {
        if (contextid == null) {
            return -1;
        }
        int i = 0;
        while (i < this.fContextTypes.length) {
            if (contextid.equals(this.fContextTypes[i][0])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected void okPressed() {
        String name = this.fNameText == null ? this.fTemplate.getName() : this.fNameText.getText();
        boolean isAutoInsertable = this.fAutoInsertCheckbox != null && this.fAutoInsertCheckbox.getSelection();
        this.fTemplate = new Template(name, this.fDescriptionText.getText(), this.getContextId(), this.getPattern(), isAutoInsertable);
        super.okPressed();
    }

    @Override
    public Template getTemplate() {
        return this.fTemplate;
    }

    protected String getPattern() {
        return this.partialModelEditor.getEditablePart();
    }

    protected IDialogSettings getDialogBoundsSettings() {
        String sectionName = String.valueOf(this.getClass().getName()) + "_dialogBounds";
        IDialogSettings section = this.configuration.getDialogSettings().getSection(sectionName);
        if (section == null) {
            section = this.configuration.getDialogSettings().addNewSection(sectionName);
        }
        return section;
    }
}

