/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.semantictokens;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator;
import org.eclipse.xtext.ide.editor.syntaxcoloring.LightweightPosition;
import org.eclipse.xtext.ide.editor.syntaxcoloring.MergingHighlightedPositionAcceptor;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.ide.util.PositionReader;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;

@Beta
public class SemanticTokensService {
    @Inject
    private IResourceServiceProvider.Registry languagesRegistry;
    private final List<String> tokenTypes = new ArrayList<String>();
    private final List<String> tokenModifiers = new ArrayList<String>();

    protected SemanticTokensService() {
        this.addTokenTypes();
        this.addTokenModifiers();
    }

    protected void addTokenTypes() {
        this.tokenTypes.add("keyword");
        this.tokenTypes.add("default");
        this.tokenTypes.add("number");
    }

    protected void addTokenModifiers() {
        this.tokenModifiers.add("deprecated");
    }

    private List<LightweightPosition> getPositions(XtextResource resource, CancelIndicator cancelIndicator) {
        ISemanticHighlightingCalculator semanticHighlightingCalculator = this.getService(resource.getURI(), ISemanticHighlightingCalculator.class);
        if (semanticHighlightingCalculator != null) {
            MergingHighlightedPositionAcceptor acceptor = new MergingHighlightedPositionAcceptor(semanticHighlightingCalculator);
            semanticHighlightingCalculator.provideHighlightingFor(resource, acceptor, cancelIndicator);
            acceptor.mergePositions();
            return acceptor.getPositions();
        }
        return Collections.emptyList();
    }

    public SemanticTokens semanticTokensFull(Document document, XtextResource resource, SemanticTokensParams params, CancelIndicator cancelIndicator) {
        if (document == null || resource == null) {
            return new SemanticTokens(Collections.emptyList());
        }
        ArrayList<Integer> data = new ArrayList<Integer>();
        int lastOffset = 0;
        int lastLine = 0;
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (PositionReader reader = new PositionReader(document.getContents());){
                List<LightweightPosition> positions = this.getPositions(resource, cancelIndicator);
                positions.sort(Comparator.comparing(LightweightPosition::getOffset));
                for (LightweightPosition lightweightPosition : positions) {
                    Integer positionTokenType = this.getTokenType(lightweightPosition.getIds());
                    Integer positionTokenModifiers = this.getTokenModifiers(lightweightPosition.getIds());
                    if (positionTokenType == 0 && positionTokenModifiers == 0) continue;
                    int deltaOffset = lightweightPosition.getOffset() - lastOffset;
                    reader.skip(deltaOffset);
                    Position position = reader.getPosition();
                    int deltaLine = position.getLine() - lastLine;
                    data.add(deltaLine);
                    lastLine = position.getLine();
                    data.add(deltaLine == 0 ? deltaOffset : position.getCharacter());
                    lastOffset = lightweightPosition.getOffset();
                    data.add(lightweightPosition.getLength());
                    data.add(positionTokenType);
                    data.add(positionTokenModifiers);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new WrappedException((Exception)e);
        }
        return new SemanticTokens(data);
    }

    public List<String> getTokenTypes() {
        return this.tokenTypes;
    }

    public List<String> getTokenModifiers() {
        return this.tokenModifiers;
    }

    private int getTokenType(String[] ids) {
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Integer index = this.tokenTypes.indexOf(id);
            if (index != -1) {
                return index + 1;
            }
            ++n2;
        }
        return 0;
    }

    private Integer getTokenModifiers(String[] ids) {
        int bitmask = 0;
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            Integer index = this.tokenModifiers.indexOf(id);
            if (index != -1) {
                bitmask |= 1 << index;
            }
            ++n2;
        }
        return bitmask;
    }

    private <Service> Service getService(URI uri, Class<Service> type) {
        IResourceServiceProvider resourceServiceProvider = this.languagesRegistry.getResourceServiceProvider(uri);
        if (resourceServiceProvider != null) {
            return (Service)resourceServiceProvider.get(type);
        }
        return null;
    }
}

