/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import com.google.inject.Inject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.parser.IEncodingProvider;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;

public class EmfResourceChangeUtil {
    @Inject
    private IEncodingProvider encodingProvider;

    public void addSaveAsUpdate(Resource resource, IRefactoringUpdateAcceptor updateAcceptor) throws IOException {
        IRefactoringDocument document = updateAcceptor.getDocument(resource.getURI());
        if (document == null) {
            return;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        resource.save((OutputStream)outputStream, null);
        String newContent = new String(outputStream.toByteArray(), this.encodingProvider.getEncoding(resource.getURI()));
        updateAcceptor.accept(resource.getURI(), (TextEdit)new ReplaceEdit(0, document.getOriginalContents().length(), newContent));
    }
}

