/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.validation;

import com.google.inject.Inject;
import org.eclipse.xtext.ui.editor.AbstractDirtyStateAwareEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.editor.validation.MarkerIssueProcessor;
import org.eclipse.xtext.ui.editor.validation.ValidationJob;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;

public class ValidatingEditorCallback
extends AbstractDirtyStateAwareEditorCallback {
    @Inject
    private IResourceValidator resourceValidator;
    @Inject
    private MarkerCreator markerCreator;

    public void afterCreatePartControl(XtextEditor editor) {
        super.afterCreatePartControl(editor);
        if (editor.isEditable()) {
            ValidationJob validationJob = this.newValidationJob(editor);
            validationJob.schedule();
        }
    }

    public void afterSave(XtextEditor editor) {
        super.afterSave(editor);
        if (editor.isEditable()) {
            ValidationJob validationJob = this.newValidationJob(editor);
            validationJob.schedule();
        }
    }

    private ValidationJob newValidationJob(XtextEditor editor) {
        MarkerIssueProcessor markerIssueProcessor = new MarkerIssueProcessor(editor.getResource(), this.markerCreator);
        ValidationJob validationJob = new ValidationJob(this.resourceValidator, editor.getDocument(), markerIssueProcessor, CheckMode.NORMAL_AND_FAST);
        return validationJob;
    }
}

