/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.inject.Inject;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class DefaultHighlightingConfiguration
implements IHighlightingConfiguration {
    @Inject(optional=true)
    @Deprecated
    private ISemanticHighlightingConfiguration semanticHighlighter;
    public static final String KEYWORD_ID = "keyword";
    public static final String PUNCTUATION_ID = "punctuation";
    public static final String COMMENT_ID = "comment";
    public static final String STRING_ID = "string";
    public static final String NUMBER_ID = "number";
    public static final String DEFAULT_ID = "default";
    public static final String INVALID_TOKEN_ID = "error";

    public void configure(IHighlightingConfigurationAcceptor acceptor) {
        acceptor.acceptDefaultHighlighting(KEYWORD_ID, "Keyword", this.keywordTextStyle());
        acceptor.acceptDefaultHighlighting(PUNCTUATION_ID, "Punctuation character", this.punctuationTextStyle());
        acceptor.acceptDefaultHighlighting(COMMENT_ID, "Comment", this.commentTextStyle());
        acceptor.acceptDefaultHighlighting(STRING_ID, "String", this.stringTextStyle());
        acceptor.acceptDefaultHighlighting(NUMBER_ID, "Number", this.numberTextStyle());
        acceptor.acceptDefaultHighlighting(DEFAULT_ID, "Default", this.defaultTextStyle());
        acceptor.acceptDefaultHighlighting(INVALID_TOKEN_ID, "Invalid Symbol", this.errorTextStyle());
        if (this.semanticHighlighter != null) {
            this.semanticHighlighter.configure(acceptor);
        }
    }

    public TextStyle defaultTextStyle() {
        TextStyle textStyle = new TextStyle();
        textStyle.setBackgroundColor(new RGB(255, 255, 255));
        textStyle.setColor(new RGB(0, 0, 0));
        return textStyle;
    }

    public TextStyle errorTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        return textStyle;
    }

    public TextStyle numberTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(125, 125, 125));
        return textStyle;
    }

    public TextStyle stringTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(42, 0, 255));
        return textStyle;
    }

    public TextStyle commentTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(63, 127, 95));
        return textStyle;
    }

    public TextStyle keywordTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        textStyle.setColor(new RGB(127, 0, 85));
        textStyle.setStyle(1);
        return textStyle;
    }

    public TextStyle punctuationTextStyle() {
        TextStyle textStyle = this.defaultTextStyle().copy();
        return textStyle;
    }
}

