/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.info;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.util.ResourceUtil;

public class ResourceWorkingCopyFileEditorInput
extends FileEditorInput {
    private Resource resource;

    public ResourceWorkingCopyFileEditorInput(Resource resource) throws IllegalArgumentException, IOException {
        super(ResourceWorkingCopyFileEditorInput.createFileProxy(resource));
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getEncoding() throws CoreException {
        if (this.resource instanceof XtextResource) {
            return ((XtextResource)this.resource).getEncoding();
        }
        return this.getFile().getCharset();
    }

    static IFile createFileProxy(Resource resource) throws IllegalArgumentException, IOException {
        return (IFile)Proxy.newProxyInstance(ResourceWorkingCopyFileEditorInput.class.getClassLoader(), new Class[]{IFile.class}, (InvocationHandler)new ResourceWorkingCopyFileInvocationHandler(resource));
    }

    static class ResourceWorkingCopyFileInvocationHandler
    implements InvocationHandler {
        private byte[] buffer;
        private IFile file;

        public ResourceWorkingCopyFileInvocationHandler(Resource resource) throws IOException {
            this.file = ResourceUtil.getFile(resource);
            boolean isModified = resource.isModified();
            ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
            BufferedOutputStream outputStream = new BufferedOutputStream(outputBuffer);
            try {
                resource.save((OutputStream)outputStream, null);
            }
            finally {
                ((OutputStream)outputStream).close();
                resource.setModified(isModified);
            }
            this.buffer = outputBuffer.toByteArray();
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("getContents")) {
                return new ByteArrayInputStream(this.buffer);
            }
            if (method.getName().equals("equals")) {
                if (proxy != args[0] && this.file != args[0] && !this.file.equals(args[0])) {
                    return false;
                }
                return true;
            }
            if (method.getName().equals("isConflicting")) {
                if (proxy != args[0] && this.file != args[0]) {
                    return false;
                }
                return true;
            }
            return method.invoke((Object)this.file, args);
        }
    }
}

