/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.findrefs;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.findrefs.Messages;
import org.eclipse.xtext.ui.editor.findrefs.ReferenceQuery;
import org.eclipse.xtext.ui.editor.utils.EditorUtils;
import org.eclipse.xtext.ui.resource.IStorage2UriMapper;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class FindReferencesHandler
extends AbstractHandler {
    @Inject
    private IStorage2UriMapper storage2UriMapper;
    @Inject
    private Provider<ReferenceQuery> queryProvider;
    @Inject
    private IResourceDescriptions resourceDescriptions;
    private static final Logger LOG = Logger.getLogger(FindReferencesHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            XtextEditor editor = EditorUtils.getActiveXtextEditor(event);
            if (editor != null) {
                ITextSelection selection = (ITextSelection)editor.getSelectionProvider().getSelection();
                IEObjectDescription eObjectDescription = (IEObjectDescription)editor.getDocument().readOnly(new EObjectResolver(selection));
                if (eObjectDescription != null) {
                    ReferenceQuery referenceQuery = (ReferenceQuery)this.queryProvider.get();
                    String label = String.valueOf(Messages.FindReferencesHandler_labelPrefix) + eObjectDescription.getQualifiedName();
                    Iterator<IStorage> storages = this.storage2UriMapper.getStorages(eObjectDescription.getEObjectURI()).iterator();
                    if (storages.hasNext()) {
                        label = String.valueOf(label) + Messages.FindReferencesHandler_1 + storages.next().getFullPath().toString() + Messages.FindReferencesHandler_2;
                    }
                    referenceQuery.init(eObjectDescription.getEObjectURI(), label);
                    NewSearchUI.activateSearchResultView();
                    NewSearchUI.runQueryInBackground((ISearchQuery)referenceQuery);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.FindReferencesHandler_3, (Throwable)e);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EObjectResolver
    implements IUnitOfWork<IEObjectDescription, XtextResource> {
        private final ITextSelection selection;

        private EObjectResolver(ITextSelection selection) {
            this.selection = selection;
        }

        public IEObjectDescription exec(XtextResource state) throws Exception {
            EObject element = EObjectAtOffsetHelper.resolveElementAt((XtextResource)state, (int)this.selection.getOffset(), null);
            if (element != null) {
                Iterator eObjectDescriptions;
                final URI eObjectURI = EcoreUtil.getURI((EObject)element);
                IResourceDescription resourceDescription = FindReferencesHandler.this.resourceDescriptions.getResourceDescription(eObjectURI.trimFragment());
                if (resourceDescription != null && (eObjectDescriptions = Iterables.filter((Iterable)resourceDescription.getExportedObjects(), (Predicate)new Predicate<IEObjectDescription>(){

                    public boolean apply(IEObjectDescription input) {
                        return input.getEObjectURI().equals((Object)eObjectURI);
                    }
                }).iterator()).hasNext()) {
                    return (IEObjectDescription)eObjectDescriptions.next();
                }
            }
            return null;
        }
    }
}

