/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.util;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmLowerBound;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmReferenceTypeArgument;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeArgument;
import org.eclipse.xtext.common.types.JvmTypeConstraint;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmWildcardTypeArgument;
import org.eclipse.xtext.common.types.util.IAssignabilityComputer;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssignabilityComputer
implements IAssignabilityComputer {
    private SuperTypeCollector superTypeCollector;

    @Inject
    public AssignabilityComputer(SuperTypeCollector superTypeCollector) {
        this.superTypeCollector = superTypeCollector;
    }

    @Override
    public boolean isAssignableFrom(JvmTypeReference left, JvmTypeReference right) {
        JvmType typeA = left.getType();
        JvmType typeB = right.getType();
        if (typeA instanceof JvmArrayType) {
            if (typeB instanceof JvmArrayType) {
                JvmTypeReference componentTypeA = ((JvmArrayType)typeA).getComponentType();
                JvmTypeReference componentTypeB = ((JvmArrayType)typeB).getComponentType();
                return this.isAssignableFrom(componentTypeA, componentTypeB);
            }
            return false;
        }
        if (right instanceof JvmParameterizedTypeReference) {
            JvmParameterizedTypeReference refA = (JvmParameterizedTypeReference)left;
            JvmParameterizedTypeReference refB = (JvmParameterizedTypeReference)right;
            if (typeA == typeB) {
                return this.areArgumentsAssignableFrom(refA, refB);
            }
            if (typeA instanceof JvmPrimitiveType) {
                return this.isUnBoxing(typeA, typeB);
            }
            if (typeA instanceof JvmDeclaredType) {
                if (this.superTypeCollector.collectSuperTypes(typeB).contains(typeA)) {
                    return this.areArgumentsAssignableFrom(refA, refB);
                }
                return this.isBoxing(typeA, typeB);
            }
        }
        return false;
    }

    protected boolean areArgumentsAssignableFrom(JvmParameterizedTypeReference left, JvmParameterizedTypeReference right) {
        if (left.getArguments().size() == 0 || right.getArguments().size() == 0) {
            return true;
        }
        if (left.getArguments().size() != right.getArguments().size()) {
            return false;
        }
        if (left.getArguments().size() == right.getArguments().size()) {
            int i = 0;
            while (i < left.getArguments().size()) {
                JvmTypeArgument argumentB;
                JvmTypeArgument argumentA = (JvmTypeArgument)left.getArguments().get(i);
                if (!this.isAssignable(argumentA, argumentB = (JvmTypeArgument)right.getArguments().get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected boolean isAssignable(JvmTypeArgument argumentA, JvmTypeArgument argumentB) {
        JvmTypeReference upperA = this.getUpper(argumentA);
        JvmTypeReference upperB = this.getUpper(argumentB);
        JvmTypeReference lowerA = this.getLower(argumentA);
        JvmTypeReference lowerB = this.getLower(argumentB);
        JvmTypeReference refA = this.getRef(argumentA);
        JvmTypeReference refB = this.getRef(argumentB);
        if (this.isUnconstraintWildcard(argumentA)) {
            return true;
        }
        if (upperA != null) {
            if (upperB != null) {
                return this.isAssignableFrom(upperA, upperB);
            }
            if (refB != null) {
                return this.isAssignableFrom(upperA, refB);
            }
        } else if (refA != null) {
            if (refB != null) {
                return this.isAssignableFrom(refA, refB);
            }
        } else if (lowerA != null && lowerB != null && this.isAssignableFrom(lowerB, lowerA)) {
            return true;
        }
        return false;
    }

    protected boolean isUnconstraintWildcard(JvmTypeArgument argumentA) {
        return argumentA instanceof JvmWildcardTypeArgument && ((JvmWildcardTypeArgument)argumentA).getConstraints().isEmpty();
    }

    protected JvmTypeReference getRef(JvmTypeArgument argumentA) {
        if (argumentA instanceof JvmReferenceTypeArgument) {
            return ((JvmReferenceTypeArgument)argumentA).getTypeReference();
        }
        return null;
    }

    protected JvmTypeReference getLower(JvmTypeArgument argumentA) {
        if (argumentA instanceof JvmWildcardTypeArgument) {
            EList list = ((JvmWildcardTypeArgument)argumentA).getConstraints();
            for (JvmTypeConstraint constraint : list) {
                if (!(constraint instanceof JvmLowerBound)) continue;
                return constraint.getTypeReference();
            }
        }
        return null;
    }

    protected JvmTypeReference getUpper(JvmTypeArgument argumentA) {
        if (argumentA instanceof JvmWildcardTypeArgument) {
            EList list = ((JvmWildcardTypeArgument)argumentA).getConstraints();
            for (JvmTypeConstraint constraint : list) {
                if (!(constraint instanceof JvmUpperBound)) continue;
                return constraint.getTypeReference();
            }
        }
        return null;
    }

    protected boolean isBoxing(JvmType typeA, JvmType typeB) {
        return this.is(typeA, Integer.class) && this.is(typeB, Integer.TYPE) || this.is(typeA, Boolean.class) && this.is(typeB, Boolean.TYPE) || this.is(typeA, Long.class) && this.is(typeB, Long.TYPE) || this.is(typeA, Float.class) && this.is(typeB, Float.TYPE) || this.is(typeA, Double.class) && this.is(typeB, Double.TYPE) || this.is(typeA, Byte.class) && this.is(typeB, Byte.TYPE);
    }

    protected boolean isUnBoxing(JvmType typeA, JvmType typeB) {
        return this.is(typeB, Integer.class) && this.is(typeA, Integer.TYPE) || this.is(typeB, Boolean.class) && this.is(typeA, Boolean.TYPE) || this.is(typeB, Long.class) && this.is(typeA, Long.TYPE) || this.is(typeB, Float.class) && this.is(typeA, Float.TYPE) || this.is(typeB, Double.class) && this.is(typeA, Double.TYPE) || this.is(typeB, Byte.class) && this.is(typeA, Byte.TYPE);
    }

    protected boolean is(JvmType typeA, Class<?> class1) {
        return typeA.getCanonicalName().equals(class1.getCanonicalName());
    }
}

