/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.cst.ModelTypeCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.MetamodelElementHyperlink;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.PackageRef;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.EnumLiteralExpCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.ecore.EnumLiteralExp;
import org.eclipse.ocl.utilities.ASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathNameHyperlinkDetector
implements IHyperlinkDetectorHelper {
    @Override
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        CSTNode syntaxElement = context.getSyntaxElement();
        EModelElementRef elementRef = PathNameHyperlinkDetector.findReferencedMetamodelElement(syntaxElement, context.getRegion());
        if (elementRef != null) {
            CFile file;
            ASTNode elementAST;
            CSTNode cstNode;
            EModelElement element = elementRef.element;
            if (element instanceof ASTNode && (cstNode = ASTBindingHelper.resolveCSTNode((ASTNode)(elementAST = (ASTNode)element), CSTNode.class)) != null && (file = CSTHelper.getSourceFile(cstNode)) != null) {
                if (cstNode instanceof ModelTypeCS) {
                    cstNode = ((ModelTypeCS)cstNode).getIdentifierCS();
                }
                IRegion destReg = HyperlinkUtil.createRegion(cstNode);
                return new QvtFileHyperlink(elementRef.sourceLinkRegion, file, destReg, destReg);
            }
            return new MetamodelElementHyperlink(elementRef.sourceLinkRegion, elementRef.element);
        }
        return null;
    }

    public static EModelElement findReferencedElementDefinition(CSTNode syntaxElement, IRegion region) {
        EModelElementRef ref = PathNameHyperlinkDetector.findReferencedMetamodelElement(syntaxElement, region);
        return ref != null ? ref.element : null;
    }

    private static EModelElementRef findReferencedMetamodelElement(CSTNode syntaxElement, IRegion region) {
        EnumLiteralExpCS enumExpCS;
        EnumLiteralExp enumExpAST;
        PathNameCS pathNameCS = null;
        if (syntaxElement instanceof PathNameCS) {
            pathNameCS = (PathNameCS)syntaxElement;
            if (pathNameCS.getSequenceOfNames().size() > 0) {
                ModelType modeltype;
                QvtOperationalEnv env;
                int startOffset = pathNameCS.getStartOffset();
                int firstElementLength = ((String)pathNameCS.getSequenceOfNames().get(0)).length();
                if (HyperlinkUtil.isOffsetInRange(region.getOffset(), startOffset, startOffset + firstElementLength) && (env = PathNameHyperlinkDetector.getEnv((CSTNode)pathNameCS)) != null && (modeltype = env.getModelType((List)pathNameCS.getSequenceOfNames())) != null) {
                    Region linkReg = new Region(pathNameCS.getStartOffset(), firstElementLength);
                    return new EModelElementRef((EModelElement)modeltype, (IRegion)linkReg);
                }
            }
            return PathNameHyperlinkDetector.findPathNameReferencedElement(pathNameCS, region);
        }
        if (syntaxElement instanceof EnumLiteralExpCS && (enumExpAST = (EnumLiteralExp)ASTBindingHelper.resolveASTNode((CSTNode)(enumExpCS = (EnumLiteralExpCS)syntaxElement), EnumLiteralExp.class)) != null && enumExpAST.getReferredEnumLiteral() != null) {
            EEnumLiteral enumLit = (EEnumLiteral)enumExpAST.getReferredEnumLiteral();
            SimpleNameCS linkCS = enumExpCS.getSimpleNameCS();
            if (linkCS == null) {
                linkCS = enumExpCS;
            }
            return new EModelElementRef((EModelElement)enumLit, HyperlinkUtil.createRegion((CSTNode)linkCS));
        }
        return null;
    }

    private static EModelElementRef findPathNameReferencedElement(PathNameCS pathName, IRegion region) {
        if (pathName.getSequenceOfNames().isEmpty()) {
            return null;
        }
        QvtOperationalEnv env = PathNameHyperlinkDetector.getEnv((CSTNode)pathName);
        if (env != null) {
            EList metamodels;
            ModelType modelType;
            EPackage element;
            LinkedList<String> namesToLookup = new LinkedList<String>();
            IRegion linkRegion = PathNameHyperlinkDetector.findElementInPathName(pathName, region, namesToLookup);
            boolean isPackageReferred = namesToLookup.size() < pathName.getSequenceOfNames().size();
            Object object = element = isPackageReferred ? env.lookupPackage(namesToLookup) : env.lookupClassifier(namesToLookup);
            if (element == null && (modelType = env.getModelType(namesToLookup)) != null && !(metamodels = modelType.getMetamodel()).isEmpty()) {
                String uri = ((PackageRef)metamodels.get(0)).getUri();
                element = env.getEPackageRegistry().getEPackage(uri);
            }
            if (element != null) {
                return new EModelElementRef((EModelElement)element, linkRegion);
            }
        }
        return null;
    }

    private static IRegion findElementInPathName(PathNameCS pathNameCS, IRegion selectedRegion, List<String> pathToLookup) {
        int startOffset;
        int endOffset = startOffset = pathNameCS.getStartOffset();
        int index = 0;
        for (String segment : pathNameCS.getSequenceOfNames()) {
            pathToLookup.add(segment);
            if (index > 0) {
                startOffset = endOffset + "::".length();
            }
            endOffset = startOffset + segment.length();
            if (selectedRegion.getOffset() >= startOffset && selectedRegion.getOffset() <= endOffset && selectedRegion.getLength() <= endOffset - startOffset) {
                return new Region(startOffset, endOffset - startOffset);
            }
            ++index;
        }
        return HyperlinkUtil.createRegion((CSTNode)pathNameCS);
    }

    private static QvtOperationalEnv getEnv(CSTNode node) {
        return (QvtOperationalEnv)CSTHelper.getEnvironment(node);
    }

    private static class EModelElementRef {
        final EModelElement element;
        final IRegion sourceLinkRegion;

        private EModelElementRef(EModelElement element, IRegion sourceLinkRegion) {
            this.element = element;
            this.sourceLinkRegion = sourceLinkRegion;
        }
    }
}

