/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.ocl.emf.libraries;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.qvt.oml.ocl.emf.libraries.LibrariesPlugin;
import org.eclipse.m2m.qvt.oml.ocl.emf.libraries.Logger;

public class EmfToolsLibrary {
    private static final Class[] EMPTY_CLASSES = new Class[0];
    private static final Object[] EMPTY_OBJECTS = new Object[0];
    private static final String GETTER_PREFIX = "get";

    public EDataType getDataTypeInstance(String nsURI, String dataTypeName) {
        if (nsURI == null || dataTypeName == null) {
            return null;
        }
        EPackage ePkg = EPackage.Registry.INSTANCE.getEPackage(nsURI);
        if (ePkg == null) {
            return null;
        }
        try {
            Method method = ePkg.getClass().getMethod(this.getMethodName(dataTypeName), EMPTY_CLASSES);
            Object result = method.invoke((Object)ePkg, EMPTY_OBJECTS);
            if (result == null || result instanceof EDataType) {
                return (EDataType)result;
            }
            Logger.getLogger().log(Logger.SEVERE, "Result of an accessor method execution is not an instance of EDataType: " + result.getClass());
        }
        catch (SecurityException e) {
            Logger.getLogger().log(Logger.SEVERE, "Exception while looking for an accessor method for EDataType" + dataTypeName, e);
        }
        catch (NoSuchMethodException e) {
            Logger.getLogger().log(Logger.SEVERE, "Exception while looking for an accessor method for EDataType" + dataTypeName, e);
        }
        catch (IllegalArgumentException e) {
            Logger.getLogger().log(Logger.SEVERE, "Exception while executing accessor method for EDataType" + dataTypeName, e);
        }
        catch (IllegalAccessException e) {
            Logger.getLogger().log(Logger.SEVERE, "Exception while executing accessor method for EDataType" + dataTypeName, e);
        }
        catch (InvocationTargetException e) {
            Logger.getLogger().log(Logger.SEVERE, "Exception while executing accessor method for EDataType" + dataTypeName, e);
        }
        return null;
    }

    private String getMethodName(String datatypeName) {
        return GETTER_PREFIX + datatypeName;
    }

    public String getDetails(EAnnotation self, String key) {
        if (self == null) {
            return null;
        }
        return (String)self.getDetails().get((Object)key);
    }

    public EObject asEObject(Object self) {
        if (self instanceof EObject) {
            return (EObject)self;
        }
        return null;
    }

    public static class Metainfo {
        private static final String[] GET_DATATYPE_INSTANCE = new String[]{String.valueOf(LibrariesPlugin.OCL_LIBRARY_PACKAGE) + "::" + "OclVoid", "String", "String", "ecore::EDataType"};
        private static final String[] GET_DETAILS = new String[]{"ecore::EAnnotation", "String", "String"};
        private static final String[] AS_EOBJECT = new String[]{String.valueOf(LibrariesPlugin.OCL_LIBRARY_PACKAGE) + "::" + "OclAny", "ecore::EObject"};

        public static String[] getDataTypeInstance(String nsURI, String dataTypeName) {
            return GET_DATATYPE_INSTANCE;
        }

        public static String[] getDetails(EAnnotation self, String key) {
            return GET_DETAILS;
        }

        public static String[] asEObject(Object self) {
            return AS_EOBJECT;
        }
    }
}

