/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.pivot.qvtimperative.evaluation;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.prettyprint.PrettyPrinter;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtcorebase.BottomPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.CoreDomain;
import org.eclipse.qvtd.pivot.qvtcorebase.GuardPattern;
import org.eclipse.qvtd.pivot.qvtcorebase.PropertyAssignment;
import org.eclipse.qvtd.pivot.qvtcorebase.VariableAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.ImperativeModel;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEvaluationVisitorDecorator;

public class QVTiTracingEvaluationVisitor
extends QVTiEvaluationVisitorDecorator {
    protected static final String DEFAULT_INDENT = "  ";
    private int indentLevel = 0;

    public QVTiTracingEvaluationVisitor(@NonNull QVTiEvaluationVisitor decorated) {
        this(decorated, 0);
    }

    protected QVTiTracingEvaluationVisitor(@NonNull QVTiEvaluationVisitor decorated, int indentLevel) {
        super(decorated);
        this.indentLevel = indentLevel;
    }

    @NonNull
    public QVTiEvaluationVisitor createNestedEvaluator() {
        return new QVTiTracingEvaluationVisitor(super.createNestedEvaluator(), this.indentLevel);
    }

    @NonNull
    public QVTiEvaluationVisitor createNestedLMVisitor() {
        System.out.println("(Creating nested LM Visitor)");
        QVTiTracingEvaluationVisitor decorator = new QVTiTracingEvaluationVisitor(((QVTiEvaluationVisitor)this.delegate).createNestedLMVisitor());
        return decorator;
    }

    @NonNull
    public QVTiEvaluationVisitor createNestedMMVisitor() {
        System.out.println("(Creating nested MM Visitor)");
        QVTiTracingEvaluationVisitor decorator = new QVTiTracingEvaluationVisitor(((QVTiEvaluationVisitor)this.delegate).createNestedMMVisitor());
        return decorator;
    }

    @NonNull
    public QVTiEvaluationVisitor createNestedMRVisitor() {
        System.out.println("(Creating nested MR Visitor)");
        QVTiTracingEvaluationVisitor decorator = new QVTiTracingEvaluationVisitor(((QVTiEvaluationVisitor)this.delegate).createNestedMRVisitor());
        return decorator;
    }

    @NonNull
    protected String getIndent() {
        StringBuilder outputBuffer = new StringBuilder(this.indentLevel);
        int i = 0;
        while (i < this.indentLevel) {
            outputBuffer.append(DEFAULT_INDENT);
            ++i;
        }
        String string = outputBuffer.toString();
        return string;
    }

    @NonNull
    protected String safePrint(@Nullable Element element) {
        return element != null ? PrettyPrinter.print((Element)element) : "null";
    }

    @Nullable
    public Object visitBottomPattern(@NonNull BottomPattern bottomPattern) {
        if (bottomPattern.getArea() instanceof CoreDomain) {
            System.out.println(String.valueOf(this.getIndent()) + "Visiting CoreDomain BottomPattern");
        }
        if (bottomPattern.getArea() instanceof Mapping) {
            System.out.println(String.valueOf(this.getIndent()) + "Visiting Mapping BottomPattern");
        }
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitBottomPattern(bottomPattern);
        for (Variable v : bottomPattern.getVariable()) {
            System.out.println(String.valueOf(this.getIndent()) + "Variable " + v.getName() + ": " + this.delegate.getEvaluationEnvironment().getValueOf((VariableDeclaration)v));
        }
        if (bottomPattern.getPredicate().size() == 0) {
            System.out.println(String.valueOf(this.getIndent()) + "BottomPattern has no predicates.");
        } else {
            System.out.println(String.valueOf(this.getIndent()) + "BottomPattern result: " + result);
        }
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitCoreDomain(@NonNull CoreDomain coreDomain) {
        System.out.println(String.valueOf(this.getIndent()) + "CoreDomain " + coreDomain.getName());
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitCoreDomain(coreDomain);
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitGuardPattern(@NonNull GuardPattern guardPattern) {
        if (guardPattern.getArea() instanceof CoreDomain) {
            System.out.println(String.valueOf(this.getIndent()) + "Visiting CoreDomain GuardPattern");
        }
        if (guardPattern.getArea() instanceof Mapping) {
            System.out.println(String.valueOf(this.getIndent()) + "Visiting Mapping GuardPattern");
        }
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitGuardPattern(guardPattern);
        for (Variable v : guardPattern.getVariable()) {
            System.out.println(String.valueOf(this.getIndent()) + "Variable " + v.getName() + ": " + this.delegate.getEvaluationEnvironment().getValueOf((VariableDeclaration)v));
        }
        if (guardPattern.getPredicate().size() == 0) {
            System.out.println(String.valueOf(this.getIndent()) + "GuardPattern has no predicates.");
        } else {
            System.out.println(String.valueOf(this.getIndent()) + "GuardPattern result: " + result);
        }
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitImperativeModel(@NonNull ImperativeModel imperativeModel) {
        return ((QVTiEvaluationVisitor)this.delegate).visitImperativeModel(imperativeModel);
    }

    @Nullable
    public Object visitIteratorExp(@NonNull IteratorExp object) {
        return this.delegate.visitIteratorExp(object);
    }

    @Nullable
    public Object visitMapping(@NonNull Mapping mapping) {
        System.out.println(String.valueOf(this.getIndent()) + "Mapping " + mapping.getName());
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitMapping(mapping);
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitMappingCall(@NonNull MappingCall mappingCall) {
        System.out.println(String.valueOf(this.getIndent()) + "Visiting MappingCall, calling: " + mappingCall.getReferredMapping().getName());
        ++this.indentLevel;
        System.out.println(String.valueOf(this.getIndent()) + "Bindings");
        for (MappingCallBinding binding : mappingCall.getBinding()) {
            Variable boundVariable = binding.getBoundVariable();
            System.out.println(String.valueOf(this.getIndent()) + boundVariable.getName() + ": " + this.safePrint((Element)binding.getValue()));
        }
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitMappingCall(mappingCall);
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitPropertyAssignment(@NonNull PropertyAssignment propertyAssignment) {
        System.out.println(String.valueOf(this.getIndent()) + "visitAssignment " + propertyAssignment.getSlotExpression() + ": " + propertyAssignment.getTargetProperty().getName());
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitPropertyAssignment(propertyAssignment);
        --this.indentLevel;
        return result;
    }

    @Nullable
    public Object visitTransformation(@NonNull Transformation transformation) {
        System.out.println("\n");
        System.out.println("---- Transformation " + transformation.getName() + " ----");
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitTransformation(transformation);
        --this.indentLevel;
        System.out.println("---- Transformation End ----");
        return result;
    }

    @Nullable
    public Object visitPredicate(@NonNull Predicate predicate) {
        OCLExpression exp = predicate.getConditionExpression();
        System.out.println(String.valueOf(this.getIndent()) + "Predicate " + this.safePrint((Element)exp));
        return ((QVTiEvaluationVisitor)this.delegate).visitPredicate(predicate);
    }

    @Nullable
    public Object visitVariableAssignment(@NonNull VariableAssignment variableAssignment) {
        Variable v = variableAssignment.getTargetVariable();
        System.out.println(String.valueOf(this.getIndent()) + "visitVariableAssignment " + v + ": " + ((EvaluationVisitorImpl)this.delegate).safeVisit((Visitable)variableAssignment.getValue()));
        ++this.indentLevel;
        Object result = ((QVTiEvaluationVisitor)this.delegate).visitVariableAssignment(variableAssignment);
        --this.indentLevel;
        return result;
    }
}

