/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.ecore.operations;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.qvt.declarative.ecore.operations.AbstractOperations;
import org.eclipse.qvt.declarative.ecore.operations.EValidatorWithOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractValidatorOperations
extends AbstractOperations {
    public static final String ECORE_DIAGNOSTIC_SOURCE = "org.eclipse.emf.ecore";
    protected final EValidatorWithOperations validator;
    protected final Map<String, Integer> messageToCode = new HashMap<String, Integer>();

    protected AbstractValidatorOperations(EValidatorWithOperations validator) {
        this.validator = validator;
    }

    protected void appendDiagnostic(DiagnosticChain diagnostics, Object astNode, int severity, String errorMessage, Object[] messageSubstitutions) {
        this.appendDiagnostic(diagnostics, new Object[]{astNode}, severity, errorMessage, messageSubstitutions);
    }

    protected void appendDiagnostic(DiagnosticChain diagnostics, Object[] astNodes, int severity, String errorMessage, Object[] messageSubstitutions) {
        this.appendDiagnostic(diagnostics, astNodes, this.validator.getDiagnosticSource(), severity, errorMessage, messageSubstitutions);
    }

    protected void appendDiagnostic(DiagnosticChain diagnostics, Object[] astNodes, String diagnosticSource, int severity, String errorMessage, Object[] messageSubstitutions) {
        if (diagnostics != null) {
            int errorCode = this.getErrorCode(errorMessage);
            String message = NLS.bind((String)errorMessage, (Object[])messageSubstitutions);
            BasicDiagnostic diagnostic = new BasicDiagnostic(severity, diagnosticSource, errorCode, message, astNodes);
            diagnostics.add((Diagnostic)diagnostic);
        }
    }

    protected void appendError(DiagnosticChain diagnostics, Object astNode, String errorMessage, Object[] messageSubstitutions) {
        this.appendDiagnostic(diagnostics, astNode, 4, errorMessage, messageSubstitutions);
    }

    protected void appendError(DiagnosticChain diagnostics, Object[] astNodes, String errorMessage, Object[] messageSubstitutions) {
        this.appendDiagnostic(diagnostics, astNodes, 4, errorMessage, messageSubstitutions);
    }

    protected void appendWarning(DiagnosticChain diagnostics, Object astNode, String errorMessage, Object[] messageSubstitutions) {
        this.appendDiagnostic(diagnostics, astNode, 2, errorMessage, messageSubstitutions);
    }

    protected void appendWarning(DiagnosticChain diagnostics, Object[] astNodes, String errorMessage, Object[] messageSubstitutions) {
        this.appendDiagnostic(diagnostics, astNodes, 2, errorMessage, messageSubstitutions);
    }

    public boolean checkUniqueNames(Object parent, List<? extends ENamedElement> eNamedElements, String errorMessage, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean allOk = true;
        HashMap<String, ENamedElement> nameToFirst = new HashMap<String, ENamedElement>();
        for (ENamedElement eNamedElement : eNamedElements) {
            String name = eNamedElement.getName();
            ENamedElement firstENamedElement = (ENamedElement)nameToFirst.get(name);
            if (firstENamedElement == null) {
                nameToFirst.put(name, eNamedElement);
                continue;
            }
            allOk = false;
            String objectLabel = this.getObjectLabel((EObject)eNamedElement, context);
            String firstObjectLabel = this.getObjectLabel((EObject)firstENamedElement, context);
            Object[] messageSubstitutions = new Object[]{name, objectLabel, firstObjectLabel};
            this.appendError(diagnostics, parent, errorMessage, messageSubstitutions);
        }
        return allOk;
    }

    @Deprecated
    protected Diagnostic createDiagnostic(int severity, String source, int code, String messageKey, Object[] messageSubstitutions, Object[] data, Map<Object, Object> context) {
        String message = ECORE_DIAGNOSTIC_SOURCE.equals(source) ? this.getEcoreString(messageKey, messageSubstitutions) : this.getString(messageKey, messageSubstitutions);
        return new BasicDiagnostic(severity, source, code, message, data);
    }

    public boolean definesOppositeProperty(EClass eClass, EReference property) {
        return property != null && this.isSuperClassOf(property.getEReferenceType(), eClass);
    }

    public boolean definesProperty(EClass eClass, EStructuralFeature property) {
        return property != null && this.isSuperClassOf(property.getEContainingClass(), eClass);
    }

    protected <T extends EObject> T getAncestor(EObject eObject, Class<T> requiredClass) {
        if (eObject == null) {
            return null;
        }
        if (requiredClass.isAssignableFrom(eObject.getClass())) {
            EObject object = eObject;
            return (T)object;
        }
        return this.getAncestor(eObject.eContainer(), requiredClass);
    }

    protected String getEcoreString(String key, Object[] substitutions) {
        return this.getString((ResourceLocator)EcorePlugin.INSTANCE, key, substitutions);
    }

    public int getErrorCode(String message) {
        Integer code = this.messageToCode.get(message);
        return code != null ? code : 0;
    }

    public <T extends ENamedElement> Map<String, T> getNames(List<T> eNamedElements) {
        HashMap<String, ENamedElement> map = new HashMap<String, ENamedElement>();
        for (ENamedElement eNamedElement : eNamedElements) {
            map.put(eNamedElement.getName(), eNamedElement);
        }
        return map;
    }

    protected String getObjectLabel(EObject eObject, Map<Object, Object> context) {
        return EObjectValidator.getObjectLabel((EObject)eObject, context);
    }

    protected String getString(String key, Object[] substitutions) {
        if ("_UI_GenericConstraint_diagnostic".equals(key)) {
            return this.getString((ResourceLocator)EcorePlugin.INSTANCE, key, substitutions);
        }
        return this.getString(this.validator.getResourceLocator(), key, substitutions);
    }

    private String getString(ResourceLocator resourceLocator, String key, Object[] substitutions) {
        if (substitutions == null) {
            return resourceLocator.getString(key);
        }
        return resourceLocator.getString(key, substitutions);
    }

    public EValidatorWithOperations getValidator() {
        return this.validator;
    }

    public boolean hasAncestor(EObject childObject, EObject parentObject) {
        EObject eObject = childObject;
        while (eObject != null) {
            if (eObject == parentObject) {
                return true;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public boolean isSuperClassOf(EClass targetClass, EClass queryClass) {
        if (targetClass == null) {
            return false;
        }
        if (queryClass == null) {
            return false;
        }
        return targetClass.isSuperTypeOf(queryClass);
    }

    public Integer registerErrorCode(String message, int errorCode) {
        return this.messageToCode.put(message, errorCode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class UniquenessChecker<K extends EObject, V extends EObject> {
        public boolean check(List<? extends V> values, String errorMessage, EObject contextObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
            boolean allOk = true;
            HashMap<K, EObject> keyToFirstValue = new HashMap<K, EObject>();
            for (EObject value : values) {
                K key = this.getKey(value);
                EObject firstValue = (EObject)keyToFirstValue.get(key);
                if (firstValue == null) {
                    keyToFirstValue.put(key, value);
                    continue;
                }
                allOk = false;
                String typedModelLabel = AbstractValidatorOperations.this.getObjectLabel((EObject)key, context);
                String objectLabel = AbstractValidatorOperations.this.getObjectLabel(value, context);
                String firstObjectLabel = AbstractValidatorOperations.this.getObjectLabel(firstValue, context);
                Object[] messageSubstitutions = new Object[]{typedModelLabel, objectLabel, firstObjectLabel};
                AbstractValidatorOperations.this.appendDiagnostic(diagnostics, contextObject, this.getSeverity(), errorMessage, messageSubstitutions);
            }
            return allOk;
        }

        protected abstract K getKey(V var1);

        protected int getSeverity() {
            return 4;
        }
    }
}

