/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.indexing;

import java.io.FileWriter;
import java.io.IOException;
import org.eclipse.core.resources.IFile;

public abstract class IndexEntry {
    protected int fType;
    protected String fName;
    protected int fStart;
    protected int fEnd;
    protected String fPath;

    public IndexEntry() {
    }

    public IndexEntry(int type, String name, IFile file, int start, int end) {
        this.fType = type;
        this.fName = name;
        this.fPath = file.getFullPath().toString();
        this.fStart = start;
        this.fEnd = end;
    }

    public abstract char getEntryKind();

    public void saveToStream(FileWriter writer) throws IOException {
        writer.write(this.getEntryKind());
        writer.write(58);
        writer.write(this.fType);
        writer.write(58);
        writer.write(this.fPath);
        writer.write(58);
        writer.write(this.fName);
        writer.write(58);
        writer.write(this.fStart);
        writer.write(58);
        writer.write(this.fEnd);
    }

    public final void parseFromString(String s) {
        String[] fields = s.split(":");
        this.fType = Integer.parseInt(fields[1]);
        this.fPath = fields[2];
        this.fName = fields[3];
        this.fStart = Integer.parseInt(fields[4]);
        this.fEnd = Integer.parseInt(fields[5]);
        this.readExtraFields(fields);
    }

    protected abstract void readExtraFields(String[] var1);

    public abstract Object findASTNode(Object var1);
}

