/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.paged;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.UnwrappingSelectionProvider;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.emf.transaction.impl.AbstractTransactionalCommandStack;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.qvt.declarative.editor.ui.QVTEditorPlugin;
import org.eclipse.qvt.declarative.editor.ui.text.TextResource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public abstract class BaseEditor
extends MultiPageEditorPart
implements IMenuListener,
IViewerProvider {
    public static final String ECORE_FILE_EXTENSION = "ecore";
    public static final String EMOF_FILE_EXTENSION = "emof";
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    private Collection<Resource> removedResources = new ArrayList<Resource>();
    private Collection<Resource> changedResources = new ArrayList<Resource>();
    private Collection<Resource> savedResources = new ArrayList<Resource>();
    private Collection<Resource> savingResources = new ArrayList<Resource>();
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected EContentAdapter problemIndicationAdapter = new ProblemIndicationAdapter();
    protected IResourceChangeListener resourceChangeListener = new ResourceChangeListener();

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "org.eclipse.emf.ecore.editor", 0, BaseEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "org.eclipse.emf.ecore.editor", 0, BaseEditor.getString("_UI_CreateModelError_message", resource.getURI()), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public void createContextMenuFor(StructuredViewer viewer) {
        Control control = viewer.getControl();
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)new UnwrappingSelectionProvider((ISelectionProvider)viewer));
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new EditingDomainViewerDropAdapter(this.getEditingDomain(), (Viewer)viewer));
        control.addMouseListener((MouseListener)new DoubleClickListener());
    }

    public void doResourceSetSave(IProgressMonitor progressMonitor) {
        HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        SaveOperation1 operation1 = new SaveOperation1(saveOptions);
        SaveOperation2 operation2 = new SaveOperation2();
        this.updateProblemIndication = false;
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
            progressMonitorDialog.run(true, false, (IRunnableWithProgress)operation1);
            if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Saved all");
            }
            try {
                progressMonitorDialog.run(true, false, (IRunnableWithProgress)operation2);
                if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                    QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Saved all2");
                }
                this.savingResources.clear();
            }
            catch (Exception exception) {
                QVTEditorPlugin.INSTANCE.log(exception);
            }
            this.getCommandStack().saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            QVTEditorPlugin.INSTANCE.log(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void dispose() {
        this.updateProblemIndication = false;
        super.dispose();
    }

    public void doSaveAs() {
        IFile file;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)) != null) {
            ResourceSet resourceSet = this.getResourceSet();
            Resource currentResource = (Resource)resourceSet.getResources().get(0);
            String currentExtension = currentResource.getURI().fileExtension();
            URI newURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            String newExtension = newURI.fileExtension();
            if (currentExtension.equals(ECORE_FILE_EXTENSION) && newExtension.equals(EMOF_FILE_EXTENSION) || currentExtension.equals(EMOF_FILE_EXTENSION) && newExtension.equals(ECORE_FILE_EXTENSION)) {
                Resource newResource = resourceSet.createResource(newURI);
                newResource.getContents().addAll((Collection)currentResource.getContents());
                resourceSet.getResources().remove(0);
                resourceSet.getResources().move(0, (Object)newResource);
            } else {
                currentResource.setURI(newURI);
            }
            FileEditorInput modelFile = new FileEditorInput(file);
            this.setInputWithNotify((IEditorInput)modelFile);
            this.setPartName(file.getName());
            this.doSave(this.getActionBars().getStatusLineManager().getProgressMonitor());
        }
    }

    protected void doSaveAs(URI uri, IEditorInput editorInput) {
        ((Resource)this.getResourceSet().getResources().get(0)).setURI(uri);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        NullProgressMonitor progressMonitor = this.getActionBars().getStatusLineManager() != null ? this.getActionBars().getStatusLineManager().getProgressMonitor() : new NullProgressMonitor();
        this.doSave((IProgressMonitor)progressMonitor);
    }

    protected void firePropertyChange(int action) {
        super.firePropertyChange(action);
    }

    public abstract AdapterFactoryEditingDomain getAdapterFactoryEditingDomain();

    public AbstractTransactionalCommandStack getCommandStack() {
        return (AbstractTransactionalCommandStack)this.getEditingDomain().getCommandStack();
    }

    public Display getDisplay() {
        return this.getShell().getDisplay();
    }

    public abstract EditingDomain getEditingDomain();

    public abstract ResourceSet getResourceSet();

    public abstract ISelection getSelection();

    public Shell getShell() {
        return this.getSite().getShell();
    }

    protected static String getString(String key) {
        return QVTEditorPlugin.INSTANCE.getString(key);
    }

    protected static String getString(String key, Object s1) {
        return QVTEditorPlugin.INSTANCE.getString(key, new Object[]{s1});
    }

    public abstract IActionBars getActionBars();

    protected void handleActivate() {
        AdapterFactoryEditingDomain editingDomain = this.getAdapterFactoryEditingDomain();
        if (editingDomain.getResourceToReadOnlyMap() != null) {
            editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
                if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                    QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Clear saved after removed");
                }
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
            if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Clear saved after changed");
            }
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException exception) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)BaseEditor.getString("_UI_FileConflict_label"), (String)BaseEditor.getString("_WARN_FileConflict"));
    }

    protected boolean isPersisted(Resource resource) {
        boolean result = false;
        try {
            InputStream stream = this.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (stream != null) {
                result = true;
                stream.close();
            }
        }
        catch (IOException iOException) {}
        return result;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected abstract void resumeResourceListening();

    public abstract void setSelection(ISelection var1);

    protected abstract void suspendResourceListening();

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.ecore.editor", 0, null, new Object[]{this.getResourceSet()});
            for (Diagnostic childDiagnostic : this.resourceToDiagnosticMap.values()) {
                if (childDiagnostic.getSeverity() == 0) continue;
                diagnostic.add(childDiagnostic);
            }
            int lastEditorPage = this.getPageCount() - 1;
            if (lastEditorPage >= 0 && this.getEditor(lastEditorPage) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(lastEditorPage)).setDiagnostic((Diagnostic)diagnostic);
                if (diagnostic.getSeverity() != 0) {
                    this.setActivePage(lastEditorPage);
                }
            } else if (diagnostic.getSeverity() != 0) {
                ProblemEditorPart problemEditorPart = new ProblemEditorPart();
                problemEditorPart.setDiagnostic((Diagnostic)diagnostic);
                problemEditorPart.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++lastEditorPage, (IEditorPart)problemEditorPart, this.getEditorInput());
                    this.setPageText(lastEditorPage, problemEditorPart.getPartName());
                    this.setActivePage(lastEditorPage);
                }
                catch (PartInitException exception) {
                    QVTEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.getResourceSet());
                if (diagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)diagnostic);
                    }
                    catch (CoreException exception) {
                        QVTEditorPlugin.INSTANCE.log((Object)exception);
                    }
                }
            }
        }
    }

    private final class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        public void mouseDoubleClick(MouseEvent event) {
            if (event.button == 1) {
                try {
                    BaseEditor.this.getEditorSite().getPage().showView("org.eclipse.ui.views.PropertySheet");
                }
                catch (PartInitException exception) {
                    QVTEditorPlugin.INSTANCE.log((Object)exception);
                }
            }
        }
    }

    private final class ProblemIndicationAdapter
    extends EContentAdapter {
        private ProblemIndicationAdapter() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = BaseEditor.this.analyzeResourceProblems(resource, null);
                        if (diagnostic.getSeverity() != 0) {
                            BaseEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            BaseEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!BaseEditor.this.updateProblemIndication) return;
                        BaseEditor.this.getDisplay().asyncExec((Runnable)new UpdateProblemIndicationRunnable());
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource target) {
            this.basicSetTarget((Notifier)target);
        }

        protected void unsetTarget(Resource target) {
            this.basicUnsetTarget((Notifier)target);
        }
    }

    private final class ResourceChangeListener
    implements IResourceChangeListener {
        private ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                Map refactoredResources = visitor.getRefactoredResources();
                if (!refactoredResources.isEmpty()) {
                    if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                        for (Resource removedResource : refactoredResources.keySet()) {
                            QVTEditorPlugin.EDITOR_SAVE.println(this.getClass(), "Removed " + removedResource.getURI().toString());
                        }
                    }
                    BaseEditor.this.removedResources.addAll(refactoredResources.keySet());
                    if (!BaseEditor.this.isDirty()) {
                        BaseEditor.this.getDisplay().asyncExec((Runnable)new ResourceRemovedRunnable());
                    } else {
                        for (Resource removedResource : refactoredResources.keySet()) {
                            IPath path;
                            if (!(removedResource instanceof TextResource) || (path = (IPath)refactoredResources.get(removedResource)) == null) continue;
                            BaseEditor.this.getDisplay().asyncExec((Runnable)new ResourceRenamedRunnable(path));
                        }
                    }
                }
                if (!visitor.getChangedResources().isEmpty()) {
                    if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                        for (Resource changedResource : visitor.getChangedResources()) {
                            QVTEditorPlugin.EDITOR_SAVE.println(this.getClass(), "Changed " + changedResource.getURI().toString());
                        }
                    }
                    BaseEditor.this.changedResources.addAll(visitor.getChangedResources());
                    if (BaseEditor.this.getSite().getPage().getActiveEditor() == BaseEditor.this) {
                        BaseEditor.this.getDisplay().asyncExec((Runnable)new ResourceChangedRunnable());
                    }
                }
            }
            catch (CoreException exception) {
                QVTEditorPlugin.INSTANCE.log((Object)exception);
            }
        }
    }

    private final class ResourceChangedRunnable
    implements Runnable {
        private ResourceChangedRunnable() {
        }

        public void run() {
            if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                QVTEditorPlugin.EDITOR_SAVE.println(this.getClass(), "run");
            }
            BaseEditor.this.handleActivate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        protected ResourceSet resourceSet;
        protected Collection<Resource> changedResources;
        protected Map<Resource, IPath> refactoredResources;

        private ResourceDeltaVisitor() {
            this.resourceSet = BaseEditor.this.getResourceSet();
            this.changedResources = new ArrayList<Resource>();
            this.refactoredResources = new HashMap<Resource, IPath>();
        }

        public boolean visit(IResourceDelta delta) {
            if (delta.getResource().getType() == 1) {
                URI uri;
                Resource resource;
                int flags = delta.getFlags();
                int kind = delta.getKind();
                if ((kind & 2) != 0) {
                    URI uri2 = URI.createURI((String)delta.getFullPath().toString(), (boolean)true);
                    Resource resource2 = this.resourceSet.getResource(uri2, false);
                    if (resource2 != null) {
                        if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                            QVTEditorPlugin.EDITOR_SAVE.println(this.getClass(), "Removed " + resource2.getURI().toString());
                        }
                        this.refactoredResources.put(resource2, delta.getMovedToPath());
                    }
                } else if (!((kind & 4) == 0 || (flags & 0xFFFDFFFF) == 0 || (resource = this.resourceSet.getResource(uri = URI.createURI((String)delta.getFullPath().toString(), (boolean)true), false)) == null || resource instanceof TextResource && ((TextResource)resource).isSaveInProgress())) {
                    if (!BaseEditor.this.savedResources.remove(resource)) {
                        if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                            QVTEditorPlugin.EDITOR_SAVE.println(this.getClass(), "Changed " + resource.getURI().toString());
                        }
                        this.changedResources.add(resource);
                    } else if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                        QVTEditorPlugin.EDITOR_SAVE.println(this.getClass(), "Saved " + resource.getURI().toString());
                    }
                }
            }
            return true;
        }

        private Collection<Resource> getChangedResources() {
            return this.changedResources;
        }

        private Map<Resource, IPath> getRefactoredResources() {
            return this.refactoredResources;
        }
    }

    private final class ResourceRemovedRunnable
    implements Runnable {
        private ResourceRemovedRunnable() {
        }

        public void run() {
            if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                QVTEditorPlugin.EDITOR_SAVE.println(this.getClass(), "run");
            }
            BaseEditor.this.getSite().getPage().closeEditor((IEditorPart)BaseEditor.this, false);
        }
    }

    private final class ResourceRenamedRunnable
    implements Runnable {
        private IPath path;

        public ResourceRenamedRunnable(IPath path) {
            this.path = path;
        }

        public void run() {
            BaseEditor.this.setPartName(this.path.lastSegment());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SaveOperation1
    extends WorkspaceModifyOperation {
        private final Map<Object, Object> saveOptions;

        private SaveOperation1(Map<Object, Object> saveOptions) {
            this.saveOptions = saveOptions;
        }

        public void execute(IProgressMonitor monitor) {
            BaseEditor.this.suspendResourceListening();
            boolean first = true;
            for (Resource resource : BaseEditor.this.getResourceSet().getResources()) {
                block10: {
                    if (!first && resource.getContents().isEmpty() && !BaseEditor.this.isPersisted(resource) || BaseEditor.this.getEditingDomain().isReadOnly(resource)) continue;
                    try {
                        try {
                            BaseEditor.this.savingResources.add(resource);
                            BaseEditor.this.savedResources.add(resource);
                            if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                                QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Save " + resource.getURI().toString());
                            }
                            resource.save(this.saveOptions);
                        }
                        catch (Exception exception) {
                            BaseEditor.this.resourceToDiagnosticMap.put(resource, BaseEditor.this.analyzeResourceProblems(resource, exception));
                            if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                                QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Saved all");
                            }
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                            QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Saved all");
                        }
                        throw throwable;
                    }
                    if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                        QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Saved all");
                    }
                }
                first = false;
            }
        }
    }

    private final class SaveOperation2
    extends WorkspaceModifyOperation {
        private SaveOperation2() {
        }

        public void execute(IProgressMonitor monitor) {
            BaseEditor.this.resumeResourceListening();
            if (QVTEditorPlugin.EDITOR_SAVE.isActive()) {
                QVTEditorPlugin.EDITOR_SAVE.println(((Object)((Object)this)).getClass(), "Saved all2");
            }
        }
    }

    private final class UpdateProblemIndicationRunnable
    implements Runnable {
        private UpdateProblemIndicationRunnable() {
        }

        public void run() {
            BaseEditor.this.updateProblemIndication();
        }
    }
}

