/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.ui.explorer;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.imp.model.ModelFactory;
import org.eclipse.imp.runtime.RuntimePlugin;
import org.eclipse.imp.ui.explorer.CollapseAllAction;
import org.eclipse.imp.ui.explorer.CompositeActionGroup;
import org.eclipse.imp.ui.explorer.ExplorerFrameSource;
import org.eclipse.imp.ui.explorer.LayoutActionGroup;
import org.eclipse.imp.ui.explorer.NavigateActionGroup;
import org.eclipse.imp.ui.explorer.NewWizardsActionGroup;
import org.eclipse.imp.ui.explorer.ProjectActionGroup;
import org.eclipse.imp.ui.explorer.ProjectExplorerPart;
import org.eclipse.imp.ui.explorer.ViewActionGroup;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.internal.ui.packageview.ToggleLinkingAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.GenerateBuildPathActionGroup;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetShowActionGroup;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.actions.BuildActionGroup;
import org.eclipse.jdt.ui.actions.CCPActionGroup;
import org.eclipse.jdt.ui.actions.CustomFiltersActionGroup;
import org.eclipse.jdt.ui.actions.GenerateActionGroup;
import org.eclipse.jdt.ui.actions.ImportActionGroup;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jdt.ui.actions.RefactorActionGroup;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.OpenInNewWindowAction;
import org.eclipse.ui.views.framelist.BackAction;
import org.eclipse.ui.views.framelist.ForwardAction;
import org.eclipse.ui.views.framelist.Frame;
import org.eclipse.ui.views.framelist.FrameAction;
import org.eclipse.ui.views.framelist.FrameList;
import org.eclipse.ui.views.framelist.GoIntoAction;
import org.eclipse.ui.views.framelist.IFrameSource;
import org.eclipse.ui.views.framelist.TreeFrame;
import org.eclipse.ui.views.framelist.UpAction;

public class ProjectExplorerActionGroup
extends CompositeActionGroup {
    private ProjectExplorerPart fPart;
    private FrameList fFrameList;
    private GoIntoAction fZoomInAction;
    private BackAction fBackAction;
    private ForwardAction fForwardAction;
    private UpAction fUpAction;
    private CollapseAllAction fCollapseAllAction;
    private ToggleLinkingAction fToggleLinkingAction;
    private RefactorActionGroup fRefactorActionGroup;
    private NavigateActionGroup fNavigateActionGroup;
    private ViewActionGroup fViewActionGroup;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;

    public ProjectExplorerActionGroup(ProjectExplorerPart part) {
        this.fPart = part;
        TreeViewer viewer = part.getViewer();
        IPropertyChangeListener workingSetListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                try {
                    ProjectExplorerActionGroup.this.doWorkingSetChanged(event);
                }
                catch (ModelFactory.ModelException e) {
                    RuntimePlugin.getInstance().logException("Error when responding to working set change", e);
                }
            }
        };
        IWorkbenchPartSite site = this.fPart.getSite();
        ActionGroup[] actionGroupArray = new ActionGroup[14];
        actionGroupArray[0] = new NewWizardsActionGroup((IWorkbenchSite)site);
        this.fNavigateActionGroup = new NavigateActionGroup((IViewPart)this.fPart);
        actionGroupArray[1] = this.fNavigateActionGroup;
        actionGroupArray[2] = new CCPActionGroup((IViewPart)this.fPart);
        actionGroupArray[3] = new GenerateBuildPathActionGroup((IViewPart)this.fPart);
        actionGroupArray[4] = new GenerateActionGroup((IViewPart)this.fPart);
        this.fRefactorActionGroup = new RefactorActionGroup((IViewPart)this.fPart);
        actionGroupArray[5] = this.fRefactorActionGroup;
        actionGroupArray[6] = new ImportActionGroup((IViewPart)this.fPart);
        actionGroupArray[7] = new BuildActionGroup((IViewPart)this.fPart);
        actionGroupArray[8] = new JavaSearchActionGroup((IViewPart)this.fPart);
        actionGroupArray[9] = new ProjectActionGroup((IViewPart)this.fPart);
        this.fViewActionGroup = new ViewActionGroup(this.fPart.getRootMode(), workingSetListener, site);
        actionGroupArray[10] = this.fViewActionGroup;
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this.fPart, (StructuredViewer)viewer);
        actionGroupArray[11] = this.fCustomFiltersActionGroup;
        actionGroupArray[12] = new LayoutActionGroup(this.fPart);
        actionGroupArray[13] = new WorkingSetShowActionGroup(site);
        this.setGroups(actionGroupArray);
        this.fViewActionGroup.fillFilters((StructuredViewer)viewer);
        ExplorerFrameSource frameSource = new ExplorerFrameSource(this.fPart);
        this.fFrameList = new FrameList((IFrameSource)frameSource);
        frameSource.connectTo(this.fFrameList);
        this.fZoomInAction = new GoIntoAction(this.fFrameList);
        this.fBackAction = new BackAction(this.fFrameList);
        this.fForwardAction = new ForwardAction(this.fFrameList);
        this.fUpAction = new UpAction(this.fFrameList);
        this.fCollapseAllAction = new CollapseAllAction(this.fPart);
    }

    public void dispose() {
        super.dispose();
    }

    void restoreFilterAndSorterState(IMemento memento) {
        this.fViewActionGroup.restoreState(memento);
        this.fCustomFiltersActionGroup.restoreState(memento);
    }

    void saveFilterAndSorterState(IMemento memento) {
        this.fViewActionGroup.saveState(memento);
        this.fCustomFiltersActionGroup.saveState(memento);
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        this.setGlobalActionHandlers(actionBars);
        this.fillToolBar(actionBars.getToolBarManager());
        this.fillViewMenu(actionBars.getMenuManager());
    }

    void updateActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().removeAll();
        actionBars.getMenuManager().removeAll();
        this.fillActionBars(actionBars);
        actionBars.updateActionBars();
        this.fZoomInAction.setEnabled(true);
    }

    private void setGlobalActionHandlers(IActionBars actionBars) {
        actionBars.setGlobalActionHandler("goInto", (IAction)this.fZoomInAction);
        actionBars.setGlobalActionHandler(ActionFactory.BACK.getId(), (IAction)this.fBackAction);
        actionBars.setGlobalActionHandler(ActionFactory.FORWARD.getId(), (IAction)this.fForwardAction);
        actionBars.setGlobalActionHandler("up", (IAction)this.fUpAction);
        this.fRefactorActionGroup.retargetFileMenuActions(actionBars);
    }

    void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IAction)this.fBackAction);
        toolBar.add((IAction)this.fForwardAction);
        toolBar.add((IAction)this.fUpAction);
        toolBar.add((IContributionItem)new Separator());
        toolBar.add((IAction)this.fCollapseAllAction);
    }

    void fillViewMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("additions-end"));
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        int size = selection.size();
        Object element = selection.getFirstElement();
        this.addGotoMenu(menu, element, size);
        this.addOpenNewWindowAction(menu, element);
        super.fillContextMenu(menu);
    }

    private void addGotoMenu(IMenuManager menu, Object element, int size) {
        boolean enabled = size == 1 && this.fPart.getViewer().isExpandable(element) && (this.isGoIntoTarget(element) || element instanceof IContainer);
        this.fZoomInAction.setEnabled(enabled);
        if (enabled) {
            menu.appendToGroup("group.goto", (IAction)this.fZoomInAction);
        }
    }

    private boolean isGoIntoTarget(Object element) {
        if (element == null) {
            return false;
        }
        if (element instanceof IJavaElement) {
            int type = ((IJavaElement)element).getElementType();
            return type == 2 || type == 3 || type == 4;
        }
        return element instanceof IWorkingSet;
    }

    private void addOpenNewWindowAction(IMenuManager menu, Object element) {
        if (element instanceof IJavaElement) {
            element = ((IJavaElement)element).getResource();
        }
        if (element instanceof IProject && !((IProject)element).isOpen()) {
            return;
        }
        if (!(element instanceof IContainer)) {
            return;
        }
        menu.appendToGroup("group.open", (IAction)new OpenInNewWindowAction(this.fPart.getSite().getWorkbenchWindow(), (IAdaptable)((IContainer)element)));
    }

    void handleDoubleClick(DoubleClickEvent event) {
        IStructuredSelection selection;
        Object element;
        TreeViewer viewer = this.fPart.getViewer();
        if (viewer.isExpandable(element = (selection = (IStructuredSelection)event.getSelection()).getFirstElement())) {
            if (this.doubleClickGoesInto()) {
                if (element instanceof ICompilationUnit || element instanceof IClassFile) {
                    return;
                }
                if (element instanceof IOpenable || element instanceof IContainer || element instanceof IWorkingSet) {
                    this.fZoomInAction.run();
                }
            } else {
                IAction openAction = this.fNavigateActionGroup.getOpenAction();
                if (openAction != null && openAction.isEnabled() && OpenStrategy.getOpenMethod() == 0) {
                    return;
                }
                if (selection instanceof ITreeSelection) {
                    TreePath[] paths = ((ITreeSelection)selection).getPathsFor(element);
                    int i = 0;
                    while (i < paths.length) {
                        viewer.setExpandedState((Object)paths[i], !viewer.getExpandedState((Object)paths[i]));
                        ++i;
                    }
                } else {
                    viewer.setExpandedState(element, !viewer.getExpandedState(element));
                }
            }
        }
    }

    void handleOpen(OpenEvent event) {
        IAction openAction = this.fNavigateActionGroup.getOpenAction();
        if (openAction != null && openAction.isEnabled()) {
            openAction.run();
            return;
        }
    }

    void handleKeyEvent(KeyEvent event) {
        if (event.stateMask != 0) {
            return;
        }
        if (event.keyCode == 8 && this.fUpAction != null && this.fUpAction.isEnabled()) {
            this.fUpAction.run();
            event.doit = false;
        }
    }

    private void doWorkingSetChanged(PropertyChangeEvent event) throws ModelFactory.ModelException {
        if (ViewActionGroup.MODE_CHANGED.equals(event.getProperty())) {
            this.fPart.rootModeChanged((Integer)event.getNewValue());
            Object oldInput = null;
            Object newInput = null;
            if (this.fPart.showProjects()) {
                oldInput = this.fPart.getWorkingSetModel();
                newInput = ModelFactory.open((IContainer)ResourcesPlugin.getWorkspace().getRoot());
            } else if (this.fPart.showWorkingSets()) {
                oldInput = ModelFactory.open((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                newInput = this.fPart.getWorkingSetModel();
            }
            if (oldInput != null && newInput != null) {
                Frame frame;
                int i = 0;
                while ((frame = this.fFrameList.getFrame(i)) != null) {
                    TreeFrame treeFrame;
                    if (frame instanceof TreeFrame && oldInput.equals((treeFrame = (TreeFrame)frame).getInput())) {
                        treeFrame.setInput(newInput);
                    }
                    ++i;
                }
            }
        } else {
            IWorkingSet workingSet = (IWorkingSet)event.getNewValue();
            if (workingSet != null) {
                workingSet.getLabel();
            }
            this.fPart.updateTitle();
            String property = event.getProperty();
            if ("workingSetContentChange".equals(property)) {
                TreeViewer viewer = this.fPart.getViewer();
                viewer.getControl().setRedraw(false);
                viewer.refresh();
                viewer.getControl().setRedraw(true);
            }
        }
    }

    private boolean doubleClickGoesInto() {
        return "packageview.gointo".equals(PreferenceConstants.getPreferenceStore().getString("packageview.doubleclick"));
    }

    public FrameAction getUpAction() {
        return this.fUpAction;
    }

    public FrameAction getBackAction() {
        return this.fBackAction;
    }

    public FrameAction getForwardAction() {
        return this.fForwardAction;
    }

    public ViewActionGroup getWorkingSetActionGroup() {
        return this.fViewActionGroup;
    }

    public CustomFiltersActionGroup getCustomFilterActionGroup() {
        return this.fCustomFiltersActionGroup;
    }

    public FrameList getFrameList() {
        return this.fFrameList;
    }
}

