/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.CodeGen;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.DeprecatedPlatformRunnable;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Generator
extends CodeGen {
    protected String basePackage;
    public static int EMF_MODEL_PROJECT_STYLE = 1;
    public static int EMF_EDIT_PROJECT_STYLE = 2;
    public static int EMF_EDITOR_PROJECT_STYLE = 4;
    public static int EMF_XML_PROJECT_STYLE = 8;
    public static int EMF_PLUGIN_PROJECT_STYLE = 16;
    public static int EMF_EMPTY_PROJECT_STYLE = 32;
    public static int EMF_TESTS_PROJECT_STYLE = 64;
    public static int EMF_GWT_PROJECT_STYLE = 128;

    @Deprecated
    public static void main(String[] args) {
        new Generator().run(args);
    }

    public void printGenerateUsage() {
        System.out.println("Usage arguments:");
        System.out.println("  [-projects <project-root-directory>]");
        System.out.println("  [-dynamicTemplates] [-forceOverwrite | -diff]");
        System.out.println("  [-generateSchema] [-nonNLSMarkers]");
        System.out.println("  [-codeFormatting { default | <profile-file> } ]");
        System.out.println("  [-model] [-edit] [-editor] [-tests]");
        System.out.println("  [-autoBuild <true|false>]");
        System.out.println("  [-reconile]");
        System.out.println("  <genmodel-file>");
        System.out.println("  [ <target-root-directory> ]");
        System.out.println("");
        System.out.println("For example:");
        System.out.println("");
        System.out.println("  generate result/model/Extended.genmodel");
    }

    public Object run(Object object) {
        return PlatformRunnable.run(this, object);
    }

    protected String findOrCreateContainerHelper(String rootLocation, String encodedPath, Monitor progressMonitor) throws CoreException {
        return EclipseHelper.findOrCreateContainerHelper(rootLocation, encodedPath, progressMonitor);
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List<IProject> referencedProjects, IProgressMonitor progressMonitor, int style) {
        return Generator.createEMFProject(javaSource, projectLocationPath, referencedProjects, progressMonitor, style, Collections.emptyList());
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List<IProject> referencedProjects, IProgressMonitor progressMonitor, int style, List<?> pluginVariables) {
        return EclipseHelper.createEMFProject(javaSource, projectLocationPath, referencedProjects, BasicMonitor.toMonitor((IProgressMonitor)progressMonitor), style, pluginVariables);
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List<IProject> referencedProjects, Monitor progressMonitor, int style) {
        return Generator.createEMFProject(javaSource, projectLocationPath, referencedProjects, progressMonitor, style, Collections.emptyList());
    }

    public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List<IProject> referencedProjects, Monitor progressMonitor, int style, List<?> pluginVariables) {
        return EclipseHelper.createEMFProject(javaSource, projectLocationPath, referencedProjects, progressMonitor, style, pluginVariables);
    }

    public static IProject createEMFProject(IPath javaSource, URI projectLocationURI, List<IProject> referencedProjects, Monitor progressMonitor, int style, List<?> pluginVariables) {
        return EclipseHelper.createEMFProject(javaSource, projectLocationURI, referencedProjects, progressMonitor, style, pluginVariables);
    }

    public void printStatus(String prefix, IStatus status) {
        System.err.print(prefix);
        System.err.println(status.getMessage());
        IStatus[] children = status.getChildren();
        String childPrefix = "  " + prefix;
        int i = 0;
        while (i < children.length) {
            this.printStatus(childPrefix, children[i]);
            ++i;
        }
    }

    public static void setSDODefaults(GenModel genModel) {
        genModel.setRootExtendsInterface("");
        genModel.setRootImplementsInterface("org.eclipse.emf.ecore.sdo.InternalEDataObject");
        genModel.setRootExtendsClass("org.eclipse.emf.ecore.sdo.impl.EDataObjectImpl");
        genModel.setFeatureMapWrapperInterface("commonj.sdo.Sequence");
        genModel.setFeatureMapWrapperInternalInterface("org.eclipse.emf.ecore.sdo.util.ESequence");
        genModel.setFeatureMapWrapperClass("org.eclipse.emf.ecore.sdo.util.BasicESequence");
        genModel.setSuppressEMFTypes(true);
        genModel.setSuppressEMFMetaData(true);
        genModel.getModelPluginVariables().add((Object)"EMF_COMMONJ_SDO=org.eclipse.emf.commonj.sdo");
        genModel.getModelPluginVariables().add((Object)"EMF_ECORE_SDO=org.eclipse.emf.ecore.sdo");
        genModel.getStaticPackages().add((Object)"http://www.eclipse.org/emf/2003/SDO");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CodeFormatterProfileParser
    extends DefaultHandler {
        private Map<String, String> options = null;
        private String SETTING = "setting";
        private String ID = "id";
        private String VALUE = "value";
        private String EMPTY = "";

        CodeFormatterProfileParser() {
        }

        @Override
        public void startDocument() {
            this.options = new HashMap<String, String>();
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) {
            if (this.EMPTY.equals(namespaceURI) && this.SETTING.equals(localName)) {
                String id = atts.getValue(this.EMPTY, this.ID);
                String value = atts.getValue(this.EMPTY, this.VALUE);
                if (id != null && value != null) {
                    this.options.put(id, value);
                }
            }
        }

        public Map<String, String> getOptions() {
            return this.options;
        }

        public static Map<String, String> parse(String systemID) {
            try {
                XMLReader parser = XMLReaderFactory.createXMLReader();
                CodeFormatterProfileParser handler = new CodeFormatterProfileParser();
                parser.setContentHandler(handler);
                parser.parse(systemID);
                return handler.getOptions();
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EclipseHelper {
        private EclipseHelper() {
        }

        public static IProject createEMFProject(IPath javaSource, IPath projectLocationPath, List<IProject> referencedProjects, Monitor monitor, int style, List<?> pluginVariables) {
            return EclipseHelper.createEMFProject(javaSource, projectLocationPath == null ? null : URI.createFileURI((String)projectLocationPath.toOSString()), referencedProjects, monitor, style, pluginVariables);
        }

        public static IProject createEMFProject(IPath javaSource, URI projectLocationURI, List<IProject> referencedProjects, Monitor monitor, int style, List<?> pluginVariables) {
            IProgressMonitor progressMonitor = BasicMonitor.toIProgressMonitor((Monitor)monitor);
            String projectName = javaSource.segment(0);
            IProject project = null;
            try {
                try {
                    String[] natureIds;
                    UniqueEList classpathEntries = new UniqueEList();
                    progressMonitor.beginTask("", 10);
                    progressMonitor.subTask(CodeGenEcorePlugin.INSTANCE.getString("_UI_CreatingEMFProject_message", new Object[]{projectName, projectLocationURI != null ? projectLocationURI.toString() : projectName}));
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    project = workspace.getRoot().getProject(projectName);
                    if (!project.exists()) {
                        File projectFile;
                        URI location = projectLocationURI;
                        if (location == null) {
                            location = URI.createFileURI((String)workspace.getRoot().getLocation().append(projectName).toOSString());
                        }
                        if ((projectFile = new File((location = location.appendSegment(".project")).toString())).exists()) {
                            projectFile.renameTo(new File(String.valueOf(location.toString()) + ".old"));
                        }
                    }
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    IProjectDescription projectDescription = null;
                    if (!project.exists()) {
                        projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                        if (projectLocationURI != null) {
                            projectDescription.setLocationURI(new java.net.URI(projectLocationURI.toString()));
                        }
                        project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    } else {
                        projectDescription = project.getDescription();
                        project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                        if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                            classpathEntries.addAll(Arrays.asList(javaProject.getRawClasspath()));
                        }
                    }
                    boolean isInitiallyEmpty = classpathEntries.isEmpty();
                    if (referencedProjects.size() != 0 && (style & (EMF_PLUGIN_PROJECT_STYLE | EMF_EMPTY_PROJECT_STYLE)) == 0) {
                        projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                        for (IProject referencedProject : referencedProjects) {
                            IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                            classpathEntries.add(referencedProjectClasspathEntry);
                        }
                    }
                    if ((natureIds = projectDescription.getNatureIds()) == null) {
                        String[] stringArray;
                        if ((style & EMF_GWT_PROJECT_STYLE) == 0) {
                            String[] stringArray2 = new String[2];
                            stringArray2[0] = "org.eclipse.jdt.core.javanature";
                            stringArray = stringArray2;
                            stringArray2[1] = "org.eclipse.pde.PluginNature";
                        } else if ((style & EMF_EDITOR_PROJECT_STYLE) == 0) {
                            String[] stringArray3 = new String[3];
                            stringArray3[0] = "org.eclipse.jdt.core.javanature";
                            stringArray3[1] = "org.eclipse.pde.PluginNature";
                            stringArray = stringArray3;
                            stringArray3[2] = "com.google.gwt.eclipse.core.gwtNature";
                        } else {
                            String[] stringArray4 = new String[4];
                            stringArray4[0] = "org.eclipse.jdt.core.javanature";
                            stringArray4[1] = "org.eclipse.pde.PluginNature";
                            stringArray4[2] = "com.google.gwt.eclipse.core.gwtNature";
                            stringArray = stringArray4;
                            stringArray4[3] = "com.google.appengine.eclipse.core.gaeNature";
                        }
                        natureIds = stringArray;
                    } else {
                        String[] oldNatureIds;
                        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                            oldNatureIds = natureIds;
                            natureIds = new String[oldNatureIds.length + 1];
                            System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                            natureIds[oldNatureIds.length] = "org.eclipse.jdt.core.javanature";
                        }
                        if (!project.hasNature("org.eclipse.pde.PluginNature")) {
                            oldNatureIds = natureIds;
                            natureIds = new String[oldNatureIds.length + 1];
                            System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                            natureIds[oldNatureIds.length] = "org.eclipse.pde.PluginNature";
                        }
                        if ((style & EMF_GWT_PROJECT_STYLE) != 0 && !project.hasNature("com.google.gwt.eclipse.core.gwtNature")) {
                            oldNatureIds = natureIds;
                            natureIds = new String[oldNatureIds.length + 1];
                            System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                            natureIds[oldNatureIds.length] = "com.google.gwt.eclipse.core.gwtNature";
                        }
                        if ((style & EMF_GWT_PROJECT_STYLE) != 0 && (style & EMF_EDITOR_PROJECT_STYLE) != 0 && !project.hasNature("com.google.appengine.eclipse.core.gaeNature")) {
                            oldNatureIds = natureIds;
                            natureIds = new String[oldNatureIds.length + 1];
                            System.arraycopy(oldNatureIds, 0, natureIds, 0, oldNatureIds.length);
                            natureIds[oldNatureIds.length] = "com.google.appengine.eclipse.core.gaeNature";
                        }
                    }
                    projectDescription.setNatureIds(natureIds);
                    ICommand[] builders = projectDescription.getBuildSpec();
                    if (builders == null) {
                        builders = new ICommand[]{};
                    }
                    boolean hasGWTBuilder = false;
                    int enhancerBuilderIndex = -1;
                    int i = 0;
                    while (i < builders.length) {
                        if ("org.eclipse.emf.codegen.ecore.GWTBuilder".equals(builders[i].getBuilderName())) {
                            hasGWTBuilder = true;
                        }
                        if ("com.google.appengine.eclipse.core.enhancerbuilder".equals(builders[i].getBuilderName())) {
                            enhancerBuilderIndex = i;
                        }
                        ++i;
                    }
                    if ((style & EMF_GWT_PROJECT_STYLE) != 0 && (style & EMF_EDITOR_PROJECT_STYLE) != 0 && !hasGWTBuilder) {
                        ICommand[] oldBuilders = builders;
                        builders = new ICommand[oldBuilders.length + 1];
                        System.arraycopy(oldBuilders, 0, builders, 0, oldBuilders.length);
                        builders[oldBuilders.length] = projectDescription.newCommand();
                        builders[oldBuilders.length].setBuilderName("org.eclipse.emf.codegen.ecore.GWTBuilder");
                    }
                    if (enhancerBuilderIndex != -1) {
                        ICommand[] oldBuilders = builders;
                        builders = new ICommand[oldBuilders.length - 1];
                        System.arraycopy(oldBuilders, 0, builders, 0, enhancerBuilderIndex);
                        System.arraycopy(oldBuilders, enhancerBuilderIndex + 1, builders, enhancerBuilderIndex, oldBuilders.length - enhancerBuilderIndex - 1);
                    }
                    projectDescription.setBuildSpec(builders);
                    project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    IProject sourceContainer = project;
                    if (javaSource.segmentCount() > 1) {
                        IPath sourceContainerPath = javaSource.removeFirstSegments(1).makeAbsolute();
                        sourceContainer = project.getFolder(sourceContainerPath);
                        if (!sourceContainer.exists()) {
                            int i2 = sourceContainerPath.segmentCount() - 1;
                            while (i2 >= 0) {
                                sourceContainer = project.getFolder(sourceContainerPath.removeLastSegments(i2));
                                if (!sourceContainer.exists()) {
                                    ((IFolder)sourceContainer).create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                                }
                                --i2;
                            }
                        }
                        IClasspathEntry sourceClasspathEntry = JavaCore.newSourceEntry((IPath)javaSource);
                        boolean matched = false;
                        Iterator i3 = classpathEntries.iterator();
                        while (i3.hasNext() && !matched) {
                            IClasspathEntry classpathEntry = (IClasspathEntry)i3.next();
                            IPath path = classpathEntry.getPath();
                            if (!path.isPrefixOf(javaSource)) continue;
                            if (path.equals((Object)javaSource)) {
                                matched = true;
                                continue;
                            }
                            i3.remove();
                        }
                        if (!matched) {
                            classpathEntries.add(0, sourceClasspathEntry);
                        }
                    }
                    if (isInitiallyEmpty) {
                        IClasspathEntry jreClasspathEntry = JavaCore.newVariableEntry((IPath)new Path("JRE_LIB"), (IPath)new Path("JRE_SRC"), (IPath)new Path("JRE_SRCROOT"));
                        Iterator i4 = classpathEntries.iterator();
                        while (i4.hasNext()) {
                            IClasspathEntry classpathEntry = (IClasspathEntry)i4.next();
                            if (!classpathEntry.getPath().isPrefixOf(jreClasspathEntry.getPath())) continue;
                            i4.remove();
                        }
                        String jreContainer = JavaRuntime.JRE_CONTAINER;
                        String complianceLevel = CodeGenUtil.EclipseUtil.getJavaComplianceLevel((IProject)project);
                        if ("1.5".equals(complianceLevel)) {
                            jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5";
                        } else if (!"1.4".equals(complianceLevel)) {
                            jreContainer = String.valueOf(jreContainer) + "/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/JavaSE-" + complianceLevel;
                        }
                        classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(jreContainer)));
                    }
                    if ((style & EMF_EMPTY_PROJECT_STYLE) == 0) {
                        if ((style & EMF_PLUGIN_PROJECT_STYLE) != 0) {
                            classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                            if ((style & EMF_GWT_PROJECT_STYLE) != 0) {
                                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("com.google.gwt.eclipse.core.GWT_CONTAINER")));
                                if ((style & EMF_EDITOR_PROJECT_STYLE) != 0) {
                                    classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("com.google.appengine.eclipse.core.GAE_CONTAINER")));
                                }
                            }
                            Iterator<Object> i5 = classpathEntries.iterator();
                            while (i5.hasNext()) {
                                IClasspathEntry classpathEntry = (IClasspathEntry)i5.next();
                                if ((classpathEntry.getEntryKind() != 4 || "JRE_LIB".equals(classpathEntry.getPath().toString())) && classpathEntry.getEntryKind() != 2) continue;
                                i5.remove();
                            }
                        } else {
                            CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_CORE_RUNTIME", (String)"org.eclipse.core.runtime");
                            CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_CORE_RESOURCES", (String)"org.eclipse.core.resources");
                            CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_COMMON", (String)"org.eclipse.emf.common");
                            CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_ECORE", (String)"org.eclipse.emf.ecore");
                            if ((style & EMF_XML_PROJECT_STYLE) != 0) {
                                CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_ECORE_XMI", (String)"org.eclipse.emf.ecore.xmi");
                            }
                            if ((style & EMF_MODEL_PROJECT_STYLE) == 0) {
                                CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_EDIT", (String)"org.eclipse.emf.edit");
                                if ((style & EMF_EDIT_PROJECT_STYLE) == 0) {
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_SWT", (String)"org.eclipse.swt");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_JFACE", (String)"org.eclipse.jface");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_UI_VIEWS", (String)"org.eclipse.ui.views");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_UI_EDITORS", (String)"org.eclipse.ui.editors");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_UI_IDE", (String)"org.eclipse.ui.ide");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"ECLIPSE_UI_WORKBENCH", (String)"org.eclipse.ui.workbench");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_COMMON_UI", (String)"org.eclipse.emf.common.ui");
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_EDIT_UI", (String)"org.eclipse.emf.edit.ui");
                                    if ((style & EMF_XML_PROJECT_STYLE) == 0) {
                                        CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"EMF_ECORE_XMI", (String)"org.eclipse.emf.ecore.xmi");
                                    }
                                }
                            }
                            if ((style & EMF_TESTS_PROJECT_STYLE) != 0) {
                                CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)"JUNIT", (String)"org.junit");
                            }
                            if (pluginVariables != null) {
                                for (Object variable : pluginVariables) {
                                    String id;
                                    String name;
                                    if (variable instanceof IClasspathEntry) {
                                        classpathEntries.add((IClasspathEntry)variable);
                                        continue;
                                    }
                                    if (!(variable instanceof String)) continue;
                                    String pluginVariable = (String)variable;
                                    int index = pluginVariable.indexOf("=");
                                    if (index == -1) {
                                        name = pluginVariable.replace('.', '_').toUpperCase();
                                        id = pluginVariable;
                                    } else {
                                        name = pluginVariable.substring(0, index);
                                        id = pluginVariable.substring(index + 1);
                                    }
                                    CodeGenUtil.EclipseUtil.addClasspathEntries((Collection)classpathEntries, (String)name, (String)id);
                                }
                            }
                        }
                    }
                    javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    if (isInitiallyEmpty) {
                        javaProject.setOutputLocation((IPath)new Path("/" + javaSource.segment(0) + ((style & EMF_GWT_PROJECT_STYLE) != 0 && (style & EMF_EDITOR_PROJECT_STYLE) != 0 ? "/war/WEB-INF/classes" : "/bin")), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    CodeGenEcorePlugin.INSTANCE.log(exception);
                    progressMonitor.done();
                }
            }
            finally {
                progressMonitor.done();
            }
            return project;
        }

        public static String findOrCreateContainerHelper(String rootLocation, String encodedPath, Monitor progressMonitor) throws CoreException {
            int index = encodedPath.indexOf("/./");
            if (encodedPath.endsWith("/.") && index != -1) {
                Path modelProjectLocation = new Path(encodedPath.substring(0, index));
                Path fragmentPath = new Path(encodedPath.substring(index + 3, encodedPath.length() - 2));
                IPath projectRelativePath = new Path(modelProjectLocation.lastSegment()).append((IPath)fragmentPath);
                CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)projectRelativePath, (boolean)true, (IPath)modelProjectLocation, (IProgressMonitor)BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)progressMonitor, (int)1)));
                return projectRelativePath.makeAbsolute().toString();
            }
            if (rootLocation != null) {
                index = encodedPath.indexOf("/org.");
                if (index == -1) {
                    index = encodedPath.indexOf("/com.");
                }
                if (index == -1) {
                    index = encodedPath.indexOf("/javax.");
                }
                if (index != -1) {
                    Path projectRelativePath = new Path(encodedPath.substring(index, encodedPath.length()));
                    if ((index = encodedPath.indexOf("/", index + 5)) != -1) {
                        Path modelProjectLocation = new Path(String.valueOf(rootLocation) + "/" + encodedPath.substring(0, index));
                        CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)projectRelativePath, (boolean)true, (IPath)modelProjectLocation, (IProgressMonitor)BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.createMonitor((Monitor)progressMonitor, (int)1)));
                        return projectRelativePath.makeAbsolute().toString();
                    }
                }
            }
            return encodedPath;
        }
    }

    public static class PlatformRunnable
    extends Generator
    implements IApplication,
    DeprecatedPlatformRunnable {
        public Object start(IApplicationContext context) throws Exception {
            String[] args = (String[])context.getArguments().get("application.args");
            return this.run(args == null ? new String[]{} : args);
        }

        public void stop() {
        }

        public Object run(Object object) {
            return PlatformRunnable.run(this, object);
        }

        public static Object run(final Generator generator, Object object) {
            try {
                final String[] arguments = (String[])object;
                final IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor progressMonitor) throws CoreException {
                        block61: {
                            Monitor monitor = BasicMonitor.toMonitor((IProgressMonitor)progressMonitor);
                            try {
                                try {
                                    IStatus status;
                                    boolean reconcileSuccessful;
                                    IWorkspaceDescription description;
                                    if (arguments.length == 0) {
                                        generator.printGenerateUsage();
                                        break block61;
                                    }
                                    if ("-ecore2GenModel".equalsIgnoreCase(arguments[0])) {
                                        Path ecorePath = new Path(arguments[1]);
                                        generator.basePackage = arguments[2];
                                        String prefix = arguments[3];
                                        ResourceSetImpl resourceSet = new ResourceSetImpl();
                                        resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                                        URI ecoreURI = URI.createFileURI((String)ecorePath.toString());
                                        Resource resource = resourceSet.getResource(ecoreURI, true);
                                        EPackage ePackage = (EPackage)resource.getContents().get(0);
                                        IPath genModelPath = ecorePath.removeFileExtension().addFileExtension("genmodel");
                                        progressMonitor.beginTask("", 2);
                                        progressMonitor.subTask("Creating " + genModelPath);
                                        URI genModelURI = URI.createFileURI((String)genModelPath.toString());
                                        Resource genModelResource = Resource.Factory.Registry.INSTANCE.getFactory(genModelURI).createResource(genModelURI);
                                        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
                                        genModelResource.getContents().add((Object)genModel);
                                        resourceSet.getResources().add((Object)genModelResource);
                                        genModel.setModelDirectory("/TargetProject/src");
                                        genModel.getForeignModel().add((Object)ecorePath.toString());
                                        genModel.initialize(Collections.singleton(ePackage));
                                        GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
                                        genModel.setModelName(genModelURI.trimFileExtension().lastSegment());
                                        genPackage.setPrefix(prefix);
                                        genPackage.setBasePackage(generator.basePackage);
                                        progressMonitor.worked(1);
                                        if (arguments.length > 4 && "-sdo".equals(arguments[4])) {
                                            PlatformRunnable.setSDODefaults(genModel);
                                        }
                                        genModelResource.save(Collections.EMPTY_MAP);
                                        break block61;
                                    }
                                    String rootLocation = null;
                                    boolean dynamicTemplates = false;
                                    boolean diff = false;
                                    boolean forceOverwrite = false;
                                    boolean generateSchema = false;
                                    boolean nonNLSMarkers = false;
                                    boolean codeFormatting = false;
                                    String profileFile = null;
                                    boolean model = false;
                                    boolean edit = false;
                                    boolean editor = false;
                                    boolean tests = false;
                                    boolean reconcile = false;
                                    Boolean autoBuild = null;
                                    int index = 0;
                                    while (index < arguments.length && arguments[index].startsWith("-")) {
                                        if (arguments[index].equalsIgnoreCase("-projects")) {
                                            rootLocation = new File(arguments[++index]).getAbsoluteFile().getCanonicalPath();
                                        } else if (arguments[index].equalsIgnoreCase("-autoBuild")) {
                                            autoBuild = Boolean.valueOf(arguments[++index]);
                                        } else if (arguments[index].equalsIgnoreCase("-dynamicTemplates")) {
                                            dynamicTemplates = true;
                                        } else if (arguments[index].equalsIgnoreCase("-diff")) {
                                            diff = true;
                                        } else if (arguments[index].equalsIgnoreCase("-forceOverwrite")) {
                                            forceOverwrite = true;
                                        } else if (arguments[index].equalsIgnoreCase("-generateSchema")) {
                                            generateSchema = true;
                                        } else if (arguments[index].equalsIgnoreCase("-nonNLSMarkers")) {
                                            nonNLSMarkers = true;
                                        } else if (arguments[index].equalsIgnoreCase("-codeFormatting")) {
                                            codeFormatting = true;
                                            if ("default".equals(profileFile = arguments[++index])) {
                                                profileFile = null;
                                            }
                                        } else if (arguments[index].equalsIgnoreCase("-model")) {
                                            model = true;
                                        } else if (arguments[index].equalsIgnoreCase("-edit")) {
                                            edit = true;
                                        } else if (arguments[index].equalsIgnoreCase("-editor")) {
                                            editor = true;
                                        } else if (arguments[index].equalsIgnoreCase("-tests")) {
                                            tests = true;
                                        } else if (arguments[index].equalsIgnoreCase("-reconcile")) {
                                            reconcile = true;
                                        } else {
                                            throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), 0, "Unrecognized argument: '" + arguments[index] + "'", null));
                                        }
                                        ++index;
                                    }
                                    if (!(model || edit || editor || tests)) {
                                        model = true;
                                    }
                                    String genModelName = arguments[index++];
                                    progressMonitor.beginTask("Generating " + genModelName, 2);
                                    if (autoBuild != null && (description = workspace.getDescription()).isAutoBuilding() != autoBuild.booleanValue()) {
                                        description.setAutoBuilding(autoBuild.booleanValue());
                                        try {
                                            workspace.setDescription(description);
                                        }
                                        catch (CoreException coreException) {
                                            generator.printStatus("Unable to set autoBuild to " + autoBuild.toString() + ".  Code generation will proceed normally.", coreException.getStatus());
                                        }
                                    }
                                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                                    resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
                                    URI genModelURI = URI.createFileURI((String)new File(genModelName).getAbsoluteFile().getCanonicalPath());
                                    Resource genModelResource = resourceSet.getResource(genModelURI, true);
                                    GenModel genModel = (GenModel)genModelResource.getContents().get(0);
                                    if (reconcile && !(reconcileSuccessful = genModel.reconcile())) {
                                        generator.printStatus("", (IStatus)new Status(2, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), "Can't reconcile the generator model."));
                                    }
                                    if (!(status = genModel.validate()).isOK()) {
                                        generator.printStatus("", status);
                                    } else {
                                        org.eclipse.emf.codegen.ecore.generator.Generator gen = new org.eclipse.emf.codegen.ecore.generator.Generator();
                                        gen.setInput(genModel);
                                        if (dynamicTemplates) {
                                            genModel.setDynamicTemplates(true);
                                        }
                                        if (forceOverwrite) {
                                            genModel.setForceOverwrite(true);
                                        }
                                        if (diff) {
                                            genModel.setRedirection(".{0}.new");
                                        }
                                        if (index < arguments.length) {
                                            Path path = new Path(genModel.getModelDirectory());
                                            Path targetRootDirectory = new Path(arguments[index]);
                                            targetRootDirectory = new Path(targetRootDirectory.toFile().getAbsoluteFile().getCanonicalPath());
                                            CodeGenUtil.EclipseUtil.findOrCreateContainer((IPath)new Path(path.segment(0)), (boolean)true, (IPath)targetRootDirectory, (IProgressMonitor)BasicMonitor.toIProgressMonitor((Monitor)CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1)));
                                        } else {
                                            String modelDirectory = genModel.getModelDirectory();
                                            genModel.setModelDirectory(generator.findOrCreateContainerHelper(rootLocation, modelDirectory, monitor));
                                            String editDirectory = genModel.getEditDirectory();
                                            if (edit && editDirectory != null) {
                                                genModel.setEditDirectory(generator.findOrCreateContainerHelper(rootLocation, editDirectory, monitor));
                                            }
                                            String editorDirectory = genModel.getEditorDirectory();
                                            if (editor && editorDirectory != null) {
                                                genModel.setEditorDirectory(generator.findOrCreateContainerHelper(rootLocation, editorDirectory, monitor));
                                            }
                                            String testsDirectory = genModel.getTestsDirectory();
                                            if (tests && testsDirectory != null) {
                                                genModel.setTestsDirectory(generator.findOrCreateContainerHelper(rootLocation, testsDirectory, monitor));
                                            }
                                        }
                                        genModel.setCanGenerate(true);
                                        genModel.setUpdateClasspath(false);
                                        if (generateSchema) {
                                            genModel.setGenerateSchema(true);
                                        }
                                        if (nonNLSMarkers) {
                                            genModel.setNonNLSMarkers(true);
                                        }
                                        if (codeFormatting) {
                                            genModel.setCodeFormatting(true);
                                        }
                                        if (profileFile != null) {
                                            Map<String, String> options = CodeFormatterProfileParser.parse(profileFile);
                                            if (options == null) {
                                                throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), 0, "Unable to read profile file: '" + profileFile + "'", null));
                                            }
                                            gen.getOptions().codeFormatterOptions = options;
                                        }
                                        if (model) {
                                            gen.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.ModelProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1));
                                        }
                                        if (edit) {
                                            gen.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1));
                                        }
                                        if (editor) {
                                            gen.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1));
                                        }
                                        if (tests) {
                                            gen.generate(genModel, "org.eclipse.emf.codegen.ecore.genmodel.generator.TestsProject", CodeGenUtil.EclipseUtil.createMonitor((IProgressMonitor)progressMonitor, (int)1));
                                        }
                                    }
                                }
                                catch (CoreException exception) {
                                    throw exception;
                                }
                                catch (Exception exception) {
                                    throw new CoreException((IStatus)new Status(4, CodeGenEcorePlugin.getPlugin().getBundle().getSymbolicName(), 0, "EMF Error", (Throwable)exception));
                                }
                            }
                            finally {
                                progressMonitor.done();
                            }
                        }
                    }
                };
                workspace.run(runnable, (IProgressMonitor)new CodeGenUtil.EclipseUtil.StreamProgressMonitor(System.out));
                return 0;
            }
            catch (Exception exception) {
                generator.printGenerateUsage();
                exception.printStackTrace();
                CodeGenEcorePlugin.INSTANCE.log(exception);
                return 1;
            }
        }
    }
}

