/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.oda.ecore.impl;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.emf.oda.ecore.impl.Connection;
import org.eclipse.emf.oda.ecore.impl.ParameterMetaData;
import org.eclipse.emf.oda.ecore.impl.ResultSet;
import org.eclipse.emf.oda.ecore.impl.ResultSetMetaData;
import org.eclipse.emf.oda.ecore.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query
implements IQuery {
    public static final String DELEGATE_PROPERTY_NAME = "delegate";
    public static final String CONTEXT_PROPERTY_NAME = "context";
    public static final String VARIABLES_PROPERTY_NAME = "variables";
    public static final String TYPE_PROPERTY_NAME = "type";
    protected final Connection connection;
    protected QuerySpecification specification = null;
    protected QueryDelegate.Factory factory = null;
    protected QueryDelegate delegate = null;
    protected EClassifier context = null;
    protected Map<String, EClassifier> variables = null;
    protected EClassifier type = null;
    protected String queryText = null;
    protected int maxRows = 0;

    protected Query(Connection connection) {
        this.connection = connection;
    }

    protected void assertSpecified() throws OdaException {
        if (this.specification == null) {
            throw new OdaException((Throwable)new IllegalStateException());
        }
    }

    protected void assertPrepared() throws OdaException {
        if (this.delegate == null || this.context == null || this.type == null) {
            throw new OdaException((Throwable)new IllegalStateException());
        }
    }

    protected Map<String, EClassifier> getVariables() throws OdaException {
        this.assertSpecified();
        if (this.variables == null) {
            this.variables = new HashMap<String, EClassifier>();
            String string = (String)this.specification.getProperty(VARIABLES_PROPERTY_NAME);
            if (!StringUtil.isEmpty(string)) {
                ResourceSet resourceSet = this.connection.getResourceSet();
                String[] strings = string.split(Pattern.quote(" "));
                int i = 0;
                while (i < strings.length) {
                    this.variables.put(strings[i], (EClassifier)resourceSet.getEObject(URI.createURI((String)strings[i + 1]), true));
                    i += 2;
                }
            }
        }
        return this.variables;
    }

    public void prepare(String queryText) throws OdaException {
        this.assertSpecified();
        if (StringUtil.isEmpty(queryText)) {
            throw new OdaException((Throwable)new IllegalArgumentException(queryText));
        }
        this.queryText = queryText;
        try {
            this.factory = (QueryDelegate.Factory)QueryDelegate.Factory.Registry.INSTANCE.get((Object)((String)this.specification.getProperty(DELEGATE_PROPERTY_NAME)));
            ResourceSet resourceSet = this.connection.getResourceSet();
            this.context = (EClassifier)resourceSet.getEObject(URI.createURI((String)((String)this.specification.getProperty(CONTEXT_PROPERTY_NAME))), true);
            Map<String, EClassifier> variables = this.getVariables();
            this.delegate = this.factory.createQueryDelegate(this.context, variables.isEmpty() ? null : variables, queryText);
            this.type = (EClassifier)resourceSet.getEObject(URI.createURI((String)((String)this.specification.getProperty(TYPE_PROPERTY_NAME))), true);
            this.delegate.prepare();
        }
        catch (Exception e) {
            throw new OdaException((Throwable)e);
        }
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        this.delegate = null;
        this.context = null;
        this.type = null;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        this.assertPrepared();
        return ResultSetMetaData.create(this.type);
    }

    protected EList<Object> getAllObjectsByType(EList<Object> objects, EClassifier type) {
        TreeIterator allContents = EcoreUtil.getAllContents((ResourceSet)this.connection.getResourceSet(), (boolean)true);
        while (allContents.hasNext()) {
            Object next = allContents.next();
            if (!type.isInstance(next)) continue;
            objects.add(next);
        }
        return objects;
    }

    protected EList<Object> getResults(EList<Object> results, QueryDelegate delegate, EList<Object> targets, Map<String, Object> arguments, EClassifier type) throws InvocationTargetException {
        for (Object target : targets) {
            Object result = delegate.execute(target, arguments);
            if (result instanceof Collection) {
                results.addAll(EcoreUtil.getObjectsByType((Collection)((Collection)result), (EClassifier)type));
                continue;
            }
            if (!type.isInstance(result)) continue;
            results.add(result);
        }
        return results;
    }

    public IResultSet executeQuery() throws OdaException {
        this.assertPrepared();
        UniqueEList.FastCompare targets = new UniqueEList.FastCompare();
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        Map parameterValues = this.specification.getParameterValues();
        if (!parameterValues.isEmpty()) {
            EClassifier type;
            Object value;
            String name;
            Object targetArgument = null;
            HashMap<String, EClassifier> dataTypeParameters = new HashMap<String, EClassifier>();
            HashMap<String, Object> dataTypeArguments = new HashMap<String, Object>();
            HashMap classArguments = new HashMap();
            for (Map.Entry entry : parameterValues.entrySet()) {
                name = ((QuerySpecification.ParameterIdentifier)entry.getKey()).getParameterName();
                if (StringUtil.isEmpty(name)) continue;
                value = entry.getValue();
                if (value instanceof ResultSet.JavaObject) {
                    value = ((ResultSet.JavaObject)value).getObject();
                }
                if (value == null) continue;
                if ("@target".equals(name)) {
                    targetArgument = value;
                    continue;
                }
                type = this.variables.get(name);
                if (type instanceof EClass) {
                    classArguments.put(name, value);
                    continue;
                }
                dataTypeParameters.put(name, type);
                dataTypeArguments.put(name, value);
            }
            if (targetArgument == null || "<unset>".equals(targetArgument)) {
                this.getAllObjectsByType((EList<Object>)targets, this.context);
            } else if (targetArgument instanceof String) {
                try {
                    QueryDelegate delegate = this.factory.createQueryDelegate(this.context, dataTypeParameters, (String)targetArgument);
                    this.getResults((EList<Object>)targets, delegate, this.getAllObjectsByType((EList<Object>)new UniqueEList.FastCompare(), this.context), dataTypeArguments, this.context);
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    throw new OdaException("@target: " + (cause == null ? e.getLocalizedMessage() : cause.getLocalizedMessage()));
                }
            } else if (targetArgument instanceof Collection) {
                targets.addAll((Collection)targetArgument);
            } else {
                targets.add(targetArgument);
            }
            arguments.putAll(dataTypeArguments);
            for (Map.Entry entry : classArguments.entrySet()) {
                name = (String)entry.getKey();
                value = entry.getValue();
                if (value instanceof String) {
                    type = this.variables.get(name);
                    EList<Object> values = this.getAllObjectsByType((EList<Object>)new UniqueEList.FastCompare(), type);
                    if (!"<unset>".equals(value)) {
                        try {
                            QueryDelegate delegate = this.factory.createQueryDelegate(type, dataTypeParameters, (String)value);
                            values = this.getResults((EList<Object>)new UniqueEList.FastCompare(), delegate, values, dataTypeArguments, type);
                        }
                        catch (Exception e) {
                            Throwable cause = e.getCause();
                            throw new OdaException(String.valueOf(name) + ": " + (cause == null ? e.getLocalizedMessage() : cause.getLocalizedMessage()));
                        }
                    }
                    value = values.isEmpty() ? null : values.iterator().next();
                }
                arguments.put(name, value);
            }
        }
        try {
            IResultSet resultSet = ResultSet.create(this.type, this.getResults((EList<Object>)new UniqueEList(), this.delegate, (EList<Object>)targets, arguments, this.type));
            resultSet.setMaxRows(this.getMaxRows());
            return resultSet;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            throw new OdaException(cause == null ? e.getLocalizedMessage() : cause.getLocalizedMessage());
        }
    }

    public void setProperty(String name, String value) throws OdaException {
        this.assertSpecified();
        this.specification.setProperty(name, (Object)value);
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    public int getMaxRows() throws OdaException {
        return this.maxRows;
    }

    public void clearInParameters() throws OdaException {
        throw new OdaException((Throwable)new UnsupportedOperationException());
    }

    public void setInt(String parameterName, int value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, (Object)value);
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, (Object)value);
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, (Object)value);
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, (Object)value);
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, (Object)value);
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, (Object)value);
    }

    public void setString(String parameterName, String value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, (Object)value);
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, (Object)value);
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, (Object)value);
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, (Object)value);
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, (Object)value);
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, (Object)value);
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, (Object)value);
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, (Object)value);
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, (Object)value);
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, (Object)value);
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, value);
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, value);
    }

    public void setNull(String parameterName) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterName, null);
    }

    public void setNull(int parameterId) throws OdaException {
        this.assertSpecified();
        this.specification.setParameterValue(parameterId, null);
    }

    public int findInParameter(String parameterName) throws OdaException {
        this.assertSpecified();
        for (Map.Entry entry : this.specification.getParameterValues().entrySet()) {
            QuerySpecification.ParameterIdentifier identifier = (QuerySpecification.ParameterIdentifier)entry.getKey();
            if (!identifier.hasName() || !identifier.getParameterName().equals(parameterName)) continue;
            return identifier.getParameterId();
        }
        throw new OdaException((Throwable)new IllegalArgumentException(parameterName));
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        this.assertSpecified();
        return new ParameterMetaData(this);
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        throw new OdaException((Throwable)new UnsupportedOperationException());
    }

    public SortSpec getSortSpec() throws OdaException {
        return null;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        this.specification = querySpec;
    }

    public QuerySpecification getSpecification() {
        return this.specification;
    }

    public String getEffectiveQueryText() {
        return this.queryText;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }
}

