/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@Singleton
public class UML {
    private final Set<EClass> relationshipLikeUMLMetaclasses = Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new EClass[]{UMLPackage.Literals.RELATIONSHIP, UMLPackage.Literals.GENERALIZATION_SET, UMLPackage.Literals.CONNECTOR, UMLPackage.Literals.ACTIVITY_EDGE, UMLPackage.Literals.TRANSITION, UMLPackage.Literals.MESSAGE}));

    protected Profile _getProfile(Profile element) {
        return element;
    }

    protected Profile _getProfile(NamedElement element) {
        return (Profile)IterableExtensions.head((Iterable)Iterables.filter((Iterable)element.allOwningPackages(), Profile.class));
    }

    protected Profile _getProfile(ImpliedExtension umlExtension) {
        return umlExtension.getStereotype().getProfile();
    }

    protected Profile _getRootProfile(Profile element) {
        Profile _elvis = null;
        Namespace _namespace = element.getNamespace();
        Profile _rootProfile = null;
        if (_namespace != null) {
            _rootProfile = this.getRootProfile((NamedElement)_namespace);
        }
        _elvis = _rootProfile != null ? _rootProfile : element;
        return _elvis;
    }

    protected Profile _getRootProfile(NamedElement element) {
        return (Profile)IterableExtensions.last((Iterable)Iterables.filter((Iterable)element.allOwningPackages(), Profile.class));
    }

    public Iterable<ImpliedExtension> getAllExtensions(Package package_) {
        Functions.Function1 _function = it -> this.impliedExtensions((Stereotype)it);
        Iterable _flatten = Iterables.concat((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)package_.getOwnedTypes(), Stereotype.class), (Functions.Function1)_function));
        Functions.Function1 _function_1 = it -> this.getAllExtensions((Package)it);
        Iterable _flatten_1 = Iterables.concat((Iterable)ListExtensions.map((List)package_.getNestedPackages(), (Functions.Function1)_function_1));
        return Iterables.concat((Iterable)_flatten, (Iterable)_flatten_1);
    }

    public Iterable<Stereotype> getAllStereotypes(Package package_) {
        Iterable _filter = Iterables.filter((Iterable)package_.getOwnedTypes(), Stereotype.class);
        Functions.Function1 _function = it -> this.getAllStereotypes((Package)it);
        Iterable _flatten = Iterables.concat((Iterable)ListExtensions.map((List)package_.getNestedPackages(), (Functions.Function1)_function));
        return Iterables.concat((Iterable)_filter, (Iterable)_flatten);
    }

    public Iterable<ImpliedExtension> impliedExtensions(Stereotype stereotype) {
        Functions.Function1 _function = it -> new ImpliedExtension(stereotype, (Class)it);
        return ListExtensions.map((List)stereotype.getAllExtendedMetaclasses(), (Functions.Function1)_function);
    }

    public boolean isRelationship(EClass eClass) {
        Functions.Function1 _function = it -> it.isSuperTypeOf(eClass);
        return IterableExtensions.exists(this.relationshipLikeUMLMetaclasses, (Functions.Function1)_function);
    }

    public Iterable<EReference> getSourceReferences(EClass relationshipClass) {
        boolean _isSuperTypeOf_6;
        boolean _isSuperTypeOf_5;
        boolean _isSuperTypeOf_4;
        boolean _isSuperTypeOf_3;
        boolean _isSuperTypeOf_2;
        boolean _isSuperTypeOf_1;
        List _switchResult = null;
        boolean _matched = false;
        boolean _isSuperTypeOf = UMLPackage.Literals.DIRECTED_RELATIONSHIP.isSuperTypeOf(relationshipClass);
        if (_isSuperTypeOf) {
            _matched = true;
            Functions.Function1 _function = it -> !it.isDerived() && it.isChangeable() && this.subsets((EReference)it, UMLPackage.Literals.DIRECTED_RELATIONSHIP__SOURCE);
            _switchResult = IterableExtensions.filter((Iterable)relationshipClass.getEAllReferences(), (Functions.Function1)_function);
        }
        if (!_matched && (_isSuperTypeOf_1 = UMLPackage.Literals.ASSOCIATION.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.ASSOCIATION__END_TYPE}));
        }
        if (!_matched && (_isSuperTypeOf_2 = UMLPackage.Literals.CONNECTOR.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.CONNECTOR__END}));
        }
        if (!_matched && (_isSuperTypeOf_3 = UMLPackage.Literals.ACTIVITY_EDGE.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.ACTIVITY_EDGE__SOURCE}));
        }
        if (!_matched && (_isSuperTypeOf_4 = UMLPackage.Literals.TRANSITION.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.TRANSITION__SOURCE}));
        }
        if (!_matched && (_isSuperTypeOf_5 = UMLPackage.Literals.MESSAGE.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.MESSAGE__SEND_EVENT}));
        }
        if (!_matched && (_isSuperTypeOf_6 = UMLPackage.Literals.GENERALIZATION_SET.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.GENERALIZATION_SET__GENERALIZATION}));
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _switchResult;
    }

    public Iterable<EReference> getTargetReferences(EClass relationshipClass) {
        boolean _isSuperTypeOf_6;
        boolean _isSuperTypeOf_5;
        boolean _isSuperTypeOf_4;
        boolean _isSuperTypeOf_3;
        boolean _isSuperTypeOf_2;
        boolean _isSuperTypeOf_1;
        List _switchResult = null;
        boolean _matched = false;
        boolean _isSuperTypeOf = UMLPackage.Literals.DIRECTED_RELATIONSHIP.isSuperTypeOf(relationshipClass);
        if (_isSuperTypeOf) {
            _matched = true;
            Functions.Function1 _function = it -> !it.isDerived() && it.isChangeable() && this.subsets((EReference)it, UMLPackage.Literals.DIRECTED_RELATIONSHIP__TARGET);
            _switchResult = IterableExtensions.filter((Iterable)relationshipClass.getEAllReferences(), (Functions.Function1)_function);
        }
        if (!_matched && (_isSuperTypeOf_1 = UMLPackage.Literals.ASSOCIATION.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.ASSOCIATION__END_TYPE}));
        }
        if (!_matched && (_isSuperTypeOf_2 = UMLPackage.Literals.CONNECTOR.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.CONNECTOR__END}));
        }
        if (!_matched && (_isSuperTypeOf_3 = UMLPackage.Literals.ACTIVITY_EDGE.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.ACTIVITY_EDGE__TARGET}));
        }
        if (!_matched && (_isSuperTypeOf_4 = UMLPackage.Literals.TRANSITION.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.TRANSITION__TARGET}));
        }
        if (!_matched && (_isSuperTypeOf_5 = UMLPackage.Literals.MESSAGE.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.MESSAGE__RECEIVE_EVENT}));
        }
        if (!_matched && (_isSuperTypeOf_6 = UMLPackage.Literals.GENERALIZATION_SET.isSuperTypeOf(relationshipClass))) {
            _matched = true;
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EReference[]{UMLPackage.Literals.GENERALIZATION_SET__GENERALIZATION}));
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _switchResult;
    }

    public boolean subsets(EReference subset, EReference superset) {
        EAnnotation _eAnnotation = subset.getEAnnotation("subsets");
        EList _references = null;
        if (_eAnnotation != null) {
            _references = _eAnnotation.getReferences();
        }
        boolean _contains = false;
        if (_references != null) {
            _contains = _references.contains((Object)superset);
        }
        return _contains;
    }

    @XbaseGenerated
    public Profile getProfile(Object element) {
        if (element instanceof Profile) {
            return this._getProfile((Profile)element);
        }
        if (element instanceof NamedElement) {
            return this._getProfile((NamedElement)element);
        }
        if (element instanceof ImpliedExtension) {
            return this._getProfile((ImpliedExtension)element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    @XbaseGenerated
    public Profile getRootProfile(NamedElement element) {
        if (element instanceof Profile) {
            return this._getRootProfile((Profile)element);
        }
        if (element != null) {
            return this._getRootProfile(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

