/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.sirius.uml.diagram.common.Activator;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.AddElementToDiagramServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.LabelServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.SemanticElementsSwitch;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.TooltipServices;
import org.eclipse.papyrus.sirius.uml.diagram.common.services.DomainBasedEdgeServices;
import org.eclipse.papyrus.uml.domain.services.create.ElementCreationChecker;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.business.api.helper.graphicalfilters.HideFilterHelper;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.DDiagramQuery;
import org.eclipse.sirius.diagram.business.internal.helper.task.operations.CreateViewTask;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.tool.CreateEdgeView;
import org.eclipse.sirius.diagram.description.tool.CreateView;
import org.eclipse.sirius.diagram.description.tool.ToolFactory;
import org.eclipse.sirius.diagram.model.business.internal.helper.ContentHelper;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.tools.api.command.CommandContext;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.uml2.uml.Element;

public abstract class AbstractDiagramServices {
    protected static final String CONTAINER_VIEW = "containerView";
    private static final String SOURCE = "source";
    private static final String TARGET = "target";

    public String computeDefaultName(EObject element) {
        return LabelServices.INSTANCE.computeDefaultName(element);
    }

    public String computeTooltip(EObject element) {
        return TooltipServices.INSTANCE.computeTooltip(element);
    }

    public String computeUmlLabel(Element element) {
        return LabelServices.INSTANCE.computeUmlLabel(element);
    }

    public void createView(EObject semanticElement, DSemanticDecorator containerView, String containerViewExpression) {
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        this.createView(semanticElement, containerView, session, containerViewExpression);
    }

    protected void createView(EObject semanticElement, DSemanticDecorator containerView, Session session, String containerViewExpression) {
        List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElement, containerView, session);
        for (DiagramElementMapping semanticElementMapping : semanticElementMappings) {
            CreateView createViewOp = ToolFactory.eINSTANCE.createCreateView();
            DiagramElementMapping tmpSemanticElementMapping = semanticElementMapping;
            createViewOp.setMapping(tmpSemanticElementMapping);
            createViewOp.setContainerViewExpression(containerViewExpression);
            this.executeCreateViewOperation(semanticElement, session, containerView, createViewOp);
        }
    }

    protected boolean isCompartment(DSemanticDecorator view) {
        return Optional.ofNullable(view).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).map(DDiagramElement::getDiagramElementMapping).filter(ContainerMapping.class::isInstance).map(ContainerMapping.class::cast).map(ContainerMappingQuery::new).filter(ContainerMappingQuery::isRegion).isPresent();
    }

    protected boolean isBorderNode(EObject semanticElement, DSemanticDecorator targetView) {
        DiagramElementMapping diagramElementMapping;
        EObject eContainer;
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElement, targetView, session);
        if (!semanticElementMappings.isEmpty() && (eContainer = (diagramElementMapping = semanticElementMappings.get(0)).eContainer()) instanceof AbstractNodeMapping) {
            return ((AbstractNodeMapping)eContainer).getBorderedNodeMappings().contains((Object)semanticElementMappings.get(0));
        }
        return false;
    }

    protected void createDnDEdgeView(EObject semanticElement, DDiagram dDiagram, Session session, boolean isDiagramWithRoot) {
        List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElement, (DSemanticDecorator)dDiagram, session);
        this.createSourceAndTargetView(semanticElement, (DSemanticDiagram)dDiagram, session, isDiagramWithRoot);
        for (DiagramElementMapping semanticElementMapping : semanticElementMappings) {
            if (!(semanticElementMapping instanceof EdgeMapping)) continue;
            this.createEdgeViewFromMapping(semanticElement, session, dDiagram, semanticElementMapping, "var:newContainerView", "aql:self.getSource()", "aql:self.getTargets()->first()");
        }
    }

    protected void createSourceAndTargetView(EObject semanticElement, DSemanticDiagram dSemanticDiagram, Session session, boolean isDiagramWithRoot) {
        DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
        Optional<EObject> optionalSemanticSource = Optional.ofNullable(domainBasedEdgeServices.getSource(semanticElement));
        Optional optionalSemanticTarget = domainBasedEdgeServices.getTargets(semanticElement).stream().findFirst();
        if (optionalSemanticSource.isPresent() && optionalSemanticTarget.isPresent()) {
            IInterpreter interpreter;
            Optional<DSemanticDecorator> optionalTargetView;
            EObject semanticSource = optionalSemanticSource.get();
            EObject semanticTarget = (EObject)optionalSemanticTarget.get();
            Collection allDiagramElements = new DDiagramQuery((DDiagram)dSemanticDiagram).getAllDiagramElements();
            boolean sourceViewExist = false;
            boolean targetViewExist = false;
            Iterator iterator = allDiagramElements.iterator();
            while (!(sourceViewExist && targetViewExist || !iterator.hasNext())) {
                DDiagramElement diagramElement = (DDiagramElement)iterator.next();
                if (semanticSource.equals(diagramElement.getTarget())) {
                    sourceViewExist = true;
                }
                if (!semanticTarget.equals(diagramElement.getTarget())) continue;
                targetViewExist = true;
            }
            if (!sourceViewExist && (optionalTargetView = this.getContainerTargetView(semanticSource, dSemanticDiagram, allDiagramElements, isDiagramWithRoot)).isPresent()) {
                interpreter = session.getInterpreter();
                interpreter.setVariable(CONTAINER_VIEW, (Object)optionalTargetView.get());
                this.createView(semanticSource, optionalTargetView.get(), session, "aql:containerView");
                interpreter.unSetVariable(CONTAINER_VIEW);
            }
            if (!targetViewExist && (optionalTargetView = this.getContainerTargetView(semanticTarget, dSemanticDiagram, allDiagramElements, isDiagramWithRoot)).isPresent()) {
                interpreter = session.getInterpreter();
                interpreter.setVariable(CONTAINER_VIEW, (Object)optionalTargetView.get());
                this.createView(semanticTarget, optionalTargetView.get(), session, "aql:containerView");
                interpreter.unSetVariable(CONTAINER_VIEW);
            }
        }
    }

    protected Optional<DSemanticDecorator> getContainerTargetView(EObject semanticElement, DSemanticDiagram dSemanticDiagram, Collection<DDiagramElement> allDiagramElements, boolean isDiagramWithRoot) {
        Optional<DSemanticDecorator> optionalContainer = Optional.empty();
        EObject semanticContainer = semanticElement.eContainer();
        if (semanticContainer != null) {
            if (semanticContainer.equals(dSemanticDiagram.getTarget()) && !isDiagramWithRoot) {
                optionalContainer = Optional.of(dSemanticDiagram);
            } else {
                List allDNodeElements = allDiagramElements.stream().filter(AbstractDNode.class::isInstance).collect(Collectors.toList());
                for (DDiagramElement diagramElement : allDNodeElements) {
                    DiagramElementMapping diagramElementMapping = diagramElement.getDiagramElementMapping();
                    boolean isRegionContainer = this.isRegionContainer(diagramElementMapping);
                    if (!semanticContainer.equals(diagramElement.getTarget()) || isRegionContainer) continue;
                    DDiagramElement targetView = diagramElement;
                    if (this.isCompartment((DSemanticDecorator)targetView) && this.isBorderNode(semanticContainer, (DSemanticDecorator)targetView.eContainer())) {
                        targetView = (DSemanticDecorator)targetView.eContainer();
                    }
                    optionalContainer = Optional.of(targetView);
                    break;
                }
            }
        }
        return optionalContainer;
    }

    private boolean isRegionContainer(DiagramElementMapping diagramElementMapping) {
        if (diagramElementMapping instanceof ContainerMapping) {
            ContainerMappingQuery containerMappingQuery = new ContainerMappingQuery((ContainerMapping)diagramElementMapping);
            return containerMappingQuery.isRegionContainer();
        }
        return false;
    }

    protected void createEdgeView(EObject semanticElement, DDiagramElement sourceView, Session session) {
        Optional<DSemanticDiagram> optionalContainerView = Optional.ofNullable(sourceView.getParentDiagram()).filter(DSemanticDiagram.class::isInstance).map(DSemanticDiagram.class::cast);
        if (optionalContainerView.isPresent()) {
            List<DiagramElementMapping> semanticElementMappings = this.getMappings(semanticElement, (DSemanticDecorator)optionalContainerView.get(), session);
            DomainBasedEdgeServices domainBasedEdgeServices = new DomainBasedEdgeServices();
            Optional<EObject> optionalSource = Optional.ofNullable(domainBasedEdgeServices.getSource(semanticElement));
            Optional optionalTarget = domainBasedEdgeServices.getTargets(semanticElement).stream().findFirst();
            IInterpreter interpreter = session.getInterpreter();
            if (interpreter != null) {
                if (optionalSource.isPresent()) {
                    interpreter.setVariable(SOURCE, (Object)optionalSource.get());
                }
                if (optionalTarget.isPresent()) {
                    interpreter.setVariable(TARGET, optionalTarget.get());
                }
                try {
                    for (DiagramElementMapping semanticElementMapping : semanticElementMappings) {
                        if (!(semanticElementMapping instanceof EdgeMapping)) continue;
                        this.createEdgeViewFromMapping(semanticElement, session, (DDiagram)optionalContainerView.get(), semanticElementMapping, null, null, null);
                    }
                }
                finally {
                    if (optionalSource.isPresent()) {
                        interpreter.unSetVariable(SOURCE);
                    }
                    if (optionalTarget.isPresent()) {
                        interpreter.unSetVariable(TARGET);
                    }
                }
            }
        }
    }

    protected void createRelationBasedEdgeViewFromCreationTool(EObject semanticElement, DSemanticDecorator sourceView, Session session, String mappingName) {
        this.createRelationBasedEdgeView(semanticElement, sourceView, session, mappingName, null, null);
    }

    protected void createReconnectTargetRelationBasedEdgeView(EObject semanticElement, DSemanticDecorator sourceView, Session session, String mappingName) {
        this.createRelationBasedEdgeView(semanticElement, sourceView, session, mappingName, "aql:element", "aql:target");
    }

    private void createRelationBasedEdgeView(EObject semanticElement, DSemanticDecorator sourceView, Session session, String mappingName, String sourceExpression, String targetExpression) {
        Optional<EdgeMapping> optionalEdgeMapping;
        Optional<DDiagram> optionalDDiagram = Optional.of(sourceView).filter(DDiagramElement.class::isInstance).map(DDiagramElement.class::cast).map(DDiagramElement::getParentDiagram);
        if (optionalDDiagram.isPresent() && (optionalEdgeMapping = ContentHelper.getAllEdgeMappings((DiagramDescription)optionalDDiagram.get().getDescription(), (boolean)false).stream().filter(mapping -> mappingName.equals(mapping.getName())).findFirst()).isPresent()) {
            this.createEdgeViewFromMapping(semanticElement, session, optionalDDiagram.get(), (DiagramElementMapping)optionalEdgeMapping.get(), null, sourceExpression, targetExpression);
        }
    }

    private void createEdgeViewFromMapping(EObject semanticElement, Session session, DDiagram dDiagram, DiagramElementMapping semanticElementMapping, String containerViewExpression, String sourceExpression, String targetExpression) {
        CreateEdgeView createEdgeViewOp = ToolFactory.eINSTANCE.createCreateEdgeView();
        DiagramElementMapping tmpSemanticElementMapping = semanticElementMapping;
        createEdgeViewOp.setMapping(tmpSemanticElementMapping);
        String safeContainerViewExpression = Optional.ofNullable(containerViewExpression).orElse("aql:sourceView.eContainer(diagram::DDiagram)");
        createEdgeViewOp.setContainerViewExpression(safeContainerViewExpression);
        String safeSourceExpression = Optional.ofNullable(sourceExpression).orElse("var:source");
        createEdgeViewOp.setSourceExpression(safeSourceExpression);
        String safeTargetExpression = Optional.ofNullable(targetExpression).orElse("var:target");
        createEdgeViewOp.setTargetExpression(safeTargetExpression);
        this.executeCreateViewOperation(semanticElement, session, (DSemanticDecorator)dDiagram, (CreateView)createEdgeViewOp);
    }

    protected void executeCreateViewOperation(EObject semanticElement, Session session, DSemanticDecorator containerView, CreateView createViewOp) {
        try {
            DRepresentation representation = null;
            if (containerView instanceof DRepresentation) {
                representation = (DRepresentation)containerView;
            } else if (containerView instanceof DDiagramElement) {
                representation = ((DDiagramElement)containerView).getParentDiagram();
            }
            CommandContext context = new CommandContext(semanticElement, representation);
            CreateViewTask task = new CreateViewTask(context, session.getModelAccessor(), createViewOp, session.getInterpreter());
            task.execute();
            Object createdView = session.getInterpreter().getVariable(createViewOp.getVariableName());
            if (createdView instanceof DDiagramElement) {
                DDiagramElement element = (DDiagramElement)createdView;
                HideFilterHelper.INSTANCE.reveal(element);
            }
        }
        catch (MetaClassNotFoundException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
        catch (FeatureNotFoundException e) {
            Activator.log.error("Unexpected Error", (Throwable)e);
        }
    }

    public int defaultHeight(EObject any) {
        return 10;
    }

    public int defaultWidth(EObject any) {
        return 10;
    }

    protected List<DiagramElementMapping> getMappings(EObject semanticElement, DSemanticDecorator containerView, Session session) {
        ModelAccessor modelAccessor = session.getModelAccessor();
        ArrayList<DiagramElementMapping> mappings = new ArrayList<DiagramElementMapping>();
        if (containerView instanceof DSemanticDiagram) {
            mappings.addAll(AddElementToDiagramServices.INSTANCE.getValidMappingsForDiagram(semanticElement, (DSemanticDiagram)containerView, session));
        } else {
            ContainerMapping abstractNodeMapping = null;
            if (containerView instanceof DDiagramElementContainer) {
                abstractNodeMapping = ((DDiagramElementContainer)containerView).getActualMapping();
            } else if (containerView instanceof DNode) {
                abstractNodeMapping = ((DNode)containerView).getActualMapping();
            }
            if (abstractNodeMapping != null) {
                for (DiagramElementMapping mapping : this.getAllMappings((AbstractNodeMapping)abstractNodeMapping)) {
                    String domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
                    if (!modelAccessor.eInstanceOf(semanticElement, domainClass)) continue;
                    mappings.add(mapping);
                }
            }
        }
        return mappings;
    }

    private List<DiagramElementMapping> getAllMappings(AbstractNodeMapping abstractNodeMapping) {
        ArrayList<DiagramElementMapping> allMappings = new ArrayList<DiagramElementMapping>();
        allMappings.addAll((Collection<DiagramElementMapping>)abstractNodeMapping.getReusedBorderedNodeMappings());
        allMappings.addAll((Collection<DiagramElementMapping>)abstractNodeMapping.getBorderedNodeMappings());
        if (abstractNodeMapping instanceof ContainerMapping) {
            ContainerMapping containerMapping = (ContainerMapping)abstractNodeMapping;
            allMappings.addAll((Collection<DiagramElementMapping>)containerMapping.getSubContainerMappings());
            allMappings.addAll((Collection<DiagramElementMapping>)containerMapping.getSubNodeMappings());
            allMappings.addAll((Collection<DiagramElementMapping>)containerMapping.getReusedContainerMappings());
            allMappings.addAll((Collection<DiagramElementMapping>)containerMapping.getReusedNodeMappings());
        }
        return allMappings;
    }

    public Collection<EObject> getSemanticElements(EObject e) {
        return new SemanticElementsSwitch().getSemanticElements(e);
    }

    protected ECrossReferenceAdapter getECrossReferenceAdapter(EObject source) {
        return source.eResource().getResourceSet().eAdapters().stream().filter(a -> a instanceof ECrossReferenceAdapter).map(a -> (ECrossReferenceAdapter)a).findFirst().orElse(null);
    }

    public boolean canCreate(EObject container, EClass objectToCreate, EStructuralFeature containmentReference) {
        boolean canCreate = false;
        if (containmentReference != null) {
            canCreate = this.canCreate(container, objectToCreate, containmentReference.getName());
        }
        return canCreate;
    }

    public boolean canCreate(EObject container, EClass objectToCreate, String containmentReferenceName) {
        return new ElementCreationChecker().canCreate(container, objectToCreate.getName(), containmentReferenceName).isValid();
    }
}

