/*
 * generated by Xtext
 */
package org.eclipse.papyrus.uml.textedit.state.xtext.serializer;

import java.util.Set;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.uml.textedit.state.xtext.services.UmlStateGrammarAccess;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.DoRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.EntryRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.ExitRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.QualifiedName;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.StateRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.SubmachineRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.UmlStatePackage;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

import com.google.inject.Inject;

@SuppressWarnings("all")
public class UmlStateSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private UmlStateGrammarAccess grammarAccess;

	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == UmlStatePackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case UmlStatePackage.DO_RULE:
				sequence_DoRule(context, (DoRule) semanticObject);
				return;
			case UmlStatePackage.ENTRY_RULE:
				sequence_EntryRule(context, (EntryRule) semanticObject);
				return;
			case UmlStatePackage.EXIT_RULE:
				sequence_ExitRule(context, (ExitRule) semanticObject);
				return;
			case UmlStatePackage.QUALIFIED_NAME:
				sequence_QualifiedName(context, (QualifiedName) semanticObject);
				return;
			case UmlStatePackage.STATE_RULE:
				sequence_StateRule(context, (StateRule) semanticObject);
				return;
			case UmlStatePackage.SUBMACHINE_RULE:
				sequence_SubmachineRule(context, (SubmachineRule) semanticObject);
				return;
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}

	/**
	 * Contexts:
	 * DoRule returns DoRule
	 *
	 * Constraint:
	 * (kind=BehaviorKind behaviorName=ID)
	 */
	protected void sequence_DoRule(ISerializationContext context, DoRule semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlStatePackage.Literals.DO_RULE__KIND) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlStatePackage.Literals.DO_RULE__KIND));
			if (transientValues.isValueTransient(semanticObject, UmlStatePackage.Literals.DO_RULE__BEHAVIOR_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlStatePackage.Literals.DO_RULE__BEHAVIOR_NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getDoRuleAccess().getKindBehaviorKindEnumRuleCall_1_0(), semanticObject.getKind());
		feeder.accept(grammarAccess.getDoRuleAccess().getBehaviorNameIDTerminalRuleCall_2_0(), semanticObject.getBehaviorName());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * EntryRule returns EntryRule
	 *
	 * Constraint:
	 * (kind=BehaviorKind behaviorName=ID)
	 */
	protected void sequence_EntryRule(ISerializationContext context, EntryRule semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlStatePackage.Literals.ENTRY_RULE__KIND) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlStatePackage.Literals.ENTRY_RULE__KIND));
			if (transientValues.isValueTransient(semanticObject, UmlStatePackage.Literals.ENTRY_RULE__BEHAVIOR_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlStatePackage.Literals.ENTRY_RULE__BEHAVIOR_NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getEntryRuleAccess().getKindBehaviorKindEnumRuleCall_1_0(), semanticObject.getKind());
		feeder.accept(grammarAccess.getEntryRuleAccess().getBehaviorNameIDTerminalRuleCall_2_0(), semanticObject.getBehaviorName());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * ExitRule returns ExitRule
	 *
	 * Constraint:
	 * (kind=BehaviorKind behaviorName=ID)
	 */
	protected void sequence_ExitRule(ISerializationContext context, ExitRule semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, UmlStatePackage.Literals.EXIT_RULE__KIND) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlStatePackage.Literals.EXIT_RULE__KIND));
			if (transientValues.isValueTransient(semanticObject, UmlStatePackage.Literals.EXIT_RULE__BEHAVIOR_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, UmlStatePackage.Literals.EXIT_RULE__BEHAVIOR_NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getExitRuleAccess().getKindBehaviorKindEnumRuleCall_1_0(), semanticObject.getKind());
		feeder.accept(grammarAccess.getExitRuleAccess().getBehaviorNameIDTerminalRuleCall_2_0(), semanticObject.getBehaviorName());
		feeder.finish();
	}


	/**
	 * Contexts:
	 * QualifiedName returns QualifiedName
	 *
	 * Constraint:
	 * (path=[Namespace|ID] remaining=QualifiedName?)
	 */
	protected void sequence_QualifiedName(ISerializationContext context, QualifiedName semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Contexts:
	 * StateRule returns StateRule
	 *
	 * Constraint:
	 * (name=ID submachine=SubmachineRule? (entry=EntryRule | do=DoRule | exit=ExitRule)*)
	 */
	protected void sequence_StateRule(ISerializationContext context, StateRule semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


	/**
	 * Contexts:
	 * SubmachineRule returns SubmachineRule
	 *
	 * Constraint:
	 * (path=QualifiedName? submachine=[StateMachine|ID])
	 */
	protected void sequence_SubmachineRule(ISerializationContext context, SubmachineRule semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}


}
