/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.papyrus.infra.nattable.utils.IPapyrusNattableStatus;

public class PapyrusNattableMultiStatus
extends MultiStatus
implements IPapyrusNattableStatus {
    private int severity;

    public PapyrusNattableMultiStatus(String pluginId, int code, IStatus[] newChildren, String message, Throwable exception) {
        super(pluginId, code, newChildren, message, exception);
        int maxSeverity = this.getSeverity();
        int i = 0;
        while (i < newChildren.length) {
            Assert.isLegal((newChildren[i] != null ? 1 : 0) != 0);
            int severity = newChildren[i].getSeverity();
            if (severity > maxSeverity) {
                maxSeverity = severity;
            }
            ++i;
        }
        this.setSeverity(maxSeverity);
    }

    public PapyrusNattableMultiStatus(String pluginId, int code, String message, Throwable exception) {
        super(pluginId, code, message, exception);
    }

    public int getSeverity() {
        return this.severity;
    }

    public boolean isOK() {
        return this.severity == 0;
    }

    public boolean matches(int severityMask) {
        return (this.severity & severityMask) != 0;
    }

    protected void setSeverity(int severity) {
        Assert.isLegal((severity == 0 || severity == 4 || severity == 2 || severity == 1 || severity == 8 || severity == 22 || severity == 50 || severity == 100 ? 1 : 0) != 0);
        this.severity = severity;
    }
}

