/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import java.util.Collection;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;

public class EditorNameInitializer {
    private EditorNameInitializer() {
    }

    public static final String getNameWithIncrement(EClass editorModelEClass, EStructuralFeature nameFeature, String wantedNameWithoutIndex, EObject context) {
        TreeSet<Integer> existingIndex = new TreeSet<Integer>();
        ECrossReferenceAdapter crossRef = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)context);
        Collection crossReference = crossRef.getNonNavigableInverseReferences(context, true);
        for (EStructuralFeature.Setting set : crossReference) {
            String aName;
            Object currentName;
            EObject eobject = set.getEObject();
            if (eobject.eClass() != editorModelEClass || nameFeature == null || !((currentName = eobject.eGet(nameFeature)) instanceof String) || !(aName = (String)currentName).contains(wantedNameWithoutIndex)) continue;
            String lastChars = aName.substring(wantedNameWithoutIndex.length(), aName.length());
            try {
                Integer value = Integer.parseInt(lastChars);
                existingIndex.add(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int index = 0;
        if (!existingIndex.isEmpty()) {
            index = (Integer)existingIndex.last() + 1;
        }
        return wantedNameWithoutIndex + String.valueOf(index);
    }
}

