/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.internal.clipboard;

import java.util.function.BiPredicate;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.papyrus.infra.core.clipboard.ICopierFactory;

class DefaultConfiguration
implements ICopierFactory.Configuration {
    private final boolean resolveReferences;
    private final boolean useOriginalReferences;
    private BiPredicate<EReference, EObject> referenceFilter;

    DefaultConfiguration(boolean resolveReferences, boolean useOriginalReferences) {
        this.resolveReferences = resolveReferences;
        this.useOriginalReferences = useOriginalReferences;
    }

    @Override
    public boolean isResolveReferences() {
        return this.resolveReferences;
    }

    @Override
    public boolean isUseOriginalReferences() {
        return this.useOriginalReferences;
    }

    boolean isEmpty() {
        return this.referenceFilter == null;
    }

    @Override
    public void filterReferences(BiPredicate<? super EReference, ? super EObject> filter) {
        if (this.referenceFilter == null) {
            BiPredicate<? super EReference, ? super EObject> filter_ = filter;
            this.referenceFilter = filter_;
        } else {
            this.referenceFilter = this.referenceFilter.or(filter);
        }
    }

    boolean shouldCopyReference(EReference reference, EObject owner) {
        return this.referenceFilter == null || !this.referenceFilter.test(reference, owner);
    }
}

