/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.types.constraints.operations;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.emf.types.advices.constraints.PermissionResult;
import org.eclipse.papyrus.infra.emf.types.constraints.AdviceConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.CompositeConstraint;
import org.eclipse.papyrus.infra.emf.types.constraints.ConstraintAdviceConfiguration;
import org.eclipse.papyrus.infra.emf.types.constraints.operations.ElementTypeFilterOperations;
import org.eclipse.papyrus.infra.filters.Filter;

public class AdviceConstraintOperations {
    protected AdviceConstraintOperations() {
    }

    public static boolean approveRequest(AdviceConstraint adviceConstraint, IEditCommandRequest request) {
        throw new UnsupportedOperationException("abstract operation");
    }

    public static ConstraintAdviceConfiguration getAdvice(AdviceConstraint adviceConstraint) {
        ConstraintAdviceConfiguration result = adviceConstraint.getOwningAdvice();
        if (result == null) {
            CompositeConstraint next = adviceConstraint.getComposite();
            while (next != null && result == null) {
                result = next.getOwningAdvice();
                next = adviceConstraint.getComposite();
            }
        }
        return result;
    }

    protected static <P> boolean approveRequest(IEditCommandRequest request, Iterable<P> permissions, Function<? super P, PermissionResult> evaluator) {
        if (evaluator == null) {
            return true;
        }
        return !ElementTypeFilterOperations.inClientContext(request.getClientContext(), () -> {
            PermissionResult result = PermissionResult.NONE;
            Iterator iter = permissions.iterator();
            while (iter.hasNext() && !result.isDetermined()) {
                result = (PermissionResult)((Object)((Object)evaluator.apply((Object)iter.next())));
            }
            return result;
        }).isDenied();
    }

    protected static Iterator<?> iterate(Object object) {
        return object instanceof Iterable ? ((Iterable)object).iterator() : (object instanceof Object[] ? Arrays.asList((Object[])object).iterator() : (object == null ? Collections.emptyIterator() : List.of(object).iterator()));
    }

    protected static boolean evaluate(Filter filter, Object input) {
        return filter == null || filter.matches(input);
    }
}

