/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.providers.IHierarchicContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.IInheritedElementContentProvider;
import org.eclipse.papyrus.uml.tools.providers.IOperationContentProvider;
import org.eclipse.papyrus.uml.tools.util.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class UMLStereotypeOperationContentProvider
implements IHierarchicContentProvider,
IInheritedElementContentProvider,
IOperationContentProvider {
    protected List<Profile> profiles;
    private boolean ignoreInheritedOperation;
    private boolean ignoreVoidOperations;
    private boolean ignoreOperationsWithParameters;

    public UMLStereotypeOperationContentProvider(List<Profile> profiles) {
        this.profiles = profiles;
        this.ignoreInheritedOperation = false;
        this.ignoreOperationsWithParameters = false;
        this.ignoreVoidOperations = false;
    }

    public UMLStereotypeOperationContentProvider() {
        this(null);
    }

    public Object[] getElements() {
        return this.profiles.toArray();
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> children = new ArrayList<Object>();
        if (this.hasChildren(parentElement)) {
            if (parentElement instanceof Package) {
                for (EObject current : ((Package)parentElement).getOwnedMembers()) {
                    if (!this.hasChildren(current)) continue;
                    children.add(current);
                }
            } else if (parentElement instanceof Stereotype) {
                children.addAll(StereotypeUtil.getAllStereotypeOperations((Stereotype)parentElement, this.ignoreVoidOperations, this.ignoreOperationsWithParameters, this.ignoreInheritedOperation));
            }
        }
        return children.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Element) {
            TreeIterator iter = ((EObject)element).eAllContents();
            while (iter.hasNext()) {
                if (!this.isValidValue(iter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public void dispose() {
        this.profiles.clear();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public boolean isValidValue(Object element) {
        if (element instanceof Element) {
            return element instanceof Operation && ((Element)element).eContainer() instanceof Stereotype;
        }
        return false;
    }

    public void setProfiles(List<Profile> profiles) {
        this.profiles = profiles;
    }

    public void setIgnoreInheritedElements(boolean ignoreInheritedElements) {
        this.ignoreInheritedOperation = ignoreInheritedElements;
    }

    public boolean isIgnoringInheritedElements() {
        return this.ignoreInheritedOperation;
    }

    @Override
    public void setIgnoredOperationsWithParameters(boolean ignoreOperationsWithParameters) {
        this.ignoreOperationsWithParameters = ignoreOperationsWithParameters;
    }

    @Override
    public void setIgnoreVoidOperations(boolean ignoreVoidOperation) {
        this.ignoreVoidOperations = ignoreVoidOperation;
    }

    @Override
    public boolean isIgnoringOperationsWithParameters() {
        return this.ignoreOperationsWithParameters;
    }

    @Override
    public boolean isIgnoringVoidOperations() {
        return this.ignoreVoidOperations;
    }
}

