/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import com.google.common.base.Strings;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.ILabelConstants;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.LabelServices;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLQualifiedNameUtils;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehaviorExecutionSpecification;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ComponentRealization;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataStoreNode;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Deployment;
import org.eclipse.uml2.uml.Duration;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.Feature;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Interval;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.LiteralBoolean;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.LiteralNull;
import org.eclipse.uml2.uml.LiteralReal;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.LiteralUnlimitedNatural;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.PackageMerge;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.ParameterableElement;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ProtocolStateMachine;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.Substitution;
import org.eclipse.uml2.uml.TemplateBinding;
import org.eclipse.uml2.uml.TemplateParameterSubstitution;
import org.eclipse.uml2.uml.TemplateableElement;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.Usage;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.edit.UMLEditPlugin;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class DisplayLabelSwitch
extends UMLSwitch<String>
implements ILabelConstants {
    private static final String SPACED_COLUMN = " : ";
    private static final String SPACED_COMMA = ", ";
    private static final String CLOSING_BRACE = "]";
    private static final String OPENING_BRACE = "[";
    public static final String END_OF_LINE = System.lineSeparator();
    public static final String SPACE = " ";
    private static boolean showStereotypeFilter = true;
    private static boolean showQualifiedNameFilter = true;

    public static String computeStereotypes(Element element) {
        if (showStereotypeFilter) {
            Iterator it = element.getAppliedStereotypes().iterator();
            if (!it.hasNext()) {
                return "";
            }
            StringBuffer stereotypeLabel = new StringBuffer();
            stereotypeLabel.append("\u00ab");
            while (true) {
                Stereotype appliedStereotype = (Stereotype)it.next();
                stereotypeLabel.append(appliedStereotype.getName());
                if (!it.hasNext()) break;
                stereotypeLabel.append(SPACED_COMMA);
            }
            stereotypeLabel.append("\u00bb");
            if (element instanceof Feature) {
                stereotypeLabel.append(SPACE);
            } else {
                stereotypeLabel.append(NL);
            }
            return stereotypeLabel.toString();
        }
        return "";
    }

    public String caseActivity(Activity object) {
        return "\u00abActivity\u00bb" + (String)this.caseBehavior((Behavior)object);
    }

    public String caseClass(Class object) {
        return this.caseTemplateableElement((TemplateableElement)object);
    }

    public String caseComponentRealization(ComponentRealization object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object);
    }

    public String caseConstraint(Constraint object) {
        StringBuilder label = new StringBuilder();
        label.append('{');
        if (object != null) {
            ValueSpecification specification;
            String constraintName = object.getName();
            if (!Strings.isNullOrEmpty((String)constraintName)) {
                label.append(constraintName);
                label.append(':');
            }
            if ((specification = object.getSpecification()) == null) {
                label.append("missing specification");
            } else {
                label.append(specification.stringValue());
            }
        }
        label.append('}');
        return label.toString();
    }

    public String caseDataStoreNode(DataStoreNode object) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u00ab");
        buffer.append("Datastore");
        buffer.append("\u00bb");
        buffer.append(NL);
        buffer.append(this.caseNamedElement((NamedElement)object));
        return buffer.toString();
    }

    public String caseDependency(Dependency object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object);
    }

    public String caseDeployment(Deployment object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object) + "\u00abdeploy\u00bb";
    }

    public String caseDuration(Duration object) {
        return object.getName();
    }

    public String caseElementImport(ElementImport object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object) + "\u00abimport\u00bb";
    }

    public String caseEnumerationLiteral(EnumerationLiteral object) {
        return object.getLabel();
    }

    public String caseExecutionSpecification(ExecutionSpecification execution) {
        if (execution instanceof BehaviorExecutionSpecification && ((BehaviorExecutionSpecification)execution).getBehavior() != null && ((BehaviorExecutionSpecification)execution).getBehavior().getSpecification() != null) {
            return this.caseOperation((Operation)((BehaviorExecutionSpecification)execution).getBehavior().getSpecification());
        }
        return execution.getLabel();
    }

    public String caseExpression(Expression object) {
        return object.getName();
    }

    public String casePackageMerge(PackageMerge object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object) + "\u00abmerge\u00bb";
    }

    public String caseElement(Element object) {
        return DisplayLabelSwitch.computeStereotypes(object);
    }

    public String caseSubstitution(Substitution object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object) + "\u00absubstitue>>\u00bb";
    }

    public String caseInstanceSpecification(InstanceSpecification object) {
        StringBuilder label = new StringBuilder(this.caseNamedElement((NamedElement)object));
        if (object.getClassifiers() != null && object.getClassifiers().size() > 0) {
            label.append(SPACED_COLUMN);
            Iterator it = object.getClassifiers().iterator();
            while (it.hasNext()) {
                Classifier classifier = (Classifier)it.next();
                label.append(((String)this.doSwitch((EObject)classifier)).replace("\n", SPACE));
                if (!it.hasNext()) continue;
                label.append(SPACED_COMMA);
            }
        }
        return label.toString();
    }

    public String caseInstanceValue(InstanceValue object) {
        return LabelServices.INSTANCE.computeUmlLabel((Element)object.getInstance());
    }

    public String caseInterfaceRealization(InterfaceRealization object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object);
    }

    public String caseInterval(Interval object) {
        String minLabel = LabelServices.INSTANCE.computeUmlLabel((Element)object.getMin());
        String maxLabel = LabelServices.INSTANCE.computeUmlLabel((Element)object.getMax());
        if (minLabel != null && minLabel.length() > 0 && maxLabel != null && maxLabel.length() > 0) {
            return OPENING_BRACE + minLabel + SPACE + maxLabel + CLOSING_BRACE;
        }
        return "";
    }

    public String caseLifeline(Lifeline lifeline) {
        StringBuilder label = new StringBuilder();
        if (lifeline.getRepresents() != null && this.isDependencyDescribed(lifeline)) {
            for (NamedElement context : ((Dependency)lifeline.getClientDependencies().get(0)).getSuppliers()) {
                label.append(context.getLabel());
                label.append(SPACED_COLUMN.trim());
                label.append(SPACED_COLUMN.trim());
            }
            label.append((String)this.doSwitch((EObject)lifeline.getRepresents()));
        } else if (lifeline.getRepresents() == null && this.isDependencyDescribed(lifeline)) {
            for (NamedElement context : ((Dependency)lifeline.getClientDependencies().get(0)).getSuppliers()) {
                label.append((String)this.doSwitch((EObject)context));
            }
        } else if (lifeline.getRepresents() instanceof Property) {
            label.append(this.caseProperty((Property)lifeline.getRepresents()));
        } else {
            label.append(this.caseNamedElement((NamedElement)lifeline));
        }
        return label.toString();
    }

    public String caseLiteralBoolean(LiteralBoolean object) {
        return object.stringValue();
    }

    public String caseLiteralInteger(LiteralInteger object) {
        return object.stringValue();
    }

    public String caseLiteralNull(LiteralNull object) {
        return "null";
    }

    public String caseLiteralReal(LiteralReal object) {
        return object.stringValue();
    }

    public String caseLiteralString(LiteralString object) {
        return object.stringValue();
    }

    public String caseLiteralUnlimitedNatural(LiteralUnlimitedNatural object) {
        return object.stringValue();
    }

    public String caseMultiplicityElement(MultiplicityElement object) {
        return this.getMultiplicity(object.getLower(), object.getUpper());
    }

    public String caseNamedElement(NamedElement object) {
        if (showQualifiedNameFilter) {
            return DisplayLabelSwitch.computeStereotypes((Element)object) + (object.getName() == null ? "" : UMLQualifiedNameUtils.getQualifiedName((NamedElement)object, (String)":"));
        }
        return DisplayLabelSwitch.computeStereotypes((Element)object) + (object.getName() == null ? "" : UMLLabelInternationalization.getInstance().getLabel(object, this.shouldTranslate()));
    }

    protected boolean shouldTranslate() {
        return UMLEditPlugin.INSTANCE.shouldTranslate();
    }

    public String caseOpaqueExpression(OpaqueExpression object) {
        String expr = (String)object.getBodies().get(0);
        if (!(expr == null || "".equalsIgnoreCase(expr) || "true".equalsIgnoreCase(expr) || "1".equalsIgnoreCase(expr))) {
            return expr;
        }
        return "";
    }

    public String caseOperation(Operation object) {
        StringBuilder label = new StringBuilder(this.caseNamedElement((NamedElement)object));
        label.append("(");
        boolean first = true;
        for (Parameter parameter : object.getOwnedParameters()) {
            if (ParameterDirectionKind.RETURN_LITERAL.equals((Object)parameter.getDirection())) continue;
            if (!first) {
                label.append(SPACED_COMMA);
            } else {
                first = false;
            }
            label.append(this.caseTypedElement((TypedElement)parameter));
        }
        label.append(")");
        if (object.getType() != null) {
            label.append(SPACED_COLUMN + object.getType().getName());
            label.append(this.getMultiplicity(object.getLower(), object.getUpper()));
        }
        StringBuilder operProperties = new StringBuilder();
        if (object.getRedefinedElements() != null && object.getRedefinedElements().size() > 0 && object.getRedefinedElements().get(0) != null) {
            operProperties.append("redefines " + ((RedefinableElement)object.getRedefinedElements().get(0)).getName());
        }
        if (object.isQuery()) {
            if (operProperties.length() > 0) {
                operProperties.append(SPACED_COMMA);
            }
            operProperties.append("query");
        }
        if (object.isOrdered()) {
            if (operProperties.length() > 0) {
                operProperties.append(SPACED_COMMA);
            }
            operProperties.append("ordered");
        }
        if (!object.isUnique()) {
            if (operProperties.length() > 0) {
                operProperties.append(SPACED_COMMA);
            }
            operProperties.append("nonunique");
        }
        if (operProperties.length() > 0) {
            label.append("{" + String.valueOf(operProperties) + "}");
        }
        return label.toString();
    }

    public String caseParameter(Parameter object) {
        StringBuilder label = new StringBuilder(this.caseNamedElement((NamedElement)object));
        return label.toString();
    }

    public String casePin(Pin object) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.caseTypedElement((TypedElement)object));
        buffer.append(this.caseMultiplicityElement((MultiplicityElement)object));
        return buffer.toString();
    }

    public String casePort(Port object) {
        String tilde = "";
        if (object.isConjugated()) {
            tilde = "~";
        }
        if (object.getType() != null) {
            return this.caseNamedElement((NamedElement)object) + SPACED_COLUMN + tilde + object.getType().getName();
        }
        return this.caseNamedElement((NamedElement)object) + SPACED_COLUMN;
    }

    public String caseProfile(Profile profile) {
        return profile.getName();
    }

    public String caseProperty(Property property) {
        if (property != null && !property.getQualifiers().isEmpty()) {
            Object label = "";
            boolean first = true;
            for (Property qualifier : property.getQualifiers()) {
                if (first) {
                    label = (String)label + SPACE + this.computeLabel(qualifier);
                    first = false;
                    continue;
                }
                label = (String)label + END_OF_LINE;
                label = (String)label + SPACE + this.computeLabel(qualifier);
            }
            return label;
        }
        return this.computeLabel(property);
    }

    public String caseProtocolStateMachine(ProtocolStateMachine object) {
        return object.getName();
    }

    public String caseSlot(Slot object) {
        if (object.getDefiningFeature() == null) {
            return "<UNDEFINED>";
        }
        StringBuilder label = new StringBuilder(object.getDefiningFeature().getName());
        label.append(" = ");
        EList values = object.getValues();
        boolean first = true;
        for (ValueSpecification valueSpecification : values) {
            if (first) {
                first = false;
            } else {
                label.append(SPACED_COMMA);
            }
            if (valueSpecification instanceof InstanceValue) {
                InstanceValue anInstanceValue = (InstanceValue)valueSpecification;
                label.append(anInstanceValue.getInstance().getName());
                continue;
            }
            if (valueSpecification instanceof LiteralString) {
                LiteralString aLiteralString = (LiteralString)valueSpecification;
                label.append(aLiteralString.getValue());
                continue;
            }
            if (valueSpecification instanceof LiteralInteger) {
                LiteralInteger aLiteralInteger = (LiteralInteger)valueSpecification;
                label.append(aLiteralInteger.getValue());
                continue;
            }
            if (valueSpecification instanceof LiteralBoolean) {
                LiteralBoolean aLiteralBoolean = (LiteralBoolean)valueSpecification;
                label.append(aLiteralBoolean.booleanValue());
                continue;
            }
            label.append(valueSpecification.getName());
        }
        return label.toString();
    }

    public String caseStateMachine(StateMachine object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object) + "\u00abStateMachine\u00bb" + (String)this.caseBehavior((Behavior)object);
    }

    public String caseStereotype(Stereotype stereotype) {
        String name = stereotype.getName();
        String profileName = stereotype.containingProfile().getName();
        return profileName + " :: " + name;
    }

    public String caseStructuralFeature(StructuralFeature object) {
        return this.caseTypedElement((TypedElement)object) + SPACE + this.caseMultiplicityElement((MultiplicityElement)object);
    }

    public String caseTemplateableElement(TemplateableElement object) {
        String templateParameters = LabelServices.INSTANCE.getTemplatedParameters(object);
        if (templateParameters != null) {
            return DisplayLabelSwitch.computeStereotypes((Element)object) + this.caseNamedElement((NamedElement)object) + templateParameters;
        }
        return this.caseNamedElement((NamedElement)object);
    }

    public String caseTemplateBinding(TemplateBinding object) {
        EList parameterSubstitutions = object.getParameterSubstitutions();
        StringBuffer binding = new StringBuffer();
        boolean first = true;
        for (TemplateParameterSubstitution parameterSubstitution : parameterSubstitutions) {
            if (first) {
                first = false;
            } else {
                binding.append(SPACED_COMMA);
            }
            ParameterableElement formal = parameterSubstitution.getFormal().getDefault();
            if (!(formal instanceof NamedElement)) continue;
            binding.append(((NamedElement)formal).getName() + "->");
            ParameterableElement actual = parameterSubstitution.getActual();
            if (actual != null && actual instanceof NamedElement) {
                binding.append(((NamedElement)actual).getName());
                continue;
            }
            binding.append("?");
        }
        return DisplayLabelSwitch.computeStereotypes((Element)object) + binding.toString();
    }

    public String caseTimeExpression(TimeExpression object) {
        return object.stringValue();
    }

    public String caseTransition(Transition object) {
        String behaviorLabel;
        String specificationLabel;
        ValueSpecification specification;
        Object triggersLabel = null;
        if (object.getTriggers() != null && object.getTriggers().size() > 0) {
            for (Trigger trigger : object.getTriggers()) {
                triggersLabel = triggersLabel != null ? triggersLabel + "," : "";
                triggersLabel = (String)triggersLabel + LabelServices.INSTANCE.computeUmlLabel((Element)trigger);
            }
        }
        String guardLabel = null;
        Constraint constraint = object.getGuard();
        if (constraint != null && (specification = constraint.getSpecification()) != null && (specificationLabel = LabelServices.INSTANCE.computeUmlLabel((Element)specification)) != null && specificationLabel.length() > 0) {
            guardLabel = OPENING_BRACE + specificationLabel + CLOSING_BRACE;
        }
        String effectLabel = null;
        Behavior effect = object.getEffect();
        if (effect != null && (behaviorLabel = LabelServices.INSTANCE.computeUmlLabel((Element)effect)) != null) {
            effectLabel = "/" + behaviorLabel;
        }
        StringBuffer transitionLabel = new StringBuffer();
        if (triggersLabel != null && ((String)triggersLabel).length() > 0) {
            transitionLabel.append((String)triggersLabel);
        }
        if (guardLabel != null && guardLabel.length() > 0) {
            transitionLabel.append(guardLabel);
        }
        if (effectLabel != null && effectLabel.length() > 0) {
            transitionLabel.append(effectLabel);
        }
        return DisplayLabelSwitch.computeStereotypes((Element)object) + transitionLabel.toString();
    }

    public String caseTypedElement(TypedElement object) {
        if (object.getType() != null) {
            return this.caseNamedElement((NamedElement)object) + SPACED_COLUMN + object.getType().getName();
        }
        return this.caseNamedElement((NamedElement)object) + SPACED_COLUMN;
    }

    public String caseUsage(Usage object) {
        return DisplayLabelSwitch.computeStereotypes((Element)object) + "\u00abuse\u00bb";
    }

    private String computeLabel(Property object) {
        if (object.eContainer() instanceof Property && object.eContainmentFeature().getFeatureID() == 33) {
            return this.computeQualifierLabel(object);
        }
        return this.computePropertyLabel(object);
    }

    private String computePropertyLabel(Property object) {
        NamedElement elem;
        String parentName;
        StringBuilder label = new StringBuilder();
        if (object.isDerived()) {
            label.append("/");
        }
        label.append(this.caseStructuralFeature((StructuralFeature)object));
        if (object.getDefault() != null && !"".equals(object.getDefault().trim())) {
            if (object.getDefault().contains(NL)) {
                label.append(" = ...");
            } else {
                label.append(" = " + object.getDefault());
            }
        } else if (object.getDefaultValue() instanceof InstanceValue) {
            label.append(" = " + ((InstanceValue)object.getDefaultValue()).getName());
        }
        StringBuilder propertyModifier = new StringBuilder();
        if (object.getRedefinedElements() != null && object.getRedefinedElements().size() > 0 && object.getRedefinedElements().get(0) != null) {
            parentName = null;
            if (((RedefinableElement)object.getRedefinedElements().get(0)).eContainer() instanceof NamedElement) {
                elem = (NamedElement)((RedefinableElement)object.getRedefinedElements().get(0)).eContainer();
                parentName = elem.getName();
            }
            Object redefPropertyname = ((RedefinableElement)object.getRedefinedElements().get(0)).getName();
            if (parentName != null && !parentName.isEmpty()) {
                redefPropertyname = parentName + "::" + ((RedefinableElement)object.getRedefinedElements().get(0)).getName();
            }
            propertyModifier.append("redefines " + (String)redefPropertyname);
        }
        if (object.getSubsettedProperties() != null && object.getSubsettedProperties().size() > 0 && object.getSubsettedProperties().get(0) != null) {
            parentName = null;
            if (((Property)object.getSubsettedProperties().get(0)).eContainer() instanceof NamedElement) {
                elem = (NamedElement)((Property)object.getSubsettedProperties().get(0)).eContainer();
                parentName = elem.getName();
            }
            Object subsetPropertyname = ((Property)object.getSubsettedProperties().get(0)).getName();
            if (parentName != null && !parentName.isEmpty()) {
                subsetPropertyname = parentName + "::" + ((Property)object.getSubsettedProperties().get(0)).getName();
            }
            propertyModifier.append("subsets " + (String)subsetPropertyname);
        }
        if (object.isID()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("id");
        }
        if (object.isReadOnly()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("readOnly");
        }
        if (object.getUpper() != 1 && object.isOrdered()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("ordered");
        }
        if (object.getUpper() != 1 && object.isUnique()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("unique");
        }
        if (!object.isUnique() && object.isOrdered()) {
            if (propertyModifier.length() > 0) {
                propertyModifier.append(SPACED_COMMA);
            }
            propertyModifier.append("seq");
        }
        if (propertyModifier.length() > 0) {
            label.append("{" + String.valueOf(propertyModifier) + "}");
        }
        return label.toString();
    }

    private String computeQualifierLabel(Property object) {
        if (object.getType() != null) {
            return this.caseNamedElement((NamedElement)object) + SPACED_COLUMN + object.getType().getName();
        }
        return this.caseNamedElement((NamedElement)object);
    }

    public String getAssociationEndLabel(Property p) {
        StringBuilder sb = new StringBuilder("");
        if (p.isDerived()) {
            sb.append("/");
        }
        if (p.getName() != null) {
            sb.append("+ " + p.getName());
        }
        sb.append(this.caseMultiplicityElement((MultiplicityElement)p));
        return sb.toString();
    }

    private String getMultiplicity(int lower, int upper) {
        StringBuffer label = new StringBuffer();
        if (lower == upper) {
            label.append(OPENING_BRACE + lower + CLOSING_BRACE);
        } else if (lower == 0 && upper == -1) {
            label.append("[*]");
        } else {
            label.append(OPENING_BRACE + lower + "..");
            if (upper == -1) {
                label.append("*]");
            } else {
                label.append(upper + CLOSING_BRACE);
            }
        }
        return label.toString();
    }

    private boolean isDependencyDescribed(Lifeline lifeline) {
        return lifeline.getClientDependencies() != null && lifeline.getClientDependencies().size() > 0 && lifeline.getClientDependencies().get(0) != null && ((Dependency)lifeline.getClientDependencies().get(0)).getSuppliers().size() > 0;
    }

    public static void setStereotypeFilter(boolean filterValue) {
        showStereotypeFilter = filterValue;
    }

    public static void setQualifiedNameFilter(boolean filterValue) {
        showQualifiedNameFilter = filterValue;
    }
}

