/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.navigation.navigableElement;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.papyrus.infra.services.navigation.service.NavigableElement;
import org.eclipse.papyrus.infra.services.navigation.service.NavigationContributor;
import org.eclipse.papyrus.uml.navigation.navigableElement.MemberEndNavigableElement;
import org.eclipse.papyrus.uml.navigation.navigableElement.MemberEndTypeNavigableElement;
import org.eclipse.papyrus.uml.navigation.navigableElement.SourceNavigableElement;
import org.eclipse.papyrus.uml.navigation.navigableElement.TargetNavigableElement;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;

public class RelationshipNavigationContributor
implements NavigationContributor {
    public List<NavigableElement> getNavigableElements(Object fromElement) {
        Association association;
        LinkedList<NavigableElement> result = new LinkedList<NavigableElement>();
        Element element = UMLUtil.resolveUMLElement((Object)fromElement);
        if (element instanceof DirectedRelationship) {
            DirectedRelationship relationship = (DirectedRelationship)element;
            if (relationship.getTargets().size() > 0) {
                result.add((NavigableElement)new TargetNavigableElement(relationship));
            }
            if (relationship.getSources().size() > 0) {
                result.add((NavigableElement)new SourceNavigableElement(relationship));
            }
        } else if (element instanceof Association && (association = (Association)element).getMemberEnds().size() > 0) {
            for (Property end : association.getMemberEnds()) {
                result.add((NavigableElement)new MemberEndNavigableElement(end));
                if (end.getType() == null) continue;
                result.add((NavigableElement)new MemberEndTypeNavigableElement(end));
            }
        }
        return result;
    }
}

