/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.dnd.strategy.transition;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.papyrus.uml.tools.helper.EventCreationHelper;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;

public class OperationAsTriggerToTransitionDropStrategy
extends TransactionalDropStrategy {
    protected boolean understandRequest(Request request) {
        return request instanceof DropObjectsRequest;
    }

    protected boolean isTransitionEditPart(EditPart ep) {
        if (!(ep instanceof GraphicalEditPart)) {
            return false;
        }
        EObject targetSemantic = this.getTargetSemanticElement(ep);
        return targetSemantic instanceof Transition;
    }

    public Command doGetCommand(Request request, EditPart targetEditPart) {
        if (this.understandRequest(request) && this.isTransitionEditPart(targetEditPart)) {
            List sourceEObjects = this.getSourceEObjects(request);
            if (sourceEObjects.size() != 1) {
                return null;
            }
            if (!(sourceEObjects.get(0) instanceof Operation)) {
                return null;
            }
            final Operation operation = (Operation)sourceEObjects.get(0);
            final Transition transition = (Transition)this.getTargetSemanticElement(targetEditPart);
            return new Command(){

                public void execute() {
                    if (transition != null && operation != null) {
                        CallEvent callEvent;
                        Package pkg;
                        Trigger trigger2;
                        for (Trigger trigger2 : transition.getTriggers()) {
                            if (!(trigger2.getEvent() instanceof CallEvent) || ((CallEvent)trigger2.getEvent()).getOperation() != operation) continue;
                            return;
                        }
                        trigger2 = transition.createTrigger("");
                        EventCreationHelper helper = new EventCreationHelper(transition);
                        if (trigger2 != null && (pkg = transition.getNearestPackage()) != null && (callEvent = helper.getOrCreateCallEvent(operation, false)) != null) {
                            callEvent.setOperation(operation);
                            trigger2.setEvent((Event)callEvent);
                        }
                    }
                }
            };
        }
        return null;
    }

    public String getLabel() {
        return "Drop operation as trigger with call event";
    }

    public String getID() {
        return "org.eclipse.papyrus.uml.diagram.dnd.OperationAsTriggerToTransitionDrop";
    }

    public String getDescription() {
        return "Drops an operation into a transition as a trigger with a call event";
    }

    public String getCategoryID() {
        return "org.eclipse.papyrus.dnd.OperationAsTriggerToTransitionDrop";
    }

    public String getCategoryLabel() {
        return "Drop an operation into a transition as a trigger with a call event";
    }

    public Image getImage() {
        return null;
    }

    public int getPriority() {
        return 0;
    }

    public void setOptions(Map<String, Object> options) {
    }
}

