/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.tools.utils.UMLUtil;
import org.eclipse.papyrus.uml.types.core.Activator;
import org.eclipse.papyrus.uml.types.core.advices.stereotypepropertyreferenceedgeadvice.StereotypePropertyReferenceEdgeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.core.commands.StereotypePropertyReferenceEdgeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class EditStereotypePropertyReferenceCommand
extends EditElementCommand {
    private Stereotype stereotype;
    private EObject value;
    private Property attribute;
    private EObject elementToConfigure;
    private String featureToSet;
    private String stereotypeQualifyName;
    private StereotypePropertyReferenceEdgeAdviceConfiguration configuration;
    private CreateRelationshipRequest request;

    public EditStereotypePropertyReferenceCommand(String label, CreateRelationshipRequest request, StereotypePropertyReferenceEdgeAdviceConfiguration configuration) {
        super(label, null, (IEditCommandRequest)request);
        this.request = request;
        this.configuration = configuration;
        this.stereotypeQualifyName = this.configuration.getStereotypeQualifiedName();
        this.featureToSet = this.configuration.getFeatureToSet();
        this.init(request);
    }

    private void init(CreateRelationshipRequest request) {
        Stereotype targetStereotype;
        TransactionalEditingDomain editingDomain;
        EObject source = request.getSource();
        EObject target = request.getTarget();
        this.elementToConfigure = source;
        if (this.configuration != null && this.elementToConfigure instanceof Element && (editingDomain = request.getEditingDomain()) != null && (targetStereotype = ((Element)this.elementToConfigure).getApplicableStereotype(this.stereotypeQualifyName)) != null) {
            this.attribute = targetStereotype.getAttribute(this.featureToSet, null);
            this.stereotype = UMLUtil.getAppliedSubstereotype((Element)((Element)this.elementToConfigure), (Stereotype)targetStereotype);
            Type targetType = this.attribute.getType();
            this.value = null;
            this.value = targetType instanceof Stereotype ? this.getStereotypeApplication((Element)target, (Stereotype)targetType) : target;
        }
    }

    public boolean canExecute() {
        return this.attribute != null && this.elementToConfigure != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) {
        try {
            if (1 == this.attribute.getUpper()) {
                ((Element)this.elementToConfigure).setValue(this.stereotype, this.featureToSet, (Object)this.value);
                ICommand cleanStereotypePropertyReferenceLinkCommand = StereotypePropertyReferenceEdgeUtil.getCleanStereotypePropertyReferenceEdgeCommand(this.request, this.stereotypeQualifyName, this.featureToSet);
                if (cleanStereotypePropertyReferenceLinkCommand != null && cleanStereotypePropertyReferenceLinkCommand.canExecute()) {
                    try {
                        cleanStereotypePropertyReferenceLinkCommand.execute(null, null);
                    }
                    catch (ExecutionException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
            } else {
                Object list = ((Element)this.elementToConfigure).getValue(this.stereotype, this.featureToSet);
                if (list instanceof List) {
                    ((List)list).add(this.value);
                }
            }
        }
        catch (IllegalArgumentException e) {
            return CommandResult.newErrorCommandResult((Throwable)e);
        }
        return CommandResult.newOKCommandResult();
    }

    protected EObject getStereotypeApplication(Element umlElement, Stereotype stereotype) {
        Stereotype actual = stereotype == null ? null : UMLUtil.getAppliedSubstereotype((Element)umlElement, (Stereotype)stereotype);
        EObject stereotypeApplication = actual == null ? null : umlElement.getStereotypeApplication(actual);
        return stereotypeApplication;
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }
}

