/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import org.eclipse.uml2.uml.Artifact;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.Type;

public class AssociationServices {
    private static final int MEMBER_END_SOURCE_INDEX = 0;
    private static final int MEMBER_END_TARGET_INDEX = 1;
    public static final AssociationServices INSTANCE = new AssociationServices();

    protected AssociationServices() {
    }

    public Type getSourceType(Association association) {
        if (association.getMemberEnds().size() == 2) {
            Property targetproperty = (Property)association.getMemberEnds().get(1);
            return targetproperty.getType();
        }
        return null;
    }

    public Type getTargetType(Association association) {
        if (association.getMemberEnds().size() == 2) {
            Property sourceProperty = (Property)association.getMemberEnds().get(0);
            return sourceProperty.getType();
        }
        return null;
    }

    public Property getSourceProperty(Association association) {
        if (association.getMemberEnds().size() == 2) {
            return (Property)association.getMemberEnds().get(0);
        }
        return null;
    }

    public Property getTargetProperty(Association association) {
        if (association.getMemberEnds().size() == 2) {
            return (Property)association.getMemberEnds().get(1);
        }
        return null;
    }

    public boolean canReconnectSource(Element context, Element newSource) {
        return newSource instanceof Class || newSource instanceof Enumeration || newSource instanceof Interface || newSource instanceof PrimitiveType;
    }

    public boolean canReconnectTarget(Element context, Element newTarget) {
        return this.canReconnectSource(context, newTarget);
    }

    public void reconnectSource(Association association, Classifier oldSource, Classifier newSource) {
        Property sourceProperty = this.getSourceProperty(association);
        Property targetProperty = this.getTargetProperty(association);
        targetProperty.setType((Type)newSource);
        targetProperty.setName(newSource.getName().toLowerCase());
        if (sourceProperty.getOwner() == oldSource) {
            if (newSource instanceof Artifact) {
                ((Artifact)newSource).getOwnedAttributes().add((Object)sourceProperty);
            } else if (newSource instanceof DataType) {
                ((DataType)newSource).getOwnedAttributes().add((Object)sourceProperty);
            } else if (newSource instanceof Interface) {
                ((Interface)newSource).getOwnedAttributes().add((Object)sourceProperty);
            } else if (newSource instanceof Signal) {
                ((Signal)newSource).getOwnedAttributes().add((Object)sourceProperty);
            } else if (newSource instanceof StructuredClassifier) {
                ((StructuredClassifier)newSource).getOwnedAttributes().add((Object)sourceProperty);
            }
        }
    }

    public void reconnectTarget(Association association, Classifier oldTarget, Classifier newTarget) {
        Property sourceProperty = this.getSourceProperty(association);
        Property targetProperty = this.getTargetProperty(association);
        sourceProperty.setType((Type)newTarget);
        sourceProperty.setName(newTarget.getName().toLowerCase());
        if (targetProperty.getOwner() == oldTarget) {
            if (newTarget instanceof Artifact) {
                ((Artifact)newTarget).getOwnedAttributes().add((Object)targetProperty);
            } else if (newTarget instanceof DataType) {
                ((DataType)newTarget).getOwnedAttributes().add((Object)targetProperty);
            } else if (newTarget instanceof Interface) {
                ((Interface)newTarget).getOwnedAttributes().add((Object)targetProperty);
            } else if (newTarget instanceof Signal) {
                ((Signal)newTarget).getOwnedAttributes().add((Object)targetProperty);
            } else if (newTarget instanceof StructuredClassifier) {
                ((StructuredClassifier)newTarget).getOwnedAttributes().add((Object)targetProperty);
            }
        }
    }
}

