/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;

public class ProfileConstraintUtils {
    public static boolean isStereotypeProperty(EObject eObject) {
        Property property;
        boolean isStereotypeProperty = false;
        if (eObject instanceof Property && (property = (Property)eObject).getOwner() instanceof Stereotype) {
            isStereotypeProperty = true;
        }
        return isStereotypeProperty;
    }

    public static boolean hasType(Property property) {
        boolean hasType = false;
        if (property.getType() != null) {
            hasType = true;
        }
        return hasType;
    }

    public static boolean hasDefaultValueRequired(Property property) {
        Type type;
        boolean hasDefaultValueRequired = true;
        if (ProfileConstraintUtils.hasType(property) && ((type = property.getType()) instanceof PrimitiveType || type instanceof Enumeration) && property.getLower() != 0 && property.getDefaultValue() == null) {
            hasDefaultValueRequired = false;
        }
        return hasDefaultValueRequired;
    }

    public static boolean hasLowerMultiplicityRequired(Property property) {
        Type type;
        boolean hasDefaultValueRequired = true;
        if (ProfileConstraintUtils.hasType(property) && !((type = property.getType()) instanceof PrimitiveType) && !(type instanceof Enumeration) && property.getLower() != 0) {
            if (property.isSetName() && property.getName().length() > 5) {
                if (!"base_".equals(property.getName().substring(0, 5))) {
                    hasDefaultValueRequired = false;
                }
            } else {
                hasDefaultValueRequired = false;
            }
        }
        return hasDefaultValueRequired;
    }

    public static boolean hasUniqueName(Property property) {
        boolean hasUniqueName = true;
        if (property.isSetName() && !"".equals(property.getName()) && property.getOwner() instanceof Stereotype) {
            Stereotype owner = (Stereotype)property.getOwner();
            for (Property current : owner.getAllAttributes()) {
                if (!current.isSetName() || current == property || !current.getName().equals(property.getName())) continue;
                hasUniqueName = false;
            }
        }
        return hasUniqueName;
    }
}

