/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.emf.Activator;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class BundleResourceURIHelper {
    private static final Map<String, String> URI_VS_BUNDLE_NAME = new HashMap<String, String>();
    public static final BundleResourceURIHelper INSTANCE = new BundleResourceURIHelper();

    private BundleResourceURIHelper() {
    }

    public String getBundleNameFromResource(Resource resource) {
        URI uri = resource.getURI();
        if (uri.isPlatformPlugin() || uri.isPlatformResource()) {
            String projectName = uri.segment(1);
            return projectName;
        }
        String uriToString = uri.toString();
        return this.getBundleNameFromNS_URI(uriToString);
    }

    public Set<String> getBundleNameFromNS_URI(Collection<String> nsURIs) {
        HashSet<String> result = new HashSet<String>();
        for (String currentNS_URI : nsURIs) {
            String bundleName = this.getBundleNameFromNS_URI(currentNS_URI);
            if (bundleName != null) {
                result.add(bundleName);
                continue;
            }
            Activator.log.warn(NLS.bind((String)"Papyrus: We don't found the bundle providing the nsURI {0}", (Object)currentNS_URI));
        }
        return result;
    }

    public String getBundleNameFromNS_URI(String nsURI) {
        EPackage ePackage;
        String bundleName = URI_VS_BUNDLE_NAME.get(nsURI);
        if (bundleName == null && (ePackage = EPackageRegistryImpl.INSTANCE.getEPackage(nsURI)) != null) {
            Class<?> class_ = ePackage.getClass();
            Bundle b = FrameworkUtil.getBundle(class_);
            if (b == null) {
                throw new UnsupportedOperationException();
            }
            bundleName = b.getSymbolicName();
            if (bundleName != null) {
                URI_VS_BUNDLE_NAME.put(nsURI, b.getSymbolicName());
            } else {
                Activator.log.warn(NLS.bind((String)"Papyrus: We don't found a bundle named {0}.", (Object)bundleName));
            }
        }
        return bundleName;
    }
}

