/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import java.util.List;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.editors.ReferenceDialog;
import org.eclipse.papyrus.infra.widgets.editors.StringCombo;
import org.eclipse.papyrus.infra.widgets.messages.Messages;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class MultiplicityDialog
extends AbstractValueEditor
implements SelectionListener,
IChangeListener {
    protected static final int MULTIPLICITY_STRING_COMBO_INDEX = 0;
    protected static final int MULTIPLICITY_LOWER_VALUE_INDEX = 1;
    protected static final int MULTIPLICITY_UPPER_VALUE_INDEX = 2;
    protected StackLayout stackLayout = new StackLayout();
    protected StringCombo stringComboEditor;
    protected Composite stackLayoutComposite;
    protected Composite doubleEditorsComposite;
    protected AbstractReferenceDialog lowerValueEditor;
    protected AbstractReferenceDialog upperValueEditor;
    protected Button switchEditorsButton;
    protected boolean readOnly;
    protected IPreferenceStore preferenceStore;

    public MultiplicityDialog(Composite parent, int style) {
        this(parent, style, (IPreferenceStore)null);
    }

    public MultiplicityDialog(Composite parent, int style, IPreferenceStore preferenceStore) {
        super(parent, style);
        this.stackLayoutComposite = new Composite((Composite)this, style);
        this.stackLayoutComposite.setLayout((Layout)this.stackLayout);
        this.stackLayoutComposite.setLayoutData((Object)this.getDefaultLayoutData());
        this.stringComboEditor = new StringCombo(this.stackLayoutComposite, style){

            @Override
            protected void doBinding() {
                this.setWidgetObservable(this.getObservableValue());
                super.doBinding();
            }

            @Override
            public void setModelObservable(IObservableValue modelProperty) {
                this.modelProperty = modelProperty;
                this.setWidgetObservable(this.getObservableValue());
                super.setModelObservable(modelProperty);
                this.updateControls();
            }
        };
        this.stringComboEditor.setLayoutData(this.getDefaultLayoutData());
        this.doubleEditorsComposite = new Composite(this.stackLayoutComposite, style);
        GridLayout layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.doubleEditorsComposite.setLayout((Layout)layout);
        this.doubleEditorsComposite.setLayoutData((Object)this.getDefaultLayoutData());
        this.lowerValueEditor = this.createLowerValueSpecificationEditor(this.doubleEditorsComposite, style);
        this.lowerValueEditor.setLayoutData(this.getDefaultLayoutData());
        this.upperValueEditor = this.createUpperValueSpecificationEditor(this.doubleEditorsComposite, style);
        this.upperValueEditor.setLayoutData(this.getDefaultLayoutData());
        this.preferenceStore = preferenceStore;
        if (preferenceStore != null) {
            this.preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    MultiplicityDialog.this.displayTopControl();
                }
            });
        }
        this.displayTopControl();
        this.createButtons();
        this.updateControls();
    }

    protected AbstractReferenceDialog createLowerValueSpecificationEditor(Composite parent, int style) {
        return this.createValueSpecificationEditor(parent, style);
    }

    protected AbstractReferenceDialog createUpperValueSpecificationEditor(Composite parent, int style) {
        return this.createValueSpecificationEditor(parent, style);
    }

    protected AbstractReferenceDialog createValueSpecificationEditor(Composite parent, int style) {
        return new ReferenceDialog(parent, style);
    }

    protected void createButtons() {
        ++((GridLayout)this.getLayout()).numColumns;
        this.switchEditorsButton = factory.createButton((Composite)this, null, 8);
        this.switchEditorsButton.setImage(Activator.getDefault().getImage("/icons/Switch_12x12.gif"));
        this.switchEditorsButton.setToolTipText(Messages.MultiplicityReferenceDialog_SwitchEditors);
        this.switchEditorsButton.addSelectionListener((SelectionListener)this);
    }

    protected void displayTopControl() {
        if (this.preferenceStore != null) {
            String multiplicityEditorMode = this.preferenceStore.getString("multiplicityEditorMode");
            if (multiplicityEditorMode != null) {
                this.stackLayout.topControl = multiplicityEditorMode.equals("advanceMode") ? this.doubleEditorsComposite : this.stringComboEditor;
            } else if (this.stackLayout.topControl == null) {
                this.stackLayout.topControl = this.stringComboEditor;
            }
        } else if (this.stackLayout.topControl == null) {
            this.stackLayout.topControl = this.stringComboEditor;
        }
        if (!this.stackLayoutComposite.isDisposed()) {
            this.stackLayoutComposite.layout();
        }
        this.setReadOnly(this.readOnly);
    }

    protected void switchAction() {
        if (this.preferenceStore != null) {
            if (this.stackLayout.topControl.equals((Object)this.stringComboEditor)) {
                this.preferenceStore.setValue("multiplicityEditorMode", "advanceMode");
            } else {
                this.preferenceStore.setValue("multiplicityEditorMode", "simpleMode");
            }
        } else {
            this.stackLayout.topControl = this.stackLayout.topControl.equals((Object)this.stringComboEditor) ? this.doubleEditorsComposite : this.stringComboEditor;
        }
        this.displayTopControl();
    }

    protected void updateLabels() {
        this.lowerValueEditor.updateLabel();
        this.upperValueEditor.updateLabel();
    }

    protected void updateControls() {
        if (this.stackLayout.topControl.equals((Object)this.stringComboEditor)) {
            if (!this.stringComboEditor.isDisposed()) {
                this.stringComboEditor.updateControls();
            }
        } else {
            if (!this.lowerValueEditor.isDisposed()) {
                this.lowerValueEditor.updateControls();
            }
            if (!this.upperValueEditor.isDisposed()) {
                this.upperValueEditor.updateControls();
            }
        }
    }

    public void update() {
        super.update();
        if (this.stackLayout.topControl.equals((Object)this.stringComboEditor)) {
            if (!this.stringComboEditor.isDisposed()) {
                this.stringComboEditor.update();
            }
        } else {
            if (!this.lowerValueEditor.isDisposed()) {
                this.lowerValueEditor.update();
            }
            if (!this.upperValueEditor.isDisposed()) {
                this.upperValueEditor.update();
            }
        }
        this.updateControls();
    }

    @Override
    protected void doBinding() {
        super.doBinding();
        if (this.stringComboEditor != null) {
            this.stringComboEditor.doBinding();
        }
        if (this.lowerValueEditor != null) {
            this.lowerValueEditor.doBinding();
        }
        if (this.upperValueEditor != null) {
            this.upperValueEditor.doBinding();
        }
        this.modelProperty.addChangeListener((IChangeListener)this);
    }

    public void setContentProviders(List<IStaticContentProvider> providers) {
        this.stringComboEditor.setContentProvider(this.getObjectFromList(providers, 0));
        this.lowerValueEditor.setContentProvider(this.getObjectFromList(providers, 1));
        this.upperValueEditor.setContentProvider(this.getObjectFromList(providers, 2));
    }

    public void setLabelProviders(List<ILabelProvider> providers) {
        this.stringComboEditor.setLabelProvider(this.getObjectFromList(providers, 0));
        this.lowerValueEditor.setLabelProvider(this.getObjectFromList(providers, 1));
        this.upperValueEditor.setLabelProvider(this.getObjectFromList(providers, 2));
        this.updateControls();
        this.updateLabels();
    }

    @Override
    public Object getEditableType() {
        return Object.class;
    }

    protected boolean canEditStringCombo() {
        return true;
    }

    protected boolean canEditLowerValue() {
        return true;
    }

    protected boolean canEditUpperValue() {
        return true;
    }

    @Override
    public void setModelObservable(IObservableValue modelProperty) {
        this.setWidgetObservable(modelProperty);
        this.setEditorsModelObservable(modelProperty);
        super.setModelObservable(modelProperty);
        this.updateControls();
        this.updateLabels();
    }

    protected void setEditorsModelObservable(IObservableValue modelProperty) {
        if (modelProperty != null && modelProperty.getValue() instanceof List) {
            Object upperValueObservableValue;
            Object lowerValueObservableValue;
            Object stringComboObservableValue = this.getObjectFromList((List)modelProperty.getValue(), 0);
            if (stringComboObservableValue instanceof IObservableValue) {
                this.stringComboEditor.setModelObservable((IObservableValue)stringComboObservableValue);
            }
            if ((lowerValueObservableValue = this.getObjectFromList((List)modelProperty.getValue(), 1)) instanceof IObservableValue) {
                this.lowerValueEditor.setModelObservable((IObservableValue)lowerValueObservableValue);
            }
            if ((upperValueObservableValue = this.getObjectFromList((List)modelProperty.getValue(), 2)) instanceof IObservableValue) {
                this.upperValueEditor.setModelObservable((IObservableValue)upperValueObservableValue);
            }
        }
    }

    public void setToolTipText(String text) {
        this.stringComboEditor.setToolTipText(text);
        this.lowerValueEditor.setToolTipText(Messages.MultiplicityReferenceDialog_LowerValueToolTip);
        this.upperValueEditor.setToolTipText(Messages.MultiplicityReferenceDialog_UpperValueToolTip);
    }

    public void setValueFactories(List<ReferenceValueFactory> factories) {
        this.lowerValueEditor.setValueFactory(this.getObjectFromList(factories, 1));
        this.upperValueEditor.setValueFactory(this.getObjectFromList(factories, 2));
        this.updateControls();
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        if (this.stackLayout.topControl.equals((Object)this.stringComboEditor)) {
            if (!this.stringComboEditor.isDisposed()) {
                this.stringComboEditor.setReadOnly(readOnly || !this.canEditStringCombo());
            }
        } else {
            if (!this.lowerValueEditor.isDisposed()) {
                this.lowerValueEditor.setReadOnly(readOnly || !this.canEditLowerValue());
            }
            if (!this.upperValueEditor.isDisposed()) {
                this.upperValueEditor.setReadOnly(readOnly || !this.canEditUpperValue());
            }
        }
        this.updateControls();
    }

    public void setDirectCreation(boolean directCreation) {
        this.lowerValueEditor.setDirectCreation(directCreation);
        this.upperValueEditor.setDirectCreation(directCreation);
        this.updateControls();
    }

    public void setMandatory(boolean mandatory) {
        this.lowerValueEditor.setMandatory(mandatory);
        this.upperValueEditor.setMandatory(mandatory);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void widgetSelected(SelectionEvent e) {
        Widget widget = e.widget;
        if (widget == this.switchEditorsButton) {
            this.switchAction();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void dispose() {
        if (this.stringComboEditor != null) {
            this.stringComboEditor.dispose();
        }
        if (this.lowerValueEditor != null) {
            this.lowerValueEditor.dispose();
        }
        if (this.upperValueEditor != null) {
            this.upperValueEditor.dispose();
        }
        super.dispose();
    }

    protected <T> T getObjectFromList(List<T> listObjects, int index) {
        T object = null;
        if (listObjects != null && !listObjects.isEmpty() && listObjects.size() > index) {
            object = listObjects.get(index);
        }
        return object;
    }

    @Override
    public Object getValue() {
        return this.modelProperty.getValue();
    }

    public void handleChange(ChangeEvent event) {
        this.setEditorsModelObservable(this.modelProperty);
        this.setReadOnly(this.readOnly);
    }
}

