/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.DiagramExpansion;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.UseContext;
import org.eclipse.papyrus.infra.gmfdiag.expansion.expansionmodel.rendering.ChildrenListRepresentation;
import org.osgi.framework.Bundle;

public class DiagramExpansionsRegistry {
    protected static final String EXPANSION_MODEL_EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.common.diagramExpansion";
    protected final String MODEL_ID = "model";
    protected ArrayList<DiagramExpansion> diagramExpansions = new ArrayList();
    protected HashMap<String, UseContext> usages = new HashMap();
    public HashMap<String, ChildrenListRepresentation> mapChildreen = new HashMap();

    public DiagramExpansionsRegistry() {
        this.init();
    }

    public void init() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXPANSION_MODEL_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            DiagramExpansion diagramExpansion = this.initializeOneModel((ResourceSet)resourceSet, configElements[i]);
            if (diagramExpansion != null) {
                this.installExpansionModel(diagramExpansion);
            }
            ++i;
        }
    }

    protected void installExpansionModel(DiagramExpansion diagramExpansion) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)diagramExpansion);
        if (diagnostic.getSeverity() == 0) {
            this.diagramExpansions.add(diagramExpansion);
            for (UseContext usage : diagramExpansion.getUsages()) {
                if (this.usages.get(usage.getDiagramType()) == null) {
                    this.usages.put(usage.getDiagramType(), usage);
                    ChildrenListRepresentation childrenListRepresentation = new ChildrenListRepresentation(usage);
                    this.mapChildreen.put(usage.getDiagramType(), childrenListRepresentation);
                    Activator.log.trace("expansion", childrenListRepresentation.toString());
                    continue;
                }
                Activator.log.warn("Several expansions has been defined for the same diagram");
            }
        } else {
            Activator.log.warn("Expansion model not loaded");
            for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
                switch (childDiagnostic.getSeverity()) {
                    case 2: 
                    case 4: {
                        Activator.log.warn("\t" + childDiagnostic.getMessage());
                    }
                }
            }
        }
    }

    public ArrayList<DiagramExpansion> getDiagramExpansions() {
        return this.diagramExpansions;
    }

    public UseContext getUsage(String diagramType) {
        return this.usages.get(diagramType);
    }

    private DiagramExpansion initializeOneModel(ResourceSet resourceSet, IConfigurationElement element) {
        return DiagramExpansionsRegistry.createExtension(resourceSet, element, element.getAttribute("model"));
    }

    private static DiagramExpansion createExtension(ResourceSet resourceSet, IConfigurationElement element, String classAttribute) {
        URL url = null;
        try {
            URI uri;
            Resource resource;
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            url = extensionBundle.getResource(classAttribute);
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            if (url != null && (resource = resourceSet.getResource(uri = URI.createURI((String)url.toURI().toASCIIString()), true)).getContents().get(0) instanceof DiagramExpansion) {
                return (DiagramExpansion)resource.getContents().get(0);
            }
            return null;
        }
        catch (Exception e) {
            Activator.log.error("Unable to load an extension for org.eclipse.papyrus.infra.gmfdiag.common.diagramExpansion with the url" + String.valueOf(url), (Throwable)e);
            return null;
        }
    }

    public void loadExpansion(URI resourceURI) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(resourceURI, true);
        if (resource.getContents().get(0) instanceof DiagramExpansion) {
            DiagramExpansion diagramExpansion = (DiagramExpansion)resource.getContents().get(0);
            this.installExpansionModel(diagramExpansion);
        }
    }

    public void clear() {
        this.diagramExpansions.clear();
        this.usages.clear();
        this.mapChildreen.clear();
    }
}

