/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.extensionpoints.standard;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.uml.extensionpoints.Activator;
import org.eclipse.papyrus.uml.extensionpoints.IRegisteredItem;
import org.eclipse.swt.graphics.Image;

public abstract class RegisteredElementExtensionPoint
implements IRegisteredItem {
    public String name;
    public String path;
    public URI uri;
    public String qualifiednames;
    protected String description;
    protected String iconPath;
    protected String provider;
    public final IConfigurationElement configElement;
    public final int ordinal;

    public RegisteredElementExtensionPoint(IConfigurationElement configElt, int ordinal) {
        this.configElement = configElt;
        this.ordinal = ordinal;
        this.name = RegisteredElementExtensionPoint.getAttribute(configElt, "name", "undefined", true);
        this.path = RegisteredElementExtensionPoint.getAttribute(configElt, "path", "undefined", true);
        this.description = RegisteredElementExtensionPoint.getAttribute(configElt, "description", "", false);
        this.provider = RegisteredElementExtensionPoint.getAttribute(configElt, "provider", "", false);
        this.iconPath = RegisteredElementExtensionPoint.getAttribute(configElt, "iconpath", "", false);
        this.uri = URI.createURI((String)this.path);
    }

    protected static String getAttribute(IConfigurationElement configElt, String name, String defaultValue, boolean isRequired) {
        String value = configElt.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        if (isRequired) {
            throw new IllegalArgumentException("Missing " + name + " attribute");
        }
        return null;
    }

    protected Image getImage(String iconPath, IConfigurationElement configElement) {
        if (iconPath == null || "".equals(iconPath)) {
            return null;
        }
        String extensionPluginId = "";
        if (configElement != null) {
            IExtension extension = configElement.getDeclaringExtension();
            extensionPluginId = extension.getContributor().getName();
        } else {
            extensionPluginId = "org.eclipse.papyrus.uml.extensionpoints";
        }
        return Activator.getImage(extensionPluginId, iconPath);
    }

    @Override
    public Image getImage() {
        return this.getImage(this.iconPath, this.configElement);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }
}

