/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sirius.uml.diagram.common.core.services;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.ILabelConstants;
import org.eclipse.papyrus.sirius.uml.diagram.common.core.services.UMLInternationalizedNameSwitch;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.ValueSpecification;

public class UMLInternationalizedComplexLabelSwitch
extends UMLInternationalizedNameSwitch {
    public String caseConstraint(Constraint constraint) {
        String name = super.caseNamedElement((NamedElement)constraint);
        if (name != null && !name.isEmpty()) {
            StringBuilder builder = new StringBuilder(name);
            ValueSpecification specification = constraint.getSpecification();
            if (specification == null) {
                builder.append("missing specification");
            } else {
                String specificationLabel = (String)this.doSwitch((EObject)specification);
                if (specificationLabel != null) {
                    builder.append(ILabelConstants.NL);
                    builder.append(specificationLabel);
                }
            }
            return builder.toString();
        }
        return null;
    }

    public String caseOpaqueExpression(OpaqueExpression opaqueExpression) {
        if (opaqueExpression.getLanguages().size() > 0 && opaqueExpression.getBodies().size() > 0) {
            String language = (String)opaqueExpression.getLanguages().get(0);
            String body = (String)opaqueExpression.getBodies().get(0);
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            builder.append("{");
            builder.append(language);
            builder.append("}");
            builder.append(" ");
            builder.append(body);
            builder.append("}");
            return builder.toString();
        }
        return null;
    }

    public String caseProperty(Property property) {
        String visibility = this.getVisibility((NamedElement)property);
        String name = super.caseNamedElement((NamedElement)property);
        Type type = property.getType();
        String typeAsString = "<Undefined>";
        if (type != null) {
            typeAsString = (String)this.doSwitch((EObject)type);
        }
        String multiplicity = super.caseMultiplicityElement((MultiplicityElement)property);
        StringBuilder builder = new StringBuilder();
        builder.append(visibility);
        if (property.isDerived()) {
            builder.append("/");
        }
        builder.append(" ");
        builder.append(name);
        builder.append(":");
        builder.append(" ");
        builder.append(typeAsString);
        builder.append(" ");
        builder.append(multiplicity);
        return builder.toString();
    }

    private final String getVisibility(NamedElement namedElement) {
        switch (namedElement.getVisibility()) {
            case PUBLIC_LITERAL: {
                return "+";
            }
            case PROTECTED_LITERAL: {
                return "#";
            }
            case PRIVATE_LITERAL: {
                return "-";
            }
            case PACKAGE_LITERAL: {
                return "~";
            }
        }
        return "+";
    }
}

