/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.papyrus.infra.core.utils.IFilter;

public class FilteredCollectionViewFromIterator<E>
extends AbstractCollection<E>
implements Collection<E> {
    private IteratorProvider<E> iter;
    private IFilter filter;
    private int size = -1;

    public FilteredCollectionViewFromIterator(IteratorProvider<E> iter, IFilter filter) {
        this.iter = iter;
        this.filter = filter;
    }

    public void setBackupCollection(IteratorProvider<E> iter) {
        this.iter = iter;
    }

    Iterator<E> getBackupIterator() {
        return this.iter.iterator();
    }

    public void setFilter(IFilter aFilter) {
        this.filter = aFilter;
    }

    public IFilter getFilter() {
        return this.filter;
    }

    @Override
    public int size() {
        if (this.size == -1) {
            this.size = 0;
            Iterator<E> i = this.iterator();
            while (i.hasNext()) {
                ++this.size;
                i.next();
            }
        }
        return this.size;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    protected E returnedValue(E ele) {
        return ele;
    }

    @Override
    public Iterator<E> iterator() {
        return new FilteredIterator();
    }

    private class FilteredIterator
    implements Iterator<E> {
        E next;
        Iterator<E> listIterator;

        public FilteredIterator() {
            this.listIterator = FilteredCollectionViewFromIterator.this.getBackupIterator();
            this.next = this.nextFilteredObject();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected E nextFilteredObject() {
            while (this.listIterator.hasNext()) {
                Object ele = this.listIterator.next();
                if (!FilteredCollectionViewFromIterator.this.filter.isAllowed(ele)) continue;
                return FilteredCollectionViewFromIterator.this.returnedValue(ele);
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object ele = this.next;
            this.next = this.nextFilteredObject();
            return ele;
        }
    }

    public static interface IteratorProvider<E> {
        public Iterator<E> iterator();
    }
}

