/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.uml.service.types.utils.NamespaceOwnedMemberUtils;
import org.eclipse.uml2.uml.Namespace;

public class ElementOwnedElementCreateCommand
extends EditElementCommand {
    protected final EObject source;
    protected final EObject target;

    public ElementOwnedElementCreateCommand(CreateRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.source = request.getSource();
        this.target = request.getTarget();
    }

    public boolean canExecute() {
        if (this.source == null && this.target == null) {
            return false;
        }
        if (this.source != null && !(this.source instanceof Namespace)) {
            return false;
        }
        if (this.target != null && !(this.target instanceof Namespace)) {
            return false;
        }
        if (!NamespaceOwnedMemberUtils.canContainTarget((Namespace)this.source, (Namespace)this.target)) {
            return false;
        }
        if (this.getSource() == null) {
            return true;
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        if (this.getSource() != null && this.getTarget() != null) {
            Object value = this.getSource().eGet((EStructuralFeature)NamespaceOwnedMemberUtils.getContainmentFeature(this.getSource(), this.getTarget()));
            if (value instanceof List) {
                ((List)value).add(this.getTarget());
            } else if (value != null) {
                this.getSource().eSet((EStructuralFeature)NamespaceOwnedMemberUtils.getContainmentFeature(this.getSource(), this.getTarget()), (Object)this.getTarget());
            }
        }
        return CommandResult.newOKCommandResult();
    }

    protected void setElementToEdit(EObject element) {
        throw new UnsupportedOperationException();
    }

    protected Namespace getSource() {
        return (Namespace)this.source;
    }

    protected Namespace getTarget() {
        return (Namespace)this.target;
    }
}

